/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnIpAddressPair;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnOrIpAddress;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class EgisResponseParser
extends DefaultHandler {
    private static final Class THIS_CLASS = EgisResponseParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String XML_ELEMENT_EGIS_RESPONSE = "EgisResponse";
    private static final String XML_ELEMENT_SECGW = "SecGw";
    private static final String XML_ELEMENT_AIWS = "AIWS";
    private static final String XML_ELEMENT_IP_ADDRESS = "ipAddress";
    private static final String XML_ELEMENT_FQDN = "fqdn";
    private final String egisResponse;
    private boolean inEgisResponseElement = false;
    private boolean inSecGwElement = false;
    private boolean inAiwsElement = false;
    private boolean inIpAddressElement = false;
    private boolean inFqdnElement = false;
    private List securityGateways = new ArrayList();
    private List aiWebServers = new ArrayList();
    private StringBuffer xmlValue = new StringBuffer();

    public EgisResponseParser(String egisResponseIn) {
        this.egisResponse = egisResponseIn;
    }

    public List getSecurityGateWays() {
        return this.securityGateways;
    }

    public List getAiWebServers() {
        return this.aiWebServers;
    }

    public void parse() throws RbsConfigurationFailedException {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(new ByteArrayInputStream(this.egisResponse.getBytes())), (DefaultHandler)this);
        }
        catch (Exception e) {
            logger.traceDebug(THIS_CLASS, "Failed to parse EGIS response: " + e.getMessage());
            throw new RbsConfigurationFailedException("EGIS response parser", "Failed to parse EGIS response: " + e.getMessage(), e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals(XML_ELEMENT_EGIS_RESPONSE)) {
            this.inEgisResponseElement = true;
        } else if (qName.equals(XML_ELEMENT_SECGW) && this.inEgisResponseElement) {
            this.inSecGwElement = true;
        } else if (qName.equals(XML_ELEMENT_AIWS) && this.inEgisResponseElement) {
            this.inAiwsElement = true;
        } else if (qName.equals(XML_ELEMENT_IP_ADDRESS) && (this.inSecGwElement || this.inAiwsElement)) {
            this.inIpAddressElement = true;
        } else if (qName.equals(XML_ELEMENT_FQDN) && (this.inSecGwElement || this.inAiwsElement)) {
            this.inFqdnElement = true;
        }
    }

    public void characters(char[] characters, int start, int length) {
        if (this.inSecGwElement && (this.inIpAddressElement || this.inFqdnElement) || this.inAiwsElement && (this.inIpAddressElement || this.inFqdnElement)) {
            this.xmlValue.append(new String(characters, start, length));
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.equals(XML_ELEMENT_EGIS_RESPONSE)) {
            this.inEgisResponseElement = false;
        } else if (qName.equals(XML_ELEMENT_SECGW)) {
            this.inSecGwElement = false;
        } else if (qName.equals(XML_ELEMENT_AIWS)) {
            this.inAiwsElement = false;
        } else if (qName.equals(XML_ELEMENT_IP_ADDRESS)) {
            if (this.xmlValue.length() > 0) {
                if (this.inSecGwElement) {
                    this.securityGateways.add(new FqdnIpAddressPair(this.xmlValue.toString().trim(), null));
                } else if (this.inAiwsElement) {
                    this.aiWebServers.add(new FqdnOrIpAddress(0, this.xmlValue.toString().trim()));
                }
            }
            this.inIpAddressElement = false;
        } else if (qName.equals(XML_ELEMENT_FQDN)) {
            if (this.xmlValue.length() > 0) {
                if (this.inSecGwElement) {
                    this.securityGateways.add(new FqdnIpAddressPair(null, this.xmlValue.toString().trim()));
                } else if (this.inAiwsElement) {
                    this.aiWebServers.add(new FqdnOrIpAddress(1, this.xmlValue.toString().trim()));
                }
            }
            this.inFqdnElement = false;
        }
        this.xmlValue.setLength(0);
    }
}

