/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse;

import java.net.MalformedURLException;
import java.net.URL;
import se.ericsson.cello.cns.TransferClientException;
import se.ericsson.cello.cns.TransferClientMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.LoopableTransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FetchEgisResponseTp
implements LoopableTransactionPackage {
    private static final Class THIS_CLASS = FetchEgisResponseTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final URL egisUrl;
    private static final String SLOGAN = "Get EGIS data";
    private static final String EXCEPTION_MESSAGE = "Failed to fetch EGIS response";
    private static final int DELAY_BETWEEN_RETRIES = 1000;
    private static final int NBR_OF_RETRIES = 20;
    private static int delayBetweenRetries = 1000;
    private String egisResponseXml = null;
    private boolean successfull;
    private Exception exception;

    public FetchEgisResponseTp() throws RbsConfigurationFailedException {
        try {
            this.egisUrl = new URL("https", "egis.ericsson.net", 443, "/airequest");
        }
        catch (MalformedURLException e) {
            throw new RbsConfigurationFailedException(SLOGAN, "Failed to build EGIS URL", e);
        }
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        try {
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Sending HTTPS request to EGIS", this.egisUrl.toString());
            this.egisResponseXml = TransferClientMgr.getHttpsTransferClient().fetchFile(this.egisUrl);
        }
        catch (TransferClientException e) {
            throw new RbsConfigurationFailedException(SLOGAN, EXCEPTION_MESSAGE, (Exception)((Object)e));
        }
        this.successfull = true;
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public String getEgisResponse() {
        return this.egisResponseXml;
    }

    public static void setDelayBetweenRetriesForBT(int delayBetweenRetriesIn) {
        delayBetweenRetries = delayBetweenRetriesIn;
    }

    public static void resetDelayBetweenRetriesForBT() {
        delayBetweenRetries = 1000;
    }

    public void handleExecutionException(Exception exceptionIn) throws RbsConfigurationFailedException {
        this.exception = exceptionIn;
        logger.traceDebug(THIS_CLASS, "Failed to fetch EGIS response, reason: " + exceptionIn);
    }

    public void handleTransactionException(Exception exceptionIn) throws RbsConfigurationFailedException {
        this.handleExecutionException(exceptionIn);
    }

    public boolean loop(int noOfLoops) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "loop() " + noOfLoops);
        if (!this.successfull) {
            if (noOfLoops >= 20) {
                logger.traceDebug(THIS_CLASS, "Failed to fetch EGIS response, reason: " + this.exception + " after " + noOfLoops + " attempts");
                if (this.exception instanceof RbsConfigurationFailedException) {
                    throw (RbsConfigurationFailedException)((Object)this.exception);
                }
                throw new RbsConfigurationFailedException(SLOGAN, EXCEPTION_MESSAGE, this.exception);
            }
            try {
                Thread.sleep(delayBetweenRetries);
            }
            catch (InterruptedException willNotHappen) {
                logger.traceDebug(THIS_CLASS, "execute() Interrupted will sleeping before next attempt");
            }
            logger.traceDebug(THIS_CLASS, "loop() " + (noOfLoops + 1) * 1000 / 1000 + " seconds");
        }
        logger.traceReturn(THIS_CLASS, "loop() noOfLoops: " + noOfLoops + ", successfull: " + this.successfull);
        return !this.successfull;
    }
}

