/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan;

import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CheckGigabitMoOperationalStateTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateGigabitMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.UnlockGigabitMoTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class CreateGigaBitEthernetMo {
    private static final Class THIS_CLASS = CreateGigaBitEthernetMo.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final int LOOPS_TO_WAIT_AFTER_UNLOCK = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST")) ? 3 : 10;
    public static final int TIME_TO_WAIT_AFTER_UNLOCK = "true".equalsIgnoreCase(System.getProperty("UNIT_TEST")) ? 100 : 1000;

    public GigaBitEthernetMo createNewGigabitEthernetMoInstance(GenericMaoContext genericMaoContext) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createNewGigabitEthernetMoInstance()");
        this.deleteGigabitEthernetMo(genericMaoContext);
        boolean autoNegotiation = true;
        boolean finished = false;
        for (int portNo = 1; portNo <= 2; ++portNo) {
            for (int tryNo = 0; tryNo <= 1; ++tryNo) {
                autoNegotiation = tryNo == 0;
                logger.traceDebug(THIS_CLASS, "Attempting to create GigaBitEthernet with portNo: " + portNo);
                try {
                    TransactionHandler.run(new CreateGigabitMoTp(genericMaoContext, portNo, autoNegotiation));
                    TransactionHandler.run(new UnlockGigabitMoTp(genericMaoContext));
                    for (int i = 0; i < LOOPS_TO_WAIT_AFTER_UNLOCK; ++i) {
                        this.sleep(TIME_TO_WAIT_AFTER_UNLOCK);
                        try {
                            TransactionHandler.run(new CheckGigabitMoOperationalStateTp(genericMaoContext));
                            continue;
                        }
                        catch (RbsConfigurationFailedException rcfe) {
                            if (i >= LOOPS_TO_WAIT_AFTER_UNLOCK - 1) {
                                throw rcfe;
                            }
                            logger.traceDebug(THIS_CLASS, "Waiting for GigabitEthernet operational state (" + i + ")");
                        }
                    }
                    logger.traceDebug(THIS_CLASS, "Successfully created GigaBitEthernet with portNo: " + portNo);
                    RbsConfigurationReportLoggerFactory.getLogger().logAction("GigaBitEthernet", "create", new String[]{"linkType", "portNo", "protectiveMode"}, new String[]{"0", Integer.toString(portNo), "false"});
                    finished = true;
                    break;
                }
                catch (RbsConfigurationFailedException rcfe) {
                    if (portNo != 1) {
                        throw rcfe;
                    }
                    this.deleteGigabitEthernetMoTraceExceptions(genericMaoContext);
                    continue;
                }
            }
            if (finished) break;
        }
        logger.traceReturn(THIS_CLASS, "createNewGigabitEthernetMoInstance()");
        return this.getGigaBitEthernetMo(genericMaoContext, true);
    }

    public void deleteGigabitEthernetMo(GenericMaoContext genericMaoContext) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "deleteGigabitEthernetMo()");
        final GigaBitEthernetMo gigaBitEthernetMo = this.getGigaBitEthernetMo(genericMaoContext, false);
        if (gigaBitEthernetMo != null) {
            TransactionHandler.run(new TransactionPackage(){

                public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
                    gigaBitEthernetMo.delete(coordinator);
                }

                public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
                    throw new RbsConfigurationFailedException("Unexpected exception during delete of GigaBitEthernet MO: " + exception);
                }

                public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
                    this.handleExecutionException(exception);
                }
            });
        }
        logger.traceReturn(THIS_CLASS, "deleteGigabitEthernetMo()");
    }

    public void deleteGigabitEthernetMoTraceExceptions(GenericMaoContext genericMaoContext) {
        logger.traceEnter(THIS_CLASS, "deleteGigabitEthernetMoTraceExceptions()");
        try {
            this.deleteGigabitEthernetMo(genericMaoContext);
        }
        catch (RbsConfigurationFailedException rcfe) {
            logger.traceAbnormal(THIS_CLASS, "Unexpected exception during delete of GigaBitEthernet MO: " + (Object)((Object)rcfe));
        }
        logger.traceReturn(THIS_CLASS, "deleteGigabitEthernetMoTraceExceptions()");
    }

    private GigaBitEthernetMo getGigaBitEthernetMo(GenericMaoContext genericMaoContext, boolean throwExceptionIfNotFound) throws RbsConfigurationFailedException {
        GigaBitEthernetMo result2 = null;
        MoIterator moIt = genericMaoContext.getMoRepositoryWrapper().lookupType("GigaBitEthernet");
        if (moIt != null && moIt.size() > 0) {
            result2 = (GigaBitEthernetMo)moIt.nextMo();
        } else if (throwExceptionIfNotFound) {
            String msg = "Failed to find GigaBitEthernet in MO repository";
            logger.traceDebug(THIS_CLASS, "Failed to find GigaBitEthernet in MO repository");
            throw new RbsConfigurationFailedException("Failed to find GigaBitEthernet in MO repository");
        }
        return result2;
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ie) {
            logger.traceDebug(THIS_CLASS, "Interupted while sleeping: " + ie.getMessage());
        }
    }
}

