/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.LoopableTransactionPackage;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;

public class TransactionHandler {
    private TransactionHandler() {
    }

    public static void run(TransactionPackage transPkg) throws RbsConfigurationFailedException {
        TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
        try {
            Control control = transFact.create(0);
            try {
                transPkg.execute(control.getCoordinator());
                try {
                    control.getTerminator().commit();
                }
                catch (InactiveTransactionException exception) {
                    control.getTerminator().rollback();
                    transPkg.handleTransactionException((Exception)((Object)exception));
                }
                catch (TransactionRolledBackException exception) {
                    transPkg.handleTransactionException((Exception)((Object)exception));
                }
            }
            catch (MoAccessException exception) {
                control.getTerminator().rollback();
                transPkg.handleExecutionException((Exception)((Object)exception));
            }
        }
        catch (TransactionRolledBackException exception) {
            transPkg.handleTransactionException((Exception)((Object)exception));
        }
        catch (InactiveTransactionException exception) {
            transPkg.handleTransactionException((Exception)((Object)exception));
        }
    }

    public static void runWithLoop(LoopableTransactionPackage transPkg) throws RbsConfigurationFailedException {
        int noOfLoops = 0;
        boolean doLoop = true;
        TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
        while (doLoop) {
            try {
                Control control = transFact.create(0);
                try {
                    transPkg.execute(control.getCoordinator());
                    try {
                        control.getTerminator().commit();
                        break;
                    }
                    catch (InactiveTransactionException exception) {
                        control.getTerminator().rollback();
                        transPkg.handleTransactionException((Exception)((Object)exception));
                    }
                    catch (TransactionRolledBackException exception) {
                        transPkg.handleTransactionException((Exception)((Object)exception));
                    }
                }
                catch (Exception exception) {
                    control.getTerminator().rollback();
                    transPkg.handleExecutionException(exception);
                }
            }
            catch (TransactionRolledBackException exception) {
                transPkg.handleTransactionException((Exception)((Object)exception));
            }
            catch (InactiveTransactionException exception) {
                transPkg.handleTransactionException((Exception)((Object)exception));
            }
            doLoop = transPkg.loop(noOfLoops);
            ++noOfLoops;
        }
    }

    public static boolean runWithLoopWithoutException(LoopableTransactionPackage transPkg) {
        boolean successful = false;
        try {
            TransactionHandler.runWithLoop(transPkg);
            successful = true;
        }
        catch (RbsConfigurationFailedException rbsConfigurationFailedException) {
            // empty catch block
        }
        return successful;
    }
}

