/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CheckGigabitMoOperationalStateTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CheckGigabitMoOperationalStateTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;

    public CheckGigabitMoOperationalStateTp(GenericMaoContext aGenericMaoContext) {
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        GigaBitEthernetMo gigabit = (GigaBitEthernetMo)this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
        int operationalState = gigabit.getOperationalState(coordinator);
        if (operationalState == 0) {
            throw new RbsConfigurationFailedException("GigaBitEthernet", "Link not up!");
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "handleExecutionException()");
        if (exception instanceof RbsConfigurationFailedException) {
            logger.traceReturn(THIS_CLASS, "handleExecutionException() " + exception.getMessage());
            throw (RbsConfigurationFailedException)((Object)exception);
        }
        logger.traceReturn(THIS_CLASS, "handleExecutionException() " + exception.getMessage());
        throw new RbsConfigurationFailedException("GigaBitEthernet", "Check status failed.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("GigaBitEthernet", "Check status failed.", exception);
    }
}

