/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import java.util.StringTokenizer;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ConfigureIpMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = ConfigureIpMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final String dnsServerAddress;
    private final String domainName;
    private final int workingMode;

    public ConfigureIpMoTp(GenericMaoContext aGenericMaoContextIn, String dnsServerAddressIn, String domainNameIn, int workingModeIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.dnsServerAddress = dnsServerAddressIn;
        this.domainName = domainNameIn;
        this.workingMode = workingModeIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        IpMo ipMo = (IpMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
        if (ipMo == null) {
            throw new RbsConfigurationFailedException("Ip", "Ip MO not found. LDN: ManagedElement=1,IpOam=1,Ip=1");
        }
        if (RbsConfigurationHelper.existsAndNotEmpty(this.dnsServerAddress)) {
            ipMo.setDnsServerAddresses(this.splitDnsAddresses(this.dnsServerAddress), coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute("Ip", "dnsServer", this.dnsServerAddress);
        }
        if (RbsConfigurationHelper.existsAndNotEmpty(this.domainName)) {
            ipMo.setDefDomainName(this.domainName, coordinator);
            ipMo.setIsDefDomainName(true, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute("Ip", "defDomainName", this.domainName);
        }
        if (ipMo.getWorkingMode(coordinator) != this.workingMode) {
            ipMo.setWorkingMode(this.workingMode, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute("Ip", "workingMode", Integer.toString(this.workingMode));
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Ip", "Unable to configure Ip MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }

    private String[] splitDnsAddresses(String dnsAddressesIn) {
        logger.traceEnter(THIS_CLASS, "splitDnsAddresses(): dnsAddressesIn = " + dnsAddressesIn);
        if (dnsAddressesIn.indexOf(",") == -1) {
            logger.traceReturn(THIS_CLASS, "splitDnsAddresses(): dnsAddressesIn = " + dnsAddressesIn);
            return new String[]{dnsAddressesIn};
        }
        StringTokenizer stringTokenizerDnsAddresses = new StringTokenizer(dnsAddressesIn, ",");
        String[] result2 = new String[stringTokenizerDnsAddresses.countTokens()];
        int i = 0;
        while (stringTokenizerDnsAddresses.hasMoreElements()) {
            result2[i] = stringTokenizerDnsAddresses.nextElement().toString();
            ++i;
        }
        logger.traceReturn(THIS_CLASS, "splitDnsAddresses(): result = " + result2);
        return result2;
    }
}

