/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.accesscontrol.AccessControl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.accesscontrol.CreateInitialAclEntries;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateAccessControlListMoTp
implements TransactionPackage,
AccessControl {
    private static final Class THIS_CLASS = CreateAccessControlListMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepositoryWrapper;
    private final MoFactoryMgrWrapper moFactoryMgrWrapper;
    private final String outerIpAddress;
    private final String smrsAddress;

    public CreateAccessControlListMoTp(GenericMaoContext aGenericMaoContextIn, String ipAddressIn, RbsConfigurationMao rbsConfiguration) {
        this.moRepositoryWrapper = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.moFactoryMgrWrapper = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.outerIpAddress = ipAddressIn;
        this.smrsAddress = FileParameters.instance(rbsConfiguration).getSmrsAddress();
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute() smrsAddress:" + this.smrsAddress + ", outerIpAddress:" + this.outerIpAddress);
        ManagedObject accessControlList = this.createInitialAcl(coordinator);
        this.insertAclRefInIpInterface(accessControlList, coordinator);
        logger.traceReturn(THIS_CLASS, "create()");
    }

    private void insertAclRefInIpInterface(ManagedObject accessControlList, Coordinator coordinator) throws MoNotFoundException, RbsConfigurationFailedException {
        IpInterfaceMo ipInterface = (IpInterfaceMo)this.moRepositoryWrapper.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
        if (ipInterface == null) {
            throw new MoNotFoundException("Correct IpInterface MO was not found");
        }
        try {
            ipInterface.setAccessControlListRef(accessControlList, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute(ipInterface.getRelativeDistinguishedName(), "accessControlListRef", accessControlList.getRelativeDistinguishedName());
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("O&M Prepare IP Configuration", "Unable to set reference to AccessControlList MO.", (Exception)((Object)mae));
        }
    }

    private ManagedObject createInitialAcl(Coordinator coordinator) throws MoAccessException {
        String aclId = "initAcl";
        ManagedObject ipSystemMo = this.moRepositoryWrapper.lookup("ManagedElement=1,IpSystem=1");
        if (ipSystemMo == null) {
            throw new MoNotFoundException("IpSystem MO was not found");
        }
        Struct[] aclEntries = new CreateInitialAclEntries(this.outerIpAddress, this.smrsAddress).createInitialAclEntries();
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement("aclEntries", (Object)aclEntries);
        attrList.addElement("userLabel", (Object)"O&M Prepare IP Configuration");
        String[] attributeStrings = new String[attrList.size()];
        Object[] valueStrings = new Object[attrList.size()];
        for (int i = 0; i < attrList.size(); ++i) {
            attributeStrings[i] = attrList.getName(i);
            valueStrings[i] = attrList.getValue(i);
        }
        MoFactory moFactory = this.moFactoryMgrWrapper.lookup("AccessControlList");
        ManagedObject accessControlListMo = moFactory.createMo(ipSystemMo, (AttrList)attrList, "initAcl", null, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("AccessControlList", "create", attributeStrings, valueStrings);
        return accessControlListMo;
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("O&M Prepare IP Configuration", "Unable to create AccessControlList MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("O&M Prepare IP Configuration", "Unable to create AccessControlList MO. Caught a transaction exception.", exception);
    }
}

