/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IkePeerData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIkePeerMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIkePeerMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;
    private final GenericMaoContext aGenericMaoContext;
    private final IkePeerData ikePeerData;

    public CreateIkePeerMoTp(GenericMaoContext aGenericMaoContextIn, IkePeerData ikePeerDataIn) {
        this.aGenericMaoContext = aGenericMaoContextIn;
        this.ikePeerData = ikePeerDataIn;
        this.aMoRepository = this.aGenericMaoContext.getMoRepositoryWrapper();
        this.aMoFactoryMgr = this.aGenericMaoContext.getMoFactoryMgrWrapper();
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute");
        ManagedObject ipSec = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        AttrListImpl attrList = this.ikePeerData.createIkePeerAttrList();
        MoFactory ikePeerFactory = this.aMoFactoryMgr.lookup("IkePeer");
        ikePeerFactory.createMo(ipSec, (AttrList)attrList, "1", null, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("IkePeer", "create", new String[]{"SecGw IP address", "Peer ID type", "Peer ID address", "Peer ID FQDN"}, new String[]{this.ikePeerData.getPeerIpAddress(), this.ikePeerData.getPeerIdentityIdType(), this.ikePeerData.getPeerIdentityIpv4Address(), this.ikePeerData.getPeerIdentityIdFqdn()});
        logger.traceReturn(THIS_CLASS, "execute");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create IkePeer MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

