/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIpAccessHostEtMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpAccessHostEtMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;
    private final String ipAddress;
    private final String referencedInterface;
    private final boolean autoConfiguration;

    public CreateIpAccessHostEtMoTp(GenericMaoContext aGenericMaoContextIn, String ipAddr, String referencedInterfaceIn, boolean autoConfigurationIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.ipAddress = ipAddr;
        this.referencedInterface = referencedInterfaceIn;
        this.autoConfiguration = autoConfigurationIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        ManagedObject ipSystem = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1");
        ManagedObject referencedIpInterface = this.aMoRepository.lookup(this.referencedInterface);
        AttrListImpl attrList = new AttrListImpl();
        if (!this.autoConfiguration) {
            attrList.addElement("ipAddress", (Object)this.ipAddress);
        }
        attrList.addElement("ipInterfaceMoRef", (Object)referencedIpInterface);
        MoFactory ipAccessHostEtFactory = this.aMoFactoryMgr.lookup("IpAccessHostEt");
        ipAccessHostEtFactory.createMo(ipSystem, (AttrList)attrList, "1", null, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("IpAccessHostEt", "create", new String[]{"ipAddress", "ipInterfaceMoRef"}, new String[]{this.ipAddress, referencedIpInterface.toString()});
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create IpAccessHostEt MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

