/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIpHostLinkMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpHostLinkMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;
    private final String ipAddress;

    public CreateIpHostLinkMoTp(GenericMaoContext aGenericMaoContextIn, String ipAddressIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.ipAddress = ipAddressIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        ManagedObject ipMo = this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
        ManagedObject ipInterfaceMo = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
        MoFactory ipHostLinkFactory = this.aMoFactoryMgr.lookup("IpHostLink");
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement("ipInterfaceMoRef", (Object)ipInterfaceMo);
        attrList.addElement("ipAddress", (Object)this.ipAddress);
        ipHostLinkFactory.createMo(ipMo, (AttrList)attrList, "1", null, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("IpHostLink", "create", new String[]{"ipInterfaceMoRef", "ipAddress"}, new String[]{ipInterfaceMo.getRelativeDistinguishedName(), this.ipAddress});
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create IpHostLink MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

