/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIpHostLinkMoVpnTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpHostLinkMoVpnTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;
    private final String ipAddress;
    private final boolean autoConfig;

    public CreateIpHostLinkMoVpnTp(GenericMaoContext aGenericMaoContextIn, String ipAddr, boolean autoConf) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.ipAddress = ipAddr;
        this.autoConfig = autoConf;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        String actionAttrName = "ipv6Addresses";
        ManagedObject ipMo = this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
        ManagedObject vpnInterfaceMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,VpnInterface=1");
        MoFactory ipHostLinkFactory = this.aMoFactoryMgr.lookup("IpHostLink");
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement("ipInterfaceMoRef", (Object)vpnInterfaceMo);
        if (!this.autoConfig && this.ipAddress.indexOf(":") != -1) {
            String[] ipAddressAttributes = new String[]{"ipAddress", "prefixLength"};
            Object[] ipAddressValues = new Object[]{this.ipAddress, RbsConfigurationDefinitions.IPV6_INTERFACE_DEFAULT_PREFIX_LENGTH};
            StructImpl ipAddressStruct = new StructImpl(ipAddressAttributes, ipAddressValues);
            Struct[] ipv6Addresses = new Struct[]{ipAddressStruct};
            attrList.addElement("ipv6Addresses", (Object)ipv6Addresses);
        } else if (!this.autoConfig) {
            String[] ipv4Addresses = new String[]{this.ipAddress};
            attrList.addElement("ipv4Addresses", (Object)ipv4Addresses);
            actionAttrName = "ipv4Addresses";
        }
        ipHostLinkFactory.createMo(ipMo, (AttrList)attrList, "1", null, coordinator);
        if (this.autoConfig) {
            RbsConfigurationReportLoggerFactory.getLogger().logAction("IpHostLink", "create", new String[]{"ipInterfaceMoRef"}, new String[]{vpnInterfaceMo.getRelativeDistinguishedName()});
        } else {
            RbsConfigurationReportLoggerFactory.getLogger().logAction("IpHostLink", "create", new String[]{"ipInterfaceMoRef", actionAttrName}, new String[]{vpnInterfaceMo.getRelativeDistinguishedName(), this.ipAddress});
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create IpHostLink MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

