/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import java.io.IOException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIpInterfaceMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpInterfaceMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;
    private final String defaultGateway;
    private final String subnetMask;
    private final IpParameters storedIpParameters;
    private final boolean useDhcp;

    public CreateIpInterfaceMoTp(GenericMaoContext aGenericMaoContextIn, String defaultGatewayIn, String subnetMaskIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.defaultGateway = defaultGatewayIn;
        this.subnetMask = subnetMaskIn;
        this.storedIpParameters = null;
        this.useDhcp = false;
    }

    public CreateIpInterfaceMoTp(GenericMaoContext aGenericMaoContextIn, IpParameters ipParametersIn, boolean useDhcpIn) {
        this.storedIpParameters = ipParametersIn;
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.defaultGateway = this.storedIpParameters.getOuterIpConfigurationData().getOuterDefaultRouterZero();
        this.subnetMask = ipParametersIn.getOuterIpConfigurationData().getOuterSubnetMask();
        this.useDhcp = useDhcpIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        Integer networkPrefixLength = new Integer(24);
        if (!this.useDhcp && this.subnetMask != null && this.subnetMask.trim().length() > 0) {
            try {
                networkPrefixLength = RbsConfigurationIpHelperImpl.calculateNetworkPrefixLength(this.subnetMask);
            }
            catch (IOException ioe) {
                throw new RbsConfigurationFailedException("IpInterface", "Fault in calculating networkPrefixLength, subnetMask:" + this.subnetMask, ioe);
            }
        }
        ManagedObject gigabitMo = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
        MoFactory ipInterfaceFactory = this.aMoFactoryMgr.lookup("IpInterface");
        AttrListImpl attrList = new AttrListImpl();
        if (this.useDhcp) {
            attrList.addElement("configurationMode", (Object)RbsConfigurationDefinitions.IP_INTERFACE_CONFIGURATION_MODE_DHCP);
        } else {
            attrList.addElement("defaultRouter0", (Object)this.defaultGateway);
            attrList.addElement("networkPrefixLength", (Object)networkPrefixLength);
        }
        attrList.addElement("rps", (Object)Boolean.FALSE);
        if (this.storedIpParameters != null && this.storedIpParameters.getVlanId() > 0) {
            attrList.addElement("vLan", (Object)Boolean.TRUE);
            attrList.addElement("vid", (Object)new Integer(this.storedIpParameters.getVlanId()));
        }
        ipInterfaceFactory.createMo(gigabitMo, (AttrList)attrList, "1", null, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("IpInterface", "create", new String[]{"defaultRouter0", "networkPrefixLength", "rps"}, new String[]{this.defaultGateway, networkPrefixLength != null ? networkPrefixLength.toString() : "null", "false"});
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create IpInterface MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

