/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import java.io.IOException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecTunnelData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIpSecTunnelMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpSecTunnelMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;
    private final GenericMaoContext aGenericMaoContext;
    private final IpSecTunnelData ipsecTunnelData;

    public CreateIpSecTunnelMoTp(GenericMaoContext aGenericMaoContextIn, IpSecTunnelData ipSecTunnelDataIn) {
        this.aGenericMaoContext = aGenericMaoContextIn;
        this.ipsecTunnelData = ipSecTunnelDataIn;
        this.aMoRepository = this.aGenericMaoContext.getMoRepositoryWrapper();
        this.aMoFactoryMgr = this.aGenericMaoContext.getMoFactoryMgrWrapper();
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute");
        ManagedObject ipSec = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        ManagedObject ikePeerRef = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1,IkePeer=1");
        ManagedObject vpnInterfaceRef = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,VpnInterface=1");
        try {
            AttrListImpl attrList = this.ipsecTunnelData.createIpSecTunnelAttrList(ikePeerRef, vpnInterfaceRef);
            MoFactory ipSecTunnelFactory = this.aMoFactoryMgr.lookup("IpSecTunnel");
            ipSecTunnelFactory.createMo(ipSec, (AttrList)attrList, "1", null, coordinator);
        }
        catch (IOException e) {
            throw new RbsConfigurationFailedException("Unable to create IpSecTunnel MO", e.getMessage());
        }
        RbsConfigurationReportLoggerFactory.getLogger().logAction("IpSecTunnel", "create", new String[]{"vpnInterfaceRef"}, new String[]{vpnInterfaceRef.getFullDistinguishedName()});
        logger.traceReturn(THIS_CLASS, "execute");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        String slogan = "Failure creating MO";
        String faultMsg = "Failure during create of IPSec tunnel Mo.";
        throw new RbsConfigurationFailedException("Failure creating MO", "Failure during create of IPSec tunnel Mo.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        String slogan = "Transaction failure";
        String faultMsg = "The transaction used when creating the IPSec tunnel is inactive.";
        throw new RbsConfigurationFailedException("Transaction failure", "The transaction used when creating the IPSec tunnel is inactive.", exception);
    }
}

