/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.DhcpMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnIpAddressPair;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationDhcpHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecGwAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.WebServerAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.pbootparam.PbootParamProxyFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.SerialNumber;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisStateMonitor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.LoopableTransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class FetchDhcpDataTp
implements LoopableTransactionPackage {
    private static final Class THIS_CLASS = FetchDhcpDataTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepositoryWrapper;
    private final RbsConfigurationMao rbsConfigurationMao;
    private int[] dhcpOptions = new int[0];
    private final Object MUTEX = new Object();
    private final RbsConfigurationHelper helper;
    private final boolean validateSmrsData;
    public static final String DHCP_CLIENT_IDENTIFIER = "dhcpClientIdentifier";
    public static final String DHCP_TYPE = "Dhcp";
    public static final String DHCP_LDN = "ManagedElement=1,IpOam=1,Dhcp=1";

    public FetchDhcpDataTp(GenericMaoContext genericMaoContextIn, RbsConfigurationMao rbsConfigurationMaoIn, int[] dhcpOptionsIn) {
        logger.traceEnter(THIS_CLASS, "FetchDhcpDatatTp() dhcpClientIdentifier = " + NodeParameters.instance(rbsConfigurationMaoIn).getDhcpClientIdentifier());
        this.moRepositoryWrapper = genericMaoContextIn.getMoRepositoryWrapper();
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.dhcpOptions = dhcpOptionsIn;
        this.helper = (RbsConfigurationHelper)rbsConfigurationMaoIn.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
        this.validateSmrsData = true;
        logger.traceReturn(THIS_CLASS, "FetchDhcpDatatTp()");
    }

    public FetchDhcpDataTp(GenericMaoContext genericMaoContextIn, RbsConfigurationMao rbsConfigurationMaoIn, int[] dhcpOptionsIn, boolean validateSmrsDataIn) {
        logger.traceEnter(THIS_CLASS, "FetchDhcpDatatTp() dhcpClientIdentifier = " + NodeParameters.instance(rbsConfigurationMaoIn).getDhcpClientIdentifier());
        this.moRepositoryWrapper = genericMaoContextIn.getMoRepositoryWrapper();
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.dhcpOptions = dhcpOptionsIn;
        this.helper = (RbsConfigurationHelper)rbsConfigurationMaoIn.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
        this.validateSmrsData = validateSmrsDataIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        DhcpMo dhcp = (DhcpMo)this.moRepositoryWrapper.lookup(DHCP_LDN);
        if (dhcp == null) {
            String slogan = "MO not found";
            String faultMsg = "Could not find the Dhcp MO.";
            throw new RbsConfigurationFailedException("MO not found", "Could not find the Dhcp MO.");
        }
        try {
            Struct dhcpResult;
            String serialNumber = PbootParamProxyFactory.getPbootParamProxy().getPbootParameter("fru_serialnumber");
            if (serialNumber == null) {
                logger.traceDebug(THIS_CLASS, "fru_serialnumber not found in PBOOT parameters, trying to find serialnumber");
                serialNumber = PbootParamProxyFactory.getPbootParamProxy().getPbootParameter("serialnumber");
                if (serialNumber == null) {
                    logger.traceError(THIS_CLASS, "serialnumber not found in PBOOT parameters also");
                    serialNumber = this.getSerialNumber(coordinator);
                }
            }
            logger.traceDebug(THIS_CLASS, "dhcpOptions.length:" + this.dhcpOptions.length + " HW serial number: " + serialNumber);
            if (NodeParameters.instance(this.rbsConfigurationMao).getDhcpClientIdentifier().length() < 2) {
                dhcpResult = dhcp.actionGetDhcpData(this.dhcpOptions.length, this.dhcpOptions, serialNumber, "lh0", coordinator);
                this.rbsConfigurationMao.setReadOnlyAttribute(DHCP_CLIENT_IDENTIFIER, serialNumber);
                logger.traceDebug(THIS_CLASS, "GetDhcpData was sent with DhcpClientIdentifier: " + serialNumber);
            } else {
                dhcpResult = dhcp.actionGetDhcpData(this.dhcpOptions.length, this.dhcpOptions, NodeParameters.instance(this.rbsConfigurationMao).getDhcpClientIdentifier(), "lh0", coordinator);
            }
            RbsConfigurationDhcpHelper dhcpHelper = new RbsConfigurationDhcpHelper(dhcpResult);
            String[] ntpAddresses = this.convertDhcpReply(dhcpHelper.getNtpIpAddress());
            IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
            ip.setIpAddress(dhcpHelper.getIpAddress());
            ip.setSubnetMask(dhcpHelper.getSubnetMask());
            ip.setDefaultRouter(dhcpHelper.getDefaultGateway());
            ip.setDnsServerAddress(dhcpHelper.getDnsIpAddress());
            if (ntpAddresses != null && ntpAddresses.length > 0) {
                ip.setNtpServerAddress(ntpAddresses[0]);
            }
            FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
            if (!EgisStateMonitor.getInstance().getIsEgisResponseFetched() && !RbsConfigurationHelper.existsAndNotEmpty(fp.getSiteInstallationFilePath())) {
                ip.setDefaultDomainName(dhcpHelper.getDefaultDomainName());
                ip.setDomainName(dhcpHelper.getDomainName());
                fp.setSmrsAddress(dhcpHelper.getSmrsIpAddress());
                fp.setSmrsSummaryFilePath(dhcpHelper.getSummaryAbsolutePathname());
                WebServerAddresses webServerAddresses = WebServerAddresses.instance(this.rbsConfigurationMao);
                SecGwAddresses secGwAddresses = SecGwAddresses.instance(this.rbsConfigurationMao);
                if (this.dhcpOptionsHasWebServerOption() && dhcpHelper.getWebServerAddress().length > 0) {
                    webServerAddresses.setWebServerAddresses(dhcpHelper.getWebServerAddress());
                    logger.traceDebug(THIS_CLASS, "Get Web Server from DHCP");
                    logger.traceDebug(THIS_CLASS, webServerAddresses.toString());
                } else if (this.dhcpOptionsHasSecGwOption() && dhcpHelper.getSecGwAddress().length > 0) {
                    secGwAddresses.setSecGwAddresses(dhcpHelper.getSecGwAddress());
                }
                RbsConfigurationReportLoggerFactory.getLogger().logAttributes("Dhcp response", new String[]{"ipAddress", "subnetMask", "defaulRouter0", "dnsServerAddresses", "ntpServerAddresses", "defDomainName", "DomainName", "smrsAddress", "smrsSummaryFilePath", "webServerAddresses", "SecGw Addresses"}, new Object[]{ip.getIpAddress(), ip.getSubnetMask(), ip.getDefaultRouter(), ip.getDnsServerAddress(), ip.getNtpServerAddress(), ip.getDefaultDomainName(), ip.getDomainName(), fp.getSmrsAddress(), fp.getSmrsSummaryFilePath(), this.convertDhcpReply(dhcpHelper.getWebServerAddress()), this.convertDhcpReply(dhcpHelper.getSecGwAddress())});
            } else if (RbsConfigurationHelper.existsAndNotEmpty(fp.getSiteInstallationFilePath())) {
                SecGwAddresses.instance(this.rbsConfigurationMao).pushSecGwAddress(new FqdnIpAddressPair(ip.getOuterIpConfigurationData().getInitialSecGwIpAdd(), ip.getOuterIpConfigurationData().getInitialSecGwFqdn()));
                logger.traceDebug(THIS_CLASS, "SecGw from SiteInstalltion will be used for Ip Configuration: " + ip.getOuterIpConfigurationData().getInitialSecGwIpAdd());
            }
            if (!EgisStateMonitor.getInstance().getIsEgisResponseFetched()) {
                this.validateIpData();
                if (!this.dhcpOptionsHasWebServerOption() && !this.dhcpOptionsHasSecGwOption() && this.validateSmrsData) {
                    this.validateSmrsData();
                }
            }
        }
        catch (MoAccessException mae) {
            String slogan = "DHCP failure";
            String faultMsg = "Failure at retrieve of dhcp data.";
            throw new RbsConfigurationFailedException("DHCP failure", "Failure at retrieve of dhcp data.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "fetchDhcpData()");
    }

    private boolean dhcpOptionsHasWebServerOption() {
        boolean webServerOption = false;
        for (int k = 0; k < this.dhcpOptions.length; ++k) {
            if (this.dhcpOptions[k] != 72) continue;
            webServerOption = true;
            break;
        }
        return webServerOption;
    }

    private boolean dhcpOptionsHasSecGwOption() {
        boolean secGwServerOption = false;
        for (int k = 0; k < this.dhcpOptions.length; ++k) {
            if (this.dhcpOptions[k] != 241) continue;
            secGwServerOption = true;
            break;
        }
        return secGwServerOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] convertDhcpReply(int[] addresses) {
        if (addresses == null) {
            addresses = new int[]{};
        }
        int noOfAddresses = addresses.length / 4;
        Object object = this.MUTEX;
        synchronized (object) {
            String[] newAddresses = new String[noOfAddresses];
            for (int a = 0; a < noOfAddresses; ++a) {
                StringBuffer ab = new StringBuffer();
                for (int b = 0; b < 4; ++b) {
                    ab.append((b == 0 ? "" : ".") + addresses[a * 4 + b]);
                }
                newAddresses[a] = ab.toString();
            }
            return newAddresses;
        }
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("DHCP failed", "Unable to retrieve DHCP data.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }

    public boolean loop(int noOfLoops) {
        this.helper.waitForRetry(THIS_CLASS.getName());
        return true;
    }

    private void validateIpData() throws RbsConfigurationFailedException {
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        if (!(RbsConfigurationHelper.existsAndNotEmpty(ip.getIpAddress()) && RbsConfigurationHelper.existsAndNotEmpty(ip.getSubnetMask()) && RbsConfigurationHelper.existsAndNotEmpty(ip.getDefaultRouter()))) {
            String slogan = "IP Configuration";
            String faultMsg = "Mandatory attribute for IP configuration is missing in DHCP respons.";
            throw new RbsConfigurationFailedException("IP Configuration", "Mandatory attribute for IP configuration is missing in DHCP respons.");
        }
    }

    private void validateSmrsData() throws RbsConfigurationFailedException {
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        if (this.isSmrsInfoNeeded() && !this.isSmrsInfoAvailable(fp.getSmrsAddress(), fp.getSmrsSummaryFilePath())) {
            throw new RbsConfigurationFailedException("Mandatory attribute for connection to SMRS is missing in DHCP respons!");
        }
    }

    private boolean isSmrsInfoNeeded() {
        FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
        UpgradeParameters up = UpgradeParameters.instance(this.rbsConfigurationMao);
        return !this.attributeExistsAndIsNotEmpty(fp.getSiteBasicFilePath()) || !this.attributeExistsAndIsNotEmpty(fp.getSiteEquipmentFilePath()) || !this.attributeExistsAndIsNotEmpty(up.getUpgradePackageFilePath()) || !this.attributeExistsAndIsNotEmpty(fp.getLicenseKeyFilePath());
    }

    private boolean isSmrsInfoAvailable(String dhcpSmrsIpAddress, String dhcpSmrsSummaryFilePath) {
        return !(!RbsConfigurationHelper.existsAndNotEmpty(dhcpSmrsIpAddress) && !this.attributeExistsAndIsNotEmpty(FileParameters.instance().getSmrsAddress()) || !RbsConfigurationHelper.existsAndNotEmpty(dhcpSmrsSummaryFilePath) && !this.attributeExistsAndIsNotEmpty(FileParameters.instance().getSmrsSummaryFilePath()));
    }

    private boolean attributeExistsAndIsNotEmpty(String attributeName) {
        return RbsConfigurationHelper.existsAndNotEmpty(attributeName);
    }

    final String getSerialNumber(Coordinator coordinator) throws MoAccessException {
        SerialNumber serialNo = new SerialNumber();
        return serialNo.getSerialNumber(this.moRepositoryWrapper, coordinator);
    }
}

