/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.licensing.LicensingMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class InstallLicenseTp
implements TransactionPackage {
    private static final Class THIS_CLASS = InstallLicenseTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private boolean licenseKeyFileIsRemote;
    private final RbsConfigurationMao rbsConfiguration;
    private final MoRepositoryWrapper moRepository;
    private final RbsConfigurationHelper rbsConfigurationHelper;
    private final FileParameters fp;

    public InstallLicenseTp(RbsConfigurationMao rbsConfigurationIn, MoRepositoryWrapper moRepositoryIn, RbsConfigurationHelper rbsConfigurationHelperIn) {
        this.rbsConfiguration = rbsConfigurationIn;
        this.moRepository = moRepositoryIn;
        this.rbsConfigurationHelper = rbsConfigurationHelperIn;
        this.fp = FileParameters.instance(this.rbsConfiguration);
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.licenseKeyFileIsRemote = true;
        this.handleLicenseKeyFile(coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void handleLicenseKeyFile(Coordinator coordinator) throws MoAccessException {
        if (RbsConfigurationHelper.existsAndNotEmpty(this.fp.getLicenseKeyFilePath()) && !"DoNoTuSeVaLuEfRoMsUmMaRy".equals(this.fp.getLicenseKeyFilePath())) {
            this.licenseKeyFileIsRemote = false;
            this.handleLocalLicenseKeyFile(coordinator);
        } else if (RbsConfigurationHelper.existsAndNotEmpty(this.fp.getLicenseKeyRemotePath()) && !"DoNoTuSeVaLuEfRoMsUmMaRy".equals(this.fp.getLicenseKeyRemotePath())) {
            this.handleRemoteLicenseKeyFile(coordinator);
        } else {
            String infoMsg = "No License Key File specified.";
            ProgressReportHandler.getInstance().updateProgressReportInformation(800, 2, "No License Key File specified.", true);
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Licensing", "No License Key File specified.");
        }
    }

    private void handleLocalLicenseKeyFile(Coordinator coordinator) throws MoAccessException {
        logger.traceDebug(THIS_CLASS, "Installing local license: " + this.fp.getLicenseKeyFilePath());
        ProgressReportHandler.getInstance().updateProgressReportInformation(800, 3, "Installing local license key file: " + StringHelper.doubleQuote((String)this.fp.getLicenseKeyFilePath()), true);
        LicensingMo licensingMo = (LicensingMo)this.moRepository.lookup("ManagedElement=1,SystemFunctions=1,Licensing=1");
        this.rbsConfigurationHelper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_INSTALLING_LICENSE_KEY);
        licensingMo.actionUpdateLicenseKeyFile("rbs", "change_me", "127.0.0.1", this.fp.getLicenseKeyFilePath(), coordinator);
        ProgressReportHandler.getInstance().updateProgressReportInformation(800, 5, "Successfully installed local license key file: " + StringHelper.doubleQuote((String)this.fp.getLicenseKeyFilePath()), true);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("Licensing", "UpdateLicenseKeyFile", "FilePath", this.fp.getLicenseKeyFilePath());
    }

    private void handleRemoteLicenseKeyFile(Coordinator coordinator) throws MoAccessException {
        logger.traceDebug(THIS_CLASS, "Installing remote license: " + this.fp.getLicenseKeyRemotePath());
        ProgressReportHandler.getInstance().updateProgressReportInformation(800, 3, "Installing remote license key file: " + StringHelper.doubleQuote((String)this.fp.getLicenseKeyRemotePath()), true);
        LicensingMo licensingMo = (LicensingMo)this.moRepository.lookup("ManagedElement=1,SystemFunctions=1,Licensing=1");
        this.rbsConfigurationHelper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_INSTALLING_LICENSE_KEY);
        licensingMo.actionUpdateLicenseKeyFile(this.fp.getSmrsUserName(), this.fp.getSmrsPassword(), this.fp.getSmrsAddress(), this.fp.getLicenseKeyRemotePath(), coordinator);
        ProgressReportHandler.getInstance().updateProgressReportInformation(800, 5, "Successfully installed remote license key file: " + StringHelper.doubleQuote((String)this.fp.getLicenseKeyRemotePath()), true);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("Licensing", "UpdateLicenseKeyFile", "FilePath", this.fp.getLicenseKeyRemotePath());
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        String reason = " Reason: " + ExceptionHelper.getExceptionMessage((Throwable)exception);
        String localErrorMsg = "Failed to install local license key file: " + StringHelper.doubleQuote((String)this.fp.getLicenseKeyFilePath()) + reason;
        String remoteErrorMsg = "Failed to install remote license key file: " + StringHelper.doubleQuote((String)this.fp.getLicenseKeyRemotePath()) + reason;
        String errorMsg = this.licenseKeyFileIsRemote ? remoteErrorMsg : localErrorMsg;
        ProgressReportHandler.getInstance().updateProgressReportInformation(800, 0, errorMsg, true);
        this.rbsConfigurationHelper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_LICENSING_FAULT, "Licensing failure", errorMsg);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        this.rbsConfigurationHelper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Transaction failure", "Install License Key file, Transaction failure. Retrying");
    }
}

