/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ModifyDefaultStaticRouteTp
implements TransactionPackage {
    private static final Class THIS_CLASS = ModifyDefaultStaticRouteTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final String newNextHop;
    private final String oldNextHop;

    public ModifyDefaultStaticRouteTp(GenericMaoContext aGenericMaoContext, String inOldNextHop, String inNewNextHop) {
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.oldNextHop = inOldNextHop;
        this.newNextHop = inNewNextHop;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
        String[] staticRouteAttrNames = new String[]{"indexOfStaticRoute", "ipAddress", "networkMask", "nextHopIpAddr", "routeMetric", "redistribute"};
        Object[] oldStaticRouteValues = new Object[]{new Integer(1), "0.0.0.0", "0.0.0.0", this.oldNextHop, new Integer(16), Boolean.FALSE};
        Object[] newStaticRouteValues = new Object[]{new Integer(1), "0.0.0.0", "0.0.0.0", this.newNextHop, new Integer(16), Boolean.FALSE};
        StructImpl oldStaticRoute = new StructImpl(staticRouteAttrNames, oldStaticRouteValues);
        StructImpl newStaticRoute = new StructImpl(staticRouteAttrNames, newStaticRouteValues);
        ipRoutingTableMo.actionModifyStaticRoute((Struct)oldStaticRoute, (Struct)newStaticRoute, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("IpRoutingTable", "actionModifyStaticRoute", new String[]{"oldStaticRoute", "newStaticRoute"}, new Object[]{oldStaticRoute, newStaticRoute});
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        RbsConfigurationReportLoggerFactory.getLogger().logInformation("IpRoutingTable", "Unable to modify the static route. " + ExceptionHelper.convertToString((Throwable)exception));
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

