/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpHostLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RemoveOriginalIpConfigurationTp
implements TransactionPackage {
    private static final Class THIS_CLASS = RemoveOriginalIpConfigurationTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepository;
    private SiteBasicData siteBasicData = null;

    public RemoveOriginalIpConfigurationTp(GenericMaoContext aGenericMaoContextIn) {
        this.moRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
    }

    public RemoveOriginalIpConfigurationTp(SiteBasicData inSiteBasicData, GenericMaoContext aGenericMaoContextIn) {
        this.moRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.siteBasicData = inSiteBasicData;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.setNodeInterfaceName(coordinator);
        this.removeOriginalIpHostLinkMo(coordinator);
        this.removeOriginalStaticRoute(coordinator);
        this.removeOriginalIpInterfaceMo(coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void setNodeInterfaceName(Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            ManagedObject ipMo = this.moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
            String nodeInterfaceName = "le0";
            ipMo.setAttribute("nodeInterfaceName", (Object)"le0", coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute(ipMo.getRelativeDistinguishedName(), "nodeInterfaceName", "le0");
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("SiteBasic failure", "Unable to set NodeInterface name when removing original ip config.", (Exception)((Object)mae));
        }
    }

    private void removeOriginalIpHostLinkMo(Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            IpHostLinkMo originalIpHostLink = (IpHostLinkMo)this.moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
            RbsConfigurationReportLoggerFactory.getLogger().logAction(originalIpHostLink.getType(), "Delete", "LDN", "ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
            originalIpHostLink.delete(coordinator);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("Site Basic", "Unable to delete temporary IpHostLink MO.", (Exception)((Object)mae));
        }
    }

    private void removeOriginalStaticRoute(Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            IpInterfaceMo ipInterfaceMo = (IpInterfaceMo)this.moRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
            String defaultRoute0 = ipInterfaceMo.getDefaultRouter0(coordinator);
            IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)this.moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
            int numberOfRoutes = ipRoutingTableMo.actionNumberOfRoutes(coordinator);
            for (int index = 0; index < numberOfRoutes; ++index) {
                Struct routingTableEntry = ipRoutingTableMo.actionGetRoutingTableEntry(index, coordinator);
                String nextHopIpAddress = (String)routingTableEntry.getValue("nextHopIpAddr");
                String destinationIpAddr = (String)routingTableEntry.getValue("destinationIpAddr");
                String destinationNetworkMask = (String)routingTableEntry.getValue("destinationNetworkMask");
                if (!defaultRoute0.equalsIgnoreCase(nextHopIpAddress) || !"0.0.0.0".equalsIgnoreCase(destinationIpAddr) || !"0.0.0.0".equalsIgnoreCase(destinationNetworkMask)) continue;
                ipRoutingTableMo.actionDeleteStaticRoute(routingTableEntry, coordinator);
                RbsConfigurationReportLoggerFactory.getLogger().logAction("IpRoutingTable", "actionDeleteStaticRoute", new String[]{"destinationIpAddr", "destinationNetworkMask", "nextHopIpAddr"}, new String[]{"0.0.0.0", "0.0.0.0", defaultRoute0});
                break;
            }
        }
        catch (MoAccessException mae) {
            if (mae instanceof RbsConfigurationFailedException) {
                throw (RbsConfigurationFailedException)mae;
            }
            throw new RbsConfigurationFailedException("SiteBasic failure", "Unable to remove temporary static route", (Exception)((Object)mae));
        }
    }

    private void removeOriginalIpInterfaceMo(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeOriginalIpInterfaceMo");
        boolean isReferenced = false;
        IpAccessHostEtData[] ipAccessHostEtData = null;
        IpInterfaceData[] ipInterfaceData = null;
        IpHostLinkData ipHostLinkData = null;
        try {
            String relativeName;
            int i;
            IpInterfaceMo originalIpInterfaceMo = (IpInterfaceMo)this.moRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
            if (this.siteBasicData != null) {
                ipAccessHostEtData = this.siteBasicData.getIpSystemData().getIpAccessHostEtData();
                ipInterfaceData = this.siteBasicData.getIpInterfaceData();
                ipHostLinkData = this.siteBasicData.getIpData().getIpHostLinkData();
            }
            if (ipAccessHostEtData != null) {
                for (i = 0; i < ipAccessHostEtData.length; ++i) {
                    IpInterfaceMo ipInterfaceRefMo = (IpInterfaceMo)this.moRepository.lookup(ipAccessHostEtData[i].getIpInterfaceMoRefLdn());
                    if (ipInterfaceRefMo == null || !ipInterfaceRefMo.equals(originalIpInterfaceMo)) continue;
                    isReferenced = true;
                    break;
                }
            }
            if (isReferenced && ipInterfaceData != null && ipHostLinkData != null && ipHostLinkData.getIpInterfaceLdn().toLowerCase().indexOf("ManagedElement=1,IpSystem=1,VpnInterface=".toLowerCase()) != -1) {
                for (i = 0; i < ipInterfaceData.length; ++i) {
                    relativeName = "IpInterface=" + ipInterfaceData[i].getIpInterfaceId();
                    if (!relativeName.equalsIgnoreCase(originalIpInterfaceMo.getRelativeDistinguishedName())) continue;
                    isReferenced = false;
                    break;
                }
            }
            if (isReferenced && ipInterfaceData != null && ipHostLinkData != null && ipHostLinkData.getIpInterfaceLdn().toLowerCase().indexOf("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1".toLowerCase()) != -1) {
                for (i = 0; i < ipInterfaceData.length; ++i) {
                    relativeName = "IpInterface=" + ipInterfaceData[i].getIpInterfaceId();
                    if (!relativeName.equalsIgnoreCase(originalIpInterfaceMo.getRelativeDistinguishedName()) || !ipInterfaceData[i].configurationMode.equals("DHCP")) continue;
                    isReferenced = false;
                    break;
                }
            }
            if (!isReferenced) {
                RbsConfigurationReportLoggerFactory.getLogger().logAction(originalIpInterfaceMo.getType(), "Delete", "LDN", "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
                originalIpInterfaceMo.delete(coordinator);
            } else {
                logger.traceDebug(THIS_CLASS, "Original IpInterface MO should not be deleted due to referenced by IpAccessHostEt");
            }
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Site Basic", "Unable to delete temporary IpInterface MO.", (Exception)((Object)e));
        }
        logger.traceReturn(THIS_CLASS, "removeOriginalIpInterfaceMo");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO delete failed", "Unable to delete original OaM IP configuration.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

