/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RemoveTemporaryTunnelTp
implements TransactionPackage {
    private static final Class THIS_CLASS = RemoveTemporaryTunnelTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final boolean disableIpSec;
    private final boolean retryPeerIdType;

    public RemoveTemporaryTunnelTp(GenericMaoContext aGenericMaoContextIn, boolean disableIpSecIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.disableIpSec = disableIpSecIn;
        this.retryPeerIdType = false;
    }

    public RemoveTemporaryTunnelTp(GenericMaoContext aGenericMaoContextIn, boolean disableIpSecIn, boolean retryPeerIdTypeIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.disableIpSec = disableIpSecIn;
        this.retryPeerIdType = retryPeerIdTypeIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        ManagedObject mo;
        logger.traceEnter(THIS_CLASS, "execute()");
        IpSecMo ipsecMo = (IpSecMo)this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        this.deleteSpecificMo("ManagedElement=1,IpSystem=1,IpSec=1,IpSecTunnel=1", coordinator);
        this.deleteSpecificMo("ManagedElement=1,IpSystem=1,IpSec=1,IkePeer=1", coordinator);
        if (this.retryPeerIdType) {
            logger.traceReturn(THIS_CLASS, "execute()");
            return;
        }
        IpMo ipMo = (IpMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
        IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
        if (ipMo != null && ipHostLinkMo != null) {
            String interfaceName = ipHostLinkMo.getInterfaceName(coordinator);
            String ipv4InterfaceName = (String)ipMo.getAttribute("nodeInterfaceName", coordinator);
            if (interfaceName != null && interfaceName.compareTo(ipv4InterfaceName) == 0) {
                ipMo.setAttribute("nodeInterfaceName", (Object)"le0", coordinator);
            } else {
                String ipv6InterfaceName = (String)ipMo.getAttribute("nodeIpv6InterfaceName", coordinator);
                if (interfaceName != null && interfaceName.compareTo(ipv6InterfaceName) == 0) {
                    ipMo.setAttribute("nodeIpv6InterfaceName", (Object)"", coordinator);
                }
            }
        }
        this.deleteSpecificMo("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1", coordinator);
        VpnInterfaceMo vpnInterfaceMo = (VpnInterfaceMo)this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,VpnInterface=1");
        if (vpnInterfaceMo != null && ipMo != null && vpnInterfaceMo.getConfigurationMode(coordinator) == RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE.intValue() && (mo = ipMo.getDnsAutoConfigInterfaceRef(coordinator)) != null && mo.getFullDistinguishedName().equals(vpnInterfaceMo.getFullDistinguishedName())) {
            ipMo.setDnsAutoConfigInterfaceRef(null, coordinator);
        }
        this.deleteSpecificMo("ManagedElement=1,IpSystem=1,VpnInterface=1", coordinator);
        IpAccessHostEtMo ipAccessHostEtMo = (IpAccessHostEtMo)this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpAccessHostEt=1");
        if (ipAccessHostEtMo != null) {
            ipAccessHostEtMo.setAdministrativeState(0, coordinator);
        }
        this.deleteSpecificMo("ManagedElement=1,IpSystem=1,IpAccessHostEt=1", coordinator);
        this.deleteSpecificMo("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1", coordinator);
        this.deleteSpecificMo("ManagedElement=1,IpSystem=1,Ipv6=1", coordinator);
        if (ipsecMo != null) {
            ipsecMo.setVendorCredentials(0L, coordinator);
        }
        if (ipsecMo != null && this.disableIpSec) {
            ipsecMo.setFeatureState(0, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void deleteSpecificMo(String moName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteSpecificMo() " + moName);
        ManagedObject mo = this.aMoRepository.lookup(moName);
        if (mo != null) {
            mo.delete(coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAction(moName, "delete", new String[0], new String[0]);
        }
        logger.traceReturn(THIS_CLASS, "deleteSpecificMo()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceAbnormal(THIS_CLASS, "Unexpected exception during removal temporary tunnel! " + exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceAbnormal(THIS_CLASS, "Unexpected transactional failure! " + exception);
    }
}

