/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.LoopableTransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RestartNodeTp
implements LoopableTransactionPackage {
    private static final Class THIS_CLASS = RestartNodeTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfigurationMao;
    private final RbsConfigurationHelper helper;
    private final String failureSlogan;
    private int actionRestartRank = 2;
    private String actionRestartMessage;
    private int actionRestartReason = 3;

    public RestartNodeTp(RbsConfigurationMao rbsConfigurationMaoIn, Integer nodeRestartRankIn, Integer nodeRestartReasonIn, String actionMessageIn, String failureSloganIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.actionRestartMessage = actionMessageIn;
        this.failureSlogan = failureSloganIn;
        if (nodeRestartRankIn != null) {
            this.actionRestartRank = nodeRestartRankIn;
        }
        if (nodeRestartReasonIn != null) {
            this.actionRestartReason = nodeRestartReasonIn;
        }
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
    }

    public RestartNodeTp(RbsConfigurationMao rbsConfigurationMaoIn, String actionMessageIn, String failureSloganIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.actionRestartMessage = actionMessageIn;
        this.failureSlogan = failureSloganIn;
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        MoRepositoryWrapper moRepositoryWrapper = this.rbsConfigurationMao.getRbsConfigurationContext().getMoRepositoryWrapper();
        ManagedElementMo managedElement = (ManagedElementMo)moRepositoryWrapper.lookup("ManagedElement=1");
        managedElement.actionManualRestart(this.actionRestartRank, this.actionRestartReason, this.actionRestartMessage, coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, this.failureSlogan, "Could not perform manual restart.");
        logger.traceError(THIS_CLASS, "Could not perform restart due to exception, retrying.", (Throwable)exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Restart of node failed", "Transaction failure. Retrying.");
        logger.traceError(THIS_CLASS, "Could not perform restart due to transaction exception, retrying.", (Throwable)exception);
    }

    public boolean loop(int noOfLoops) throws RbsConfigurationFailedException {
        this.helper.waitForRetry("actionManualRestart()");
        return true;
    }
}

