/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import java.net.Inet4Address;
import java.net.InetAddress;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetDefaultNtpServerTp
implements TransactionPackage {
    private static final Class THIS_CLASS = SetDefaultNtpServerTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final String ntpAddress;
    private final String fallbackNtp;

    public SetDefaultNtpServerTp(GenericMaoContext genericMaoContextIn, String address, String option42) {
        this.aMoRepository = genericMaoContextIn.getMoRepositoryWrapper();
        this.ntpAddress = address;
        this.fallbackNtp = option42;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        String actualValue = this.fallbackNtp;
        NtpServerMo ntpServerMo = (NtpServerMo)this.aMoRepository.lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=1");
        String ipv4address = this.getIpv4Address();
        if (ipv4address != null) {
            actualValue = ipv4address;
            ntpServerMo.setServerAddress(actualValue, coordinator);
        } else if (actualValue != null) {
            ntpServerMo.setServerAddress(actualValue, coordinator);
        } else {
            logger.traceAbnormal(THIS_CLASS, "NtpServer value cannot be used. Check that option 42 or dns has been configured. Using factoy value = " + ntpServerMo.getServerAddress(coordinator));
        }
        if (!ntpServerMo.getServiceActive(coordinator)) {
            ntpServerMo.setServiceActive(true, coordinator);
        }
        RbsConfigurationReportLoggerFactory.getLogger().logAttribute(ntpServerMo.getType(), "Synchronizing time with NTP server ", actualValue);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("NtpServerMo", "Unable to set " + this.ntpAddress + " to active " + "ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=1" + ".", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }

    private String getIpv4Address() {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(this.ntpAddress);
            for (int i = 0; i < addresses.length; ++i) {
                if (!(addresses[i] instanceof Inet4Address)) continue;
                return addresses[i].getHostAddress();
            }
        }
        catch (Exception e) {
            logger.traceAbnormal(THIS_CLASS, "server can't find " + this.ntpAddress + ". -> " + e.getMessage());
        }
        return null;
    }
}

