/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetDnsAutoConfigInterfaceRefOnIpMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = SetDnsAutoConfigInterfaceRefOnIpMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final String vpnInterfaceLdnValue;

    public SetDnsAutoConfigInterfaceRefOnIpMoTp(GenericMaoContext genericMaoContextIn, String vpnInterfaceLdnValueIn) {
        this.aMoRepository = genericMaoContextIn.getMoRepositoryWrapper();
        this.vpnInterfaceLdnValue = vpnInterfaceLdnValueIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        VpnInterfaceMo vpnInterfaceMo = (VpnInterfaceMo)this.aMoRepository.lookup(this.vpnInterfaceLdnValue);
        IpMo ipMo = (IpMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
        ipMo.setDnsAutoConfigInterfaceRef((ManagedObject)vpnInterfaceMo, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAttribute(ipMo.getRelativeDistinguishedName(), "dnsAutoConfigInterfaceRef", vpnInterfaceMo.getFullDistinguishedName());
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("IpMo", "Unable to set dnsAutoConfigInterfaceRef on IpMo for VpnInterfaceMo" + this.vpnInterfaceLdnValue + ".", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

