/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import java.io.IOException;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetIpAddressOnIpHostLinkTp
implements TransactionPackage {
    private static final Class THIS_CLASS = SetIpAddressOnIpHostLinkTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ZERO_IP = "0.0.0.0";
    private final MoRepositoryWrapper aMoRepository;
    private final String ipAddress;
    private final String defaultRouter0;
    private final String subnetmask;

    public SetIpAddressOnIpHostLinkTp(GenericMaoContext aGenericMaoContext, String ipAddressIn, String subnetmaskIn, String defaultRouter0In) {
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.ipAddress = ipAddressIn;
        this.subnetmask = subnetmaskIn;
        this.defaultRouter0 = defaultRouter0In;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        Integer networkPrefixLength;
        logger.traceEnter(THIS_CLASS, "execute()");
        try {
            networkPrefixLength = RbsConfigurationIpHelperImpl.calculateNetworkPrefixLength(this.subnetmask);
        }
        catch (IOException ioe) {
            throw new RbsConfigurationFailedException("IpInterface", "Fault in calculating networkPrefixLength", ioe);
        }
        IpHostLinkMo ipHostLink = (IpHostLinkMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
        if (ipHostLink == null) {
            throw new MoNotFoundException("Correct IpInterface MO was not found!");
        }
        logger.traceDebug(THIS_CLASS, " ipAddresss:" + this.ipAddress + " networkPrefixLength:" + networkPrefixLength + " defaultRouter0:" + this.defaultRouter0);
        ipHostLink.actionAssignIpAddress(this.ipAddress, networkPrefixLength.intValue(), this.defaultRouter0, ZERO_IP, ZERO_IP, ZERO_IP, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("IpHostLink", "assignIpAdress", new String[]{"ipAddress", "networkPrefixLength", "defaultRouter0"}, new String[]{this.ipAddress, networkPrefixLength.toString(), this.defaultRouter0});
        String aNewAddress = ipHostLink.getIpAddress(coordinator);
        logger.traceGeneral(THIS_CLASS, " IPHostLink Mo =ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1 :anewAddress" + aNewAddress);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO action failed", "Failed to set ipAddress on Mo IpHostLink", exception);
    }
}

