/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpInterfaceMoTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetVlanOnIpv6InterfaceMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpInterfaceMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final int vlanId;

    public SetVlanOnIpv6InterfaceMoTp(GenericMaoContext aGenericMaoContextIn, int vlanIdIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.vlanId = vlanIdIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        Ipv6InterfaceMo ipv6Interface = (Ipv6InterfaceMo)this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,Ipv6Interface=1");
        if (ipv6Interface == null) {
            throw new MoNotFoundException("Correct Ipv6Interface MO was not found!");
        }
        if (this.vlanId > -1) {
            ipv6Interface.setVLan(true, coordinator);
            ipv6Interface.setVid(this.vlanId, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAction("Ipv6Interface", "set", new String[]{"vid", "VLan"}, new String[]{Integer.toString(this.vlanId), "true"});
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO set failed", "Unable to set vlan attributes on Ipv6Interface MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

