/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class UnlockPacketFrequencyTp
implements TransactionPackage {
    private final MoRepositoryWrapper moRepository;
    private final String attr;

    public UnlockPacketFrequencyTp(MoRepositoryWrapper inMoRepository, String attribute) {
        this.moRepository = inMoRepository;
        this.attr = attribute;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        MoIterator packetFrequencies = this.moRepository.lookupType("PacketFrequencySyncRef");
        while (packetFrequencies != null && packetFrequencies.hasMoreElements()) {
            ManagedObject packetFrequencyMo = packetFrequencies.nextMo();
            packetFrequencyMo.setAttribute(this.attr, (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute(packetFrequencyMo.getRelativeDistinguishedName(), this.attr, RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED);
        }
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Site Basic fault", "Unable to unlock packet frequency sync", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Site Basic fault", "Unable to unlock packet frequency sync", exception);
    }
}

