/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import se.ericsson.cello.net.FTPException;
import se.ericsson.cello.net.OutOfResourcesException;
import se.ericsson.cello.pms.generic.FailedException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.common.ZipFileHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.InstallInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.Installer;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.RbsConfigurationUpgrade;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeControlFileParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.Upgrader;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.wrappers.InstallerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.wrappers.UpgraderFactory;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.FTPClientWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RbsConfigurationUpgradeImpl
implements FileFilter,
RbsConfigurationUpgrade {
    private static final Class THIS_CLASS = RbsConfigurationUpgradeImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient String ftpService;
    private final transient String userName;
    private final transient String password;
    private final transient String upgradePackagePath;
    private final transient boolean localUpgradePackage;
    protected transient InstallInfo installInfo;
    protected transient UpInfo upInfo;
    private final RbsConfigurationContext rbsConfigurationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbsConfigurationUpgradeImpl(String ftpServiceIn, String userNameIn, String passwordIn, String upgradePackagePathIn, boolean localUpgradePackageIn, RbsConfigurationContext rbsConfigurationContextIn) throws UpgradeException {
        try {
            logger.traceEnter(THIS_CLASS, "RbsConfigurationUpgradeImpl(" + upgradePackagePathIn + ")");
            File upgradePackageFile = new File(upgradePackagePathIn);
            if (localUpgradePackageIn && !upgradePackageFile.exists()) {
                throw new UpgradeException("The upgrade package does not exist: " + upgradePackagePathIn);
            }
            this.ftpService = ftpServiceIn;
            this.userName = userNameIn;
            this.password = passwordIn;
            this.upgradePackagePath = upgradePackagePathIn;
            this.localUpgradePackage = localUpgradePackageIn;
            this.rbsConfigurationContext = rbsConfigurationContextIn;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            logger.traceReturn(THIS_CLASS, "RbsConfigurationUpgradeImpl(" + upgradePackagePathIn + ")");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "RbsConfigurationUpgradeImpl(" + upgradePackagePathIn + ")");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpgradeInfo prepare(Coordinator coordinator, MoRepositoryWrapper moRepositoryWrapper, MoFactoryMgrWrapper moFactoryWrapper) throws UpgradeException {
        UpgradeInfo upgradeInfo;
        try {
            try {
                logger.traceEnter(THIS_CLASS, "prepare()");
                if (this.localUpgradePackage) {
                    this.updateProgressReportInformation(500, 2, "Upgrade package is local - no need to fetch it", true);
                    File unpackedDirectory = this.unpackLocalUpgradePackage();
                    logger.traceGeneral(THIS_CLASS, "Unpacked local UP to: " + unpackedDirectory);
                    File upRoot = unpackedDirectory;
                    File[] zipDirFiles = unpackedDirectory.listFiles();
                    for (int index = 0; index < zipDirFiles.length; ++index) {
                        if (!zipDirFiles[index].isDirectory()) continue;
                        upRoot = zipDirFiles[index];
                    }
                    this.upInfo = this.getUpInfoFromLocalUpDirectory(upRoot);
                    logger.traceGeneral(THIS_CLASS, "Fetched UP info from local UCF: " + this.upInfo.productNumber + ", " + this.upInfo.productRevision);
                } else {
                    this.upInfo = this.getUpInfoFromUcfOnFtp();
                    logger.traceGeneral(THIS_CLASS, "Fetched UP info from remote UCF: " + this.upInfo.productNumber + ", " + this.upInfo.productRevision);
                }
                Installer installer = InstallerFactory.getInstance().getInstaller(this.rbsConfigurationContext);
                this.installInfo = installer.prepare(this.upInfo, moRepositoryWrapper, moFactoryWrapper, this.ftpService, this.upInfo.upgradeControlFile, coordinator);
                upgradeInfo = new UpgradeInfo(this.installInfo.moCreated, this.upInfo.getUpId());
                Object var9_10 = null;
            }
            catch (UpgradeException ue) {
                throw ue;
            }
            catch (Exception e) {
                throw new UpgradeException("Could not upgrade with upgrade package: " + this.upgradePackagePath, e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logger.traceReturn(THIS_CLASS, "prepare()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "prepare()");
        return upgradeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(Coordinator coordinator) throws UpgradeException {
        try {
            logger.traceEnter(THIS_CLASS, "install()");
            Installer installer = InstallerFactory.getInstance().getInstaller(this.rbsConfigurationContext);
            installer.install(this.installInfo, coordinator);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            logger.traceReturn(THIS_CLASS, "install()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "install()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgrade(MoRepositoryWrapper moRepositoryWrapper, Coordinator coordinator) throws UpgradeException {
        boolean upgrading = true;
        try {
            logger.traceEnter(THIS_CLASS, "upgrade()");
            Upgrader upgrader = UpgraderFactory.getInstance().getUpgrader(this.rbsConfigurationContext);
            upgrading = upgrader.upgrade(this.upInfo.getUpId(), this.installInfo.upgradePackageMo, coordinator, moRepositoryWrapper);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            logger.traceReturn(THIS_CLASS, "upgrade()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "upgrade()");
        return upgrading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean continueUpgrade(String upId, Coordinator coordinator, MoRepositoryWrapper moRepositoryWrapper) throws UpgradeException {
        boolean rebootRequested = true;
        try {
            logger.traceEnter(THIS_CLASS, "continueUpgrade()");
            UpgradePackageMo upgradePackageMo = UpgradeHelper.getUpgradePackageMo(coordinator, moRepositoryWrapper, upId);
            Upgrader upgrader = UpgraderFactory.getInstance().getUpgrader(this.rbsConfigurationContext);
            rebootRequested = upgrader.continueUpgrade(upId, upgradePackageMo, coordinator, moRepositoryWrapper);
            this.deleteZippedUPandDir(rebootRequested, "/c/ftp_up/");
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            logger.traceReturn(THIS_CLASS, "continueUpgrade()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "continueUpgrade()");
        return rebootRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File unpackLocalUpgradePackage() throws FileHelper.FileException {
        File file;
        logger.traceEnter(THIS_CLASS, "unpackLocalUpgradePackage()");
        try {
            String unzipDir = System.getProperty("unzip_tmp_dir", "/c/systemfiles/lte/autointegration/UP_unzip_dir");
            ZipFileHelper.unzipFile((String)this.upgradePackagePath, (String)unzipDir);
            file = new File(unzipDir);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            logger.traceReturn(THIS_CLASS, "unpackLocalUpgradePackage()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "unpackLocalUpgradePackage()");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpInfo getUpInfoFromLocalUpDirectory(File unpackedDirectory) throws UpgradeException, SAXException, IOException, ParserConfigurationException {
        UpInfo upInfo;
        try {
            logger.traceEnter(THIS_CLASS, "getUpInfoFromLocalUpDirectory(" + unpackedDirectory + ")");
            File localUcf = this.findLocalUcfs(unpackedDirectory);
            UpInfo localUpInfo = this.getUpInfoFromLocalUcf(localUcf.getAbsolutePath());
            localUpInfo.ftpService = "127.0.0.1";
            localUpInfo.userName = "rbs";
            localUpInfo.password = "change_me";
            localUpInfo.upgradeControlFile = localUcf.getAbsolutePath();
            upInfo = localUpInfo;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            logger.traceReturn(THIS_CLASS, "getUpInfoFromLocalUpDirectory(" + unpackedDirectory + ")");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "getUpInfoFromLocalUpDirectory(" + unpackedDirectory + ")");
        return upInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected UpInfo getUpInfoFromUcfOnFtp() throws FailedException, FTPException, OutOfResourcesException, SAXException, IOException, ParserConfigurationException {
        UpInfo upInfo;
        try {
            try {
                logger.traceEnter(THIS_CLASS, "getUpInfoFromUcfOnFtp()");
                this.updateProgressReportInformation(500, 3, "Retrieving UCF info from remote upgrade package", true);
                String ucfFileName = this.upgradePackagePath;
                int index = this.upgradePackagePath.lastIndexOf(File.separatorChar);
                if (index > -1) {
                    ucfFileName = this.upgradePackagePath.substring(index + 1);
                }
                FTPClientWrapper ftpClientWrapper = this.rbsConfigurationContext.getGenericMaoContext().getFTPClientWrapperFactory().getFTPClientWrapper();
                ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_FETCHING_UPGRADE_PACKAGE);
                String localUcfPath = System.getProperty("rbs_ftp_temp_dir", "/c/systemfiles/lte/autointegration/") + ucfFileName;
                ftpClientWrapper.get(this.ftpService, this.userName, this.password, localUcfPath, this.upgradePackagePath);
                UpInfo localUpInfo = this.getUpInfoFromLocalUcf(localUcfPath);
                localUpInfo.ftpService = this.ftpService;
                localUpInfo.userName = this.userName;
                localUpInfo.password = this.password;
                localUpInfo.upgradeControlFile = this.upgradePackagePath;
                this.updateProgressReportInformation(500, 5, "Finsished retrieving UCF info from remote upgrade package", true);
                upInfo = localUpInfo;
                Object var8_10 = null;
            }
            catch (FailedException fe) {
                this.updateProgressReportInformation(500, 4, ExceptionHelper.appendReason((String)("Failed retrieving Upgrade package, \"" + this.upgradePackagePath + "\", from remote upgrade package"), (Throwable)fe), true);
                throw fe;
            }
            catch (FTPException ftpe) {
                this.updateProgressReportInformation(500, 4, ExceptionHelper.appendReason((String)("Failed retrieving Upgrade package, \"" + this.upgradePackagePath + "\", from remote upgrade package"), (Throwable)ftpe), true);
                throw ftpe;
            }
            catch (OutOfResourcesException ore) {
                this.updateProgressReportInformation(500, 4, ExceptionHelper.appendReason((String)("Failed retrieving Upgrade package, \"" + this.upgradePackagePath + "\", from remote upgrade package"), (Throwable)ore), true);
                throw ore;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            logger.traceReturn(THIS_CLASS, "getUpInfoFromUcfOnFtp()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "getUpInfoFromUcfOnFtp()");
        return upInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpInfo getUpInfoFromLocalUcf(String localUcfFilePath) throws SAXException, IOException, ParserConfigurationException {
        UpInfo upInfo;
        try {
            logger.traceEnter(THIS_CLASS, "getUpInfoFromLocalUcf(" + localUcfFilePath + ")");
            UpgradeControlFileParser parser = new UpgradeControlFileParser();
            parser.parse(localUcfFilePath);
            upInfo = parser.getUpInfo();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            logger.traceReturn(THIS_CLASS, "getUpInfoFromLocalUcf(" + localUcfFilePath + ")");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "getUpInfoFromLocalUcf(" + localUcfFilePath + ")");
        return upInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File findLocalUcfs(File unpackedDirectory) throws UpgradeException {
        File file;
        try {
            logger.traceEnter(THIS_CLASS, "findLocalUcfs(" + unpackedDirectory + ")");
            File[] files = unpackedDirectory.listFiles(this);
            if (files.length < 1) {
                throw new UpgradeException("No upgrade control files found in local upgrade package: " + unpackedDirectory);
            }
            if (files.length > 1) {
                StringBuffer errorMsg = new StringBuffer("Upgrade packages with more than one upgrade control file is not supported. Found: ");
                for (int index = 0; index < files.length; ++index) {
                    errorMsg.append(files[index].getName());
                    if (index >= files.length - 1) continue;
                    errorMsg.append(", ");
                }
                throw new UpgradeException(errorMsg.toString());
            }
            logger.traceGeneral(THIS_CLASS, "Found local UCF: " + files[0]);
            file = files[0];
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logger.traceReturn(THIS_CLASS, "findLocalUcfs(" + unpackedDirectory + ")");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "findLocalUcfs(" + unpackedDirectory + ")");
        return file;
    }

    public boolean accept(File fileToBeChecked) {
        String fileName = fileToBeChecked.getName().toLowerCase(Locale.getDefault());
        return fileToBeChecked != null && fileToBeChecked.isFile() && fileName.endsWith(".xml") && fileName.startsWith("cxp");
    }

    private void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteZippedUPandDir(boolean rebootRequestedCalled, String localUpgradePackageDir) throws UpgradeException {
        logger.traceEnter(THIS_CLASS, "deleteZippedUPandDir()");
        if (rebootRequestedCalled) return;
        logger.traceDebug(THIS_CLASS, "rebootRequestedCalled :" + rebootRequestedCalled);
        File zippedUPdir = new File(localUpgradePackageDir);
        File[] listFile = new File(localUpgradePackageDir).listFiles();
        String dirName = zippedUPdir.getName();
        try {
            block5: {
                try {
                    if (!zippedUPdir.exists() || listFile.length <= 0) break block5;
                    for (int i = 0; i < listFile.length; ++i) {
                        if (!listFile[i].isFile()) continue;
                        String fileName = listFile[i].getName();
                        long fileSize = listFile[i].length();
                        listFile[i].delete();
                        logger.traceDebug(THIS_CLASS, "Delete the zipped UP file -file name :" + fileName + "," + " file size :" + fileSize + " bytes");
                    }
                    zippedUPdir.delete();
                    logger.traceDebug(THIS_CLASS, "Delete the directory for zipped UP - directory name :" + dirName);
                }
                catch (Exception e) {
                    throw new UpgradeException("Could not delete the zip file and Directorty: " + localUpgradePackageDir, e);
                }
            }
            Object var11_10 = null;
            logger.traceReturn(THIS_CLASS, "deleteZippedUPandDir()");
            return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            logger.traceReturn(THIS_CLASS, "deleteZippedUPandDir()");
            throw throwable;
        }
    }
}

