/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.SmrsInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.RbsConfigurationUpgrade;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.RbsConfigurationUpgradeFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeResult;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class UpgradeHandlerImpl
implements UpgradeHandler {
    private static final Class THIS_CLASS = UpgradeHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
    private static final int TX_TIMEOUT = 0;
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactorymgr;
    private final RbsConfigurationHelper helper;
    private final RbsConfigurationMao rbsConfiguration;
    private final RbsConfigurationContext rbsConfigurationContext;
    private boolean localFailure = false;
    private boolean remoteFailure = false;
    private boolean installExecuting = false;

    public UpgradeHandlerImpl(RbsConfigurationMao theRbsConfiguration, MoRepositoryWrapper moRepository, MoFactoryMgrWrapper moFactoryMgr) {
        this.rbsConfiguration = theRbsConfiguration;
        this.aMoRepository = moRepository;
        this.aMoFactorymgr = moFactoryMgr;
        this.rbsConfigurationContext = this.rbsConfiguration.getRbsConfigurationContext();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
    }

    private RbsConfigurationUpgrade startLocalUpgrade(String localUpgradePath) {
        RbsConfigurationUpgrade rbsUpgrade = null;
        while (true) {
            try {
                Control control = transFact.create(0);
                try {
                    this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_UPGRADING);
                    rbsUpgrade = RbsConfigurationUpgradeFactory.createRbsConfigurationUpgrade("127.0.0.1", "rbs", "change_me", localUpgradePath, true, this.rbsConfigurationContext);
                    UpgradeInfo upInfo = rbsUpgrade.prepare(control.getCoordinator(), this.aMoRepository, this.aMoFactorymgr);
                    this.rbsConfiguration.storePersistently("UpgradePackageId", upInfo.upId);
                    control.getTerminator().commit();
                }
                catch (UpgradeException upe) {
                    control.getTerminator().rollback();
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Upgrade failed. " + upe.getMessage() + ". Please replace the UP archive on the node.");
                    this.handleStatesAtFailure(true);
                    this.helper.waitForRetry("Upgrade failed");
                    rbsUpgrade = null;
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    this.handleStatesAtFailure(true);
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Upgrade failed.");
                    rbsUpgrade = null;
                }
                break;
            }
            catch (TransactionRolledBackException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Transaction failure. Retrying.");
            }
            this.helper.waitForRetry("start upgrade - Transaction");
        }
        return rbsUpgrade;
    }

    private RbsConfigurationUpgrade startRemoteUpgrade(String remoteUpgradePath) {
        RbsConfigurationUpgrade rbsUpgrade = null;
        while (true) {
            try {
                Control control = transFact.create(0);
                try {
                    this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_UPGRADING);
                    RbsConfigurationSmrsHelper rbsConfigurationSmrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
                    RbsConfigurationHelper rbsConfigurationHelper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
                    SmrsInfo smrsInfo = rbsConfigurationSmrsHelper.getSmrsInfo();
                    Map sftpData = null;
                    File nlhFile = new File(rbsConfigurationHelper.getLocalPath() + "Nlh.xml");
                    if (nlhFile.exists()) {
                        RbsConfigurationIsiHelper rbsConfigurationIsiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationIsiHelper.class);
                        try {
                            sftpData = rbsConfigurationIsiHelper.getSftpData(nlhFile.getPath());
                        }
                        catch (IOException ioe) {
                            logger.traceAbnormal(THIS_CLASS, "Fail to parse NLH file: " + ioe.getMessage());
                        }
                        catch (GeneralSecurityException se) {
                            logger.traceAbnormal(THIS_CLASS, "Fail to decrypt NLH file: " + se.getMessage());
                        }
                    }
                    rbsUpgrade = nlhFile.exists() && sftpData != null ? RbsConfigurationUpgradeFactory.createRbsConfigurationUpgrade((String)sftpData.get("address"), (String)sftpData.get("userName"), (String)sftpData.get("password"), (String)sftpData.get("upgradeFilePath"), false, this.rbsConfigurationContext) : RbsConfigurationUpgradeFactory.createRbsConfigurationUpgrade(smrsInfo.getSmrsServer(), smrsInfo.getSmrsUserName(), smrsInfo.getSmrsPassword(), remoteUpgradePath, false, this.rbsConfigurationContext);
                    UpgradeInfo upInfo = rbsUpgrade.prepare(control.getCoordinator(), this.aMoRepository, this.aMoFactorymgr);
                    this.rbsConfiguration.storePersistently("UpgradePackageId", upInfo.upId);
                    control.getTerminator().commit();
                }
                catch (UpgradeException upe) {
                    control.getTerminator().rollback();
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Upgrade failed. " + upe.getMessage() + ". Getting new UP from new SummaryFile.");
                    this.handleStatesAtFailure(false);
                    this.helper.waitForRetry("Upgrade failed");
                    rbsUpgrade = null;
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Upgrade failed. " + mae.getVariablesAsString() + ". Getting new UP from new SummaryFile.");
                    this.handleStatesAtFailure(false);
                    this.helper.waitForRetry("Upgrade failed");
                    rbsUpgrade = null;
                }
                break;
            }
            catch (TransactionRolledBackException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Transaction failure. Retrying.");
            }
            this.helper.waitForRetry("start upgrade - Transaction");
        }
        return rbsUpgrade;
    }

    public UpgradeResult performUpgrade(boolean localUpgrade, String filePath) {
        boolean upgrading;
        logger.traceEnter(THIS_CLASS, "performUpgrade(localUpgrade = " + localUpgrade + " filePath: " + filePath);
        UpgradeResult result2 = null;
        String nlhFilePath = this.helper.getLocalPath() + "Nlh.xml";
        boolean nlhFileExists = new File(nlhFilePath).exists();
        if (!nlhFileExists) {
            logger.traceDebug(THIS_CLASS, "Nlh file " + nlhFilePath + " does not exist. Continue removing virtual upgrade packages");
            this.removeVirtualUpgradePackages();
        }
        RbsConfigurationUpgrade rbsUpgrade = null;
        rbsUpgrade = localUpgrade ? this.startLocalUpgrade(filePath) : this.startRemoteUpgrade(filePath);
        boolean bl = upgrading = rbsUpgrade != null && this.install(localUpgrade, rbsUpgrade) && this.upgrade(localUpgrade, rbsUpgrade);
        result2 = upgrading ? UpgradeResult.UPGRADE_IN_PROGRESS : (this.installExecuting ? UpgradeResult.INSTALL_IN_PROGRESS : (this.localFailure ? UpgradeResult.LOCAL_UPGRADE_FAILED : (this.remoteFailure ? UpgradeResult.REMOTE_UPGRADE_FAILED : UpgradeResult.UPGRADE_FINISHED)));
        this.remoteFailure = false;
        this.localFailure = false;
        logger.traceReturn(THIS_CLASS, "performUpgrade() upgrade result is " + result2.toString());
        return result2;
    }

    private boolean install(boolean localUpgrade, RbsConfigurationUpgrade rbsUpgrade) {
        this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_UPGRADING);
        boolean installSuccessful = true;
        this.updateProgressReportInformation(600, 3, "Installing upgrade package", true);
        while (true) {
            try {
                Control control = transFact.create(0);
                Coordinator coordinator = control.getCoordinator();
                try {
                    rbsUpgrade.install(coordinator);
                    control.getTerminator().commit();
                    this.updateProgressReportInformation(600, 5, "Successfully installed upgrade package", true);
                }
                catch (UpgradeException upe) {
                    if (upe.getMessage().compareTo("INSTALL_EXECUTING") == 0) {
                        this.updateProgressReportInformation(600, 3, "Waiting for install to complete.", true);
                        this.handleStatesAtInstallExecuting();
                    } else {
                        this.updateProgressReportInformation(600, 4, ExceptionHelper.appendReason((String)"Failed to install upgrade package.", (Throwable)upe), true);
                        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Upgrade failed. Retrying. " + upe.getMessage());
                        this.handleStatesAtFailure(localUpgrade);
                    }
                    control.getTerminator().rollback();
                    installSuccessful = false;
                }
                break;
            }
            catch (TransactionRolledBackException e) {
                this.updateProgressReportInformation(600, 4, "Failed to install upgrade package - Transaction failure. Retrying.", true);
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Install failure!", "Transaction failure. Retrying.");
            }
            catch (InactiveTransactionException e) {
                this.updateProgressReportInformation(600, 4, "Failed to install upgrade package - Transaction failure. Retrying.", true);
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Install failure!", "Transaction failure. Retrying.");
            }
            this.helper.waitForRetry("Install UP");
        }
        return installSuccessful;
    }

    private boolean upgrade(boolean localUpgrade, RbsConfigurationUpgrade rbsUpgrade) {
        boolean upgrading = false;
        try {
            this.updateProgressReportInformation(700, 3, "Upgrading with installed upgrade package", true);
            upgrading = rbsUpgrade.upgrade(this.aMoRepository, null);
        }
        catch (UpgradeException upe) {
            this.updateProgressReportInformation(700, 4, upe.getMessage(), true);
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Upgrade failed. Retrying. " + upe.getMessage());
            this.handleStatesAtFailure(localUpgrade);
        }
        catch (Exception e) {
            String errorMsg = ExceptionHelper.appendReason((String)"Upgrade failed. Retrying.", (Throwable)e);
            this.updateProgressReportInformation(700, 4, errorMsg, true);
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Abnormal upgrade failure", errorMsg);
            this.handleStatesAtFailure(localUpgrade);
        }
        return upgrading;
    }

    private void handleStatesAtFailure(boolean localUpgrade) {
        if (localUpgrade) {
            this.localFailure = true;
        } else {
            this.remoteFailure = true;
        }
    }

    private void handleStatesAtInstallExecuting() {
        this.installExecuting = true;
    }

    private void removeVirtualUpgradePackages() {
        logger.traceEnter(THIS_CLASS, "removeVirtualUpgradePackages()");
        MoIterator upgradePackages = this.aMoRepository.lookupType("UpgradePackage");
        if (upgradePackages != null && upgradePackages.hasMoreElements()) {
            while (upgradePackages.hasMoreElements()) {
                ManagedObject upgradePackage = upgradePackages.nextMo();
                if (!LdnHelper.getRdnAttributeValue((String)upgradePackage.getRelativeDistinguishedName()).startsWith("Virtual_")) continue;
                this.deleteMo(upgradePackage);
            }
        }
        logger.traceReturn(THIS_CLASS, "removeVirtualUpgradePackages()");
    }

    private void deleteMo(ManagedObject managedObject) {
        try {
            Control control = transFact.create(0);
            Coordinator coordinator = control.getCoordinator();
            try {
                managedObject.delete(coordinator);
                control.getTerminator().commit();
            }
            catch (MoAccessException mae) {
                String faultInformation = "Unable to clean up old Upgrade Packages.";
                if (mae.getMessage() != null) {
                    faultInformation = faultInformation + mae.getMessage();
                }
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", faultInformation);
                control.getTerminator().rollback();
            }
        }
        catch (TransactionRolledBackException e) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Transaction failure. Retrying.");
        }
        catch (InactiveTransactionException e) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade failure!", "Transaction failure. Retrying.");
        }
    }

    private void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }
}

