/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade;

import java.io.IOException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.neal.NealRuntimeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.SingleInstanceFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpStatus;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeReadyListener;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.Upgrader;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpHeader;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpState;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpgradeSubscriber;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class UpgraderImpl
implements Upgrader,
UpgradeReadyListener {
    private static final Class THIS_CLASS = UpgraderImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private transient String failureMessage = "";
    protected transient boolean failure = false;
    protected transient boolean success = false;
    private final RbsConfigurationContext rbsConfigurationContext;

    public UpgraderImpl(RbsConfigurationContext rbsConfigurationContextIn) {
        logger.traceEnter(THIS_CLASS, "UpgraderImpl()");
        this.rbsConfigurationContext = rbsConfigurationContextIn;
        logger.traceReturn(THIS_CLASS, "UpgraderImpl()");
    }

    public boolean upgrade(String upId, UpgradePackageMo upgradePackageMo, Coordinator coordinator, MoRepositoryWrapper moRepositoryWrapper) throws UpgradeException {
        boolean upgrading = false;
        logger.traceEnter(THIS_CLASS, "upgrade()");
        RbsConfigurationMao rbsConfiguration = SingleInstanceFinder.getRbsConfigurationInstance(moRepositoryWrapper);
        RbsConfigurationHelper helper = (RbsConfigurationHelper)rbsConfiguration.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
        try {
            UpStatus upStatus = UpgradeHelper.getUpgradePackageStatus(coordinator, upgradePackageMo);
            if (upStatus.state.getStateValue() == UpState.STATE_UPGRADE_COMPLETED.getStateValue()) {
                RbsConfigurationReportLoggerFactory.getLogger().logInformation("Upgrade", "Upgrade with " + upgradePackageMo.getLocalDistinguishedName() + " completed.");
                helper.setConfigurationStateAndProgressLevel(60);
                upgrading = false;
                this.updateProgressReportInformation(700, 5, "The node is already running on installed upgrade package - no upgrade will be performed", true);
            } else {
                if (upStatus.state.getStateValue() != UpState.STATE_INSTALL_COMPLETED.getStateValue()) {
                    String errorMsg = "Upgrade package not ready for upgrade, wrong state: " + upStatus.state;
                    throw new UpgradeException(errorMsg);
                }
                UpgradeSubscriber subscriber = new UpgradeSubscriber(this, upgradePackageMo, rbsConfiguration.getRbsConfigurationContext());
                subscriber.subscribe();
                Struct struct = upgradePackageMo.actionReadSupportedUpgradeTypesStatus(coordinator);
                boolean hardUpgrade = this.isHardUpgradeSupported(struct);
                boolean softUpgrade = this.isSoftUpgradeSupported(struct);
                logger.traceDebug(THIS_CLASS, "action readSupportedUpgradeTypesStatus returned: (soft)upgrade=" + softUpgrade + ",(hard)rebootNodeUpgrade=" + hardUpgrade);
                if (!hardUpgrade && !softUpgrade) {
                    String errorMessage = "Could not upgrade RBS to the upgrade package with ldn, " + upgradePackageMo.getFullDistinguishedName() + ". Because neither hard nor soft upgrade path is supported";
                    logger.traceError(THIS_CLASS, errorMessage);
                    throw new UpgradeException(errorMessage);
                }
                if (hardUpgrade) {
                    logger.traceDebug(THIS_CLASS, "Hard upgrade (rebootNodeUpgrade) selected");
                    RbsConfigurationReportLoggerFactory.getLogger().logAction("UpgradePackage", "rebootNodeUpgrade", "Coordinator", "");
                    upgradePackageMo.actionRebootNodeUpgrade(coordinator);
                    upgrading = true;
                } else {
                    RbsConfigurationReportLoggerFactory.getLogger().logAction("UpgradePackage", "upgrade", "", "");
                    upgradePackageMo.actionUpgrade(coordinator);
                    upgrading = true;
                }
            }
        }
        catch (Exception e) {
            throw new UpgradeException("Could not upgrade RBS to the upgrade package with dn, " + upgradePackageMo.getFullDistinguishedName(), e);
        }
        logger.traceReturn(THIS_CLASS, "upgrade()");
        return upgrading;
    }

    public boolean isSoftUpgradeSupported(Struct struct) throws Exception {
        return (Boolean)struct.getValue("upgrade");
    }

    public boolean isHardUpgradeSupported(Struct struct) throws Exception {
        return (Boolean)struct.getValue("rebootNodeUpgrade");
    }

    public boolean continueUpgrade(String upId, UpgradePackageMo upgradePackageMo, Coordinator coordinator, MoRepositoryWrapper moRepositoryWrapper) throws UpgradeException {
        boolean rebootRequested;
        block7: {
            rebootRequested = true;
            try {
                logger.traceEnter(THIS_CLASS, "continueUpgrade()");
                UpStatus upStatus = UpgradeHelper.getUpgradePackageStatus(coordinator, upgradePackageMo);
                logger.traceDebug(THIS_CLASS, "continueUpgrade() " + upStatus);
                if (this.isUpInFinishedState(upStatus)) {
                    rebootRequested = false;
                    this.updateProgressReportInformation(700, 5, "Node successfully upgraded with installed upgrade package -  in finsished state", true);
                    logger.traceGeneral(THIS_CLASS, "Upgrade performed successfully");
                    break block7;
                }
                if (this.hasUpFailedHeader(upStatus)) {
                    String errorMsg = "Upgrade package has a failed header: " + UpHeader.toUpHeader(upStatus.header);
                    throw new UpgradeException(errorMsg);
                }
                if (this.isUpInInstallCompletedState(upStatus)) {
                    String errorMsg = "Upgrade package " + upgradePackageMo.getLocalDistinguishedName() + " has probably not passed the verification as in state: " + UpHeader.toUpHeader(upStatus.header);
                    throw new UpgradeException(errorMsg);
                }
                if (this.isUpAwaitingConfirmationState(upStatus)) {
                    RbsConfigurationReportLoggerFactory.getLogger().logAction("UpgradePackage", "confirmUpgrade", "", "");
                    upgradePackageMo.actionConfirmUpgrade(coordinator);
                    rebootRequested = this.subscribeAndWait(upgradePackageMo);
                    break block7;
                }
                if (this.isUpUpgradeExecutingState(upStatus)) {
                    rebootRequested = this.subscribeAndWait(upgradePackageMo);
                    break block7;
                }
                String errorMsg = "Upgrade package in incorrect state: " + upStatus.state.getStateDescription();
                throw new UpgradeException(errorMsg);
            }
            catch (Exception e) {
                throw new UpgradeException("Could not continue to upgrade RBS with the upgrade package with dn, " + upgradePackageMo.getFullDistinguishedName(), e);
            }
        }
        logger.traceReturn(THIS_CLASS, "continueUpgrade()");
        return rebootRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean subscribeAndWait(UpgradePackageMo upgradePackageMo) throws MoAccessException, UpgradeException {
        UpgradeSubscriber subscriber = this.subscribe(upgradePackageMo);
        while (!this.success && !this.failure) {
            try {
                Class clazz = THIS_CLASS;
                synchronized (clazz) {
                    THIS_CLASS.wait(5000L);
                }
            }
            catch (Exception exception) {
            }
        }
        if (!this.success) {
            logger.traceError(THIS_CLASS, "subscribeAndWait() - Upgrade failed: " + this.failureMessage);
            throw new UpgradeException(this.failureMessage);
        }
        return this.isRebootRequested(subscriber);
    }

    private UpgradeSubscriber subscribe(UpgradePackageMo upgradePackageMo) {
        UpgradeSubscriber subscriber;
        while (true) {
            try {
                subscriber = new UpgradeSubscriber(this, upgradePackageMo, this.rbsConfigurationContext);
                subscriber.subscribe();
                break;
            }
            catch (NealRuntimeException e) {
                logger.traceDebug(THIS_CLASS, "Node not up, waiting..");
            }
            catch (IOException e) {
                logger.traceDebug(THIS_CLASS, "IOException, waiting..");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return subscriber;
    }

    private boolean isRebootRequested(UpgradeSubscriber subscriber) {
        boolean rebootRequested = false;
        Object upgradeNotification = subscriber.getUpgradeNotification();
        if (upgradeNotification instanceof UpHeader) {
            rebootRequested = ((UpHeader)upgradeNotification).isRebootRequested();
        }
        if (rebootRequested) {
            logger.traceGeneral(THIS_CLASS, "Reboot requested");
        } else {
            logger.traceGeneral(THIS_CLASS, "Upgrade performed successfully");
        }
        return rebootRequested;
    }

    private boolean isUpInFinishedState(UpStatus upStatus) {
        return upStatus.state.getStateValue() == UpState.STATE_UPGRADE_COMPLETED.getStateValue();
    }

    private boolean isUpInInstallCompletedState(UpStatus upStatus) {
        return upStatus.state.getStateValue() == UpState.STATE_INSTALL_COMPLETED.getStateValue();
    }

    private boolean isUpAwaitingConfirmationState(UpStatus upStatus) {
        return upStatus.state.getStateValue() == UpState.STATE_AWAITING_CONFIRMATION.getStateValue();
    }

    private boolean isUpUpgradeExecutingState(UpStatus upStatus) {
        return upStatus.state.getStateValue() == UpState.STATE_UPGRADE_EXECUTING.getStateValue() || upStatus.state.getStateValue() == UpState.STATE_VERIFICATION_EXECUTING.getStateValue();
    }

    private boolean hasUpFailedHeader(UpStatus upStatus) {
        UpHeader upHeader = UpHeader.toUpHeader(upStatus.header);
        return upHeader.isFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeFailed(String failureMsg) {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.failure = true;
            this.failureMessage = failureMsg;
            THIS_CLASS.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeSuccessful() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.success = true;
            THIS_CLASS.notifyAll();
        }
    }

    private void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }
}

