/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification;

import java.io.IOException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpHeader;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpState;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistratorFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class InstallSubscriber
implements AvcSubscriber {
    private static final Class THIS_CLASS = InstallSubscriber.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected Object notification = null;
    protected String additionalInformation = null;
    protected final RbsConfigurationContext rbsConfigurationContext;
    protected final MoRepositoryWrapper moRepositoryWrapper;
    protected final String ldn;
    protected int currentHeaderValue;
    protected int currentStateValue;

    public InstallSubscriber(String ldnIn, RbsConfigurationContext rbsConfigurationContextIn) throws IOException {
        this.rbsConfigurationContext = rbsConfigurationContextIn;
        this.moRepositoryWrapper = this.rbsConfigurationContext.getMoRepositoryWrapper();
        this.ldn = ldnIn;
    }

    public void subscribe() {
        logger.traceEnter(THIS_CLASS, "subscribe()");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, "UpgradePackage", "progressHeader");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, "UpgradePackage", "state");
        logger.traceReturn(THIS_CLASS, "subscribe()");
    }

    public void unsubscribe() {
        logger.traceEnter(THIS_CLASS, "unsubscribe()");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, "UpgradePackage", "progressHeader");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, "UpgradePackage", "state");
        logger.traceReturn(THIS_CLASS, "unsubscribe()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAvc(String ldnIn, String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        try {
            logger.traceEnter(THIS_CLASS, "reportAvc()");
            int headerValue = -1;
            UpHeader header = UpHeader.UNSPECIFED_HEADER;
            int stateValue = -1;
            UpState state = UpState.UNSPECIFED_STATE;
            String additionalInfo = "";
            if (attributeName.equals("progressHeader")) {
                this.currentHeaderValue = headerValue = ((Integer)attributeValue).intValue();
                header = UpHeader.toUpHeader(headerValue);
                RbsConfigurationReportLoggerFactory.getLogger().logAttribute("UpgradePackage", "progressHeader", header.toString());
                if (header.isFailed()) {
                    Struct[] actionResult;
                    UpgradePackageMo upMo = (UpgradePackageMo)this.moRepositoryWrapper.lookup(this.ldn);
                    if (upMo != null && (actionResult = upMo.getActionResult(coordinator)) != null) {
                        additionalInfo = this.getAdditionalInfo(actionResult);
                    }
                    ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade Failure", additionalInfo);
                    logger.traceAbnormal(THIS_CLASS, "Upgrade failed: " + additionalInfo);
                }
                this.notificationReceived(header, additionalInfo);
            } else if (attributeName.equals("state")) {
                this.currentStateValue = stateValue = ((Integer)attributeValue).intValue();
                state = UpState.toUpState(stateValue);
                RbsConfigurationReportLoggerFactory.getLogger().logAttribute("UpgradePackage", "state", state.toString());
                this.notificationReceived(state, additionalInfo);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            logger.traceReturn(THIS_CLASS, "attributeValueChanged()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "attributeValueChanged()");
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        Integer stateValue;
        ManagedObject mo = this.moRepositoryWrapper.lookup(this.ldn);
        Integer headerValue = (Integer)mo.getAttribute("progressHeader", coordinator);
        if (headerValue != null && headerValue != this.currentHeaderValue) {
            this.reportAvc(this.ldn, "progressHeader", headerValue, coordinator);
        }
        if ((stateValue = (Integer)mo.getAttribute("state", coordinator)) != null && stateValue != this.currentStateValue) {
            this.reportAvc(this.ldn, "state", stateValue, coordinator);
        }
    }

    protected String getAdditionalInfo(Struct[] actionResults) {
        String additionalInfo = "";
        String info = "";
        try {
            if (actionResults != null && actionResults.length > 0) {
                Struct actionResultData = actionResults[0];
                info = (String)actionResultData.getValue("additionalInfo");
                int infoValue = (Integer)actionResultData.getValue("info");
                additionalInfo = infoValue >= 0 && infoValue < RbsConfigurationDefinitions.INFORMATION_VALUES.length ? RbsConfigurationDefinitions.INFORMATION_VALUES[infoValue] + ": " + info : info;
            }
        }
        catch (Exception e) {
            logger.traceAbnormal(THIS_CLASS, "Caught an exception when trying to get additional information. Reason: " + e.getMessage());
        }
        return additionalInfo;
    }

    public Object getUpgradeNotification() {
        return this.notification;
    }

    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    protected void notificationReceived(Object upgradeNotification, String additionalInfo) {
        this.notification = upgradeNotification;
        this.additionalInformation = additionalInfo;
    }
}

