/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.upgradepackage.util.constants.UpgradePackageState;

public class UpState
implements UpgradePackageState {
    private static final Map upStateMap = new HashMap();
    public static final UpState STATE_NOT_INSTALLED = new UpState(0);
    public static final UpState STATE_INSTALL_COMPLETED = new UpState(1);
    public static final UpState STATE_UPGRADE_EXECUTING = new UpState(2);
    public static final UpState STATE_AWAITING_CONFIRMATION = new UpState(3);
    public static final UpState STATE_ONLY_DELETEABLE = new UpState(4);
    public static final UpState STATE_INSTALL_EXECUTING = new UpState(5);
    public static final UpState STATE_INSTALL_NOT_COMPLETED = new UpState(6);
    public static final UpState STATE_UPGRADE_COMPLETED = new UpState(7);
    public static final UpState STATE_RESTORE_SU_EXECUTING = new UpState(8);
    public static final UpState STATE_VERIFICATION_EXECUTING = new UpState(9);
    public static final UpState WAITING_FOR_RESUME = new UpState(10);
    public static final UpState UNSPECIFED_STATE = new UpState(-1);
    private final transient int stateValue;
    private final transient String stateDescription;

    private UpState(int stateValueIn) {
        this.stateValue = stateValueIn;
        this.stateDescription = this.findStateDescription(stateValueIn);
        upStateMap.put(new Integer(stateValueIn), this);
    }

    private String findStateDescription(int stateValueIn) {
        String result2 = "Unknown state value: \"" + stateValueIn + "\"";
        try {
            Field[] fields = UpgradePackageState.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getInt(null) != stateValueIn) continue;
                result2 = fields[i].getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return result2;
    }

    public static UpState toUpState(int stateValueIn) {
        return (UpState)upStateMap.get(new Integer(stateValueIn));
    }

    public int getStateValue() {
        return this.stateValue;
    }

    public String getStateDescription() {
        return this.stateDescription;
    }

    public static String getStateDescription(int state) {
        UpState upState = UpState.toUpState(state);
        return upState != null ? upState.getStateDescription() : "";
    }

    public String toString() {
        return this.stateDescription;
    }
}

