/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification;

import java.io.IOException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLogger;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeReadyListener;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.InstallSubscriber;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpHeader;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpState;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class UpgradeSubscriber
extends InstallSubscriber {
    private static final Class THIS_CLASS = UpgradeSubscriber.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected final RbsConfigurationReportLogger reportLogger;
    private final UpgradeReadyListener upgradeReadyListener;
    private final UpgradePackageMo upgradePackageMo;
    protected boolean confirmCalled = false;

    public UpgradeSubscriber(UpgradeReadyListener upgradeReadyListenerIn, UpgradePackageMo upgradePackageMoIn, RbsConfigurationContext rbsConfigurationContextIn) throws IOException {
        super(upgradePackageMoIn.getLocalDistinguishedName(), rbsConfigurationContextIn);
        this.upgradeReadyListener = upgradeReadyListenerIn;
        this.upgradePackageMo = upgradePackageMoIn;
        this.reportLogger = RbsConfigurationReportLoggerFactory.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notificationReceived(Object inputUpgradeNotification, String additionalInfo) {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            try {
                logger.traceEnter(THIS_CLASS, "notificationReceived(" + inputUpgradeNotification + ", " + this.additionalInformation + ")");
                this.notification = inputUpgradeNotification;
                RbsConfigurationHelper configHelper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
                RbsConfigurationReportLogger localReportLogger = RbsConfigurationReportLoggerFactory.getLogger();
                if (inputUpgradeNotification instanceof UpState) {
                    this.handleUpState((UpState)inputUpgradeNotification, configHelper, localReportLogger);
                } else if (inputUpgradeNotification instanceof UpHeader) {
                    this.handleUpHeader((UpHeader)inputUpgradeNotification, additionalInfo, configHelper, localReportLogger);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                logger.traceReturn(THIS_CLASS, "notificationReceived(" + inputUpgradeNotification + ", " + this.additionalInformation + ")");
                throw throwable;
            }
            logger.traceReturn(THIS_CLASS, "notificationReceived(" + inputUpgradeNotification + ", " + this.additionalInformation + ")");
        }
    }

    private void handleUpState(UpState upgradeNotification, RbsConfigurationHelper configHelper, RbsConfigurationReportLogger localReportLogger) {
        block6: {
            if (upgradeNotification.equals(UpState.STATE_AWAITING_CONFIRMATION)) {
                try {
                    if (this.confirmCalled) {
                        logger.traceDebug(THIS_CLASS, "Upgrade already confirmed");
                        break block6;
                    }
                    RbsConfigurationReportLoggerFactory.getLogger().logAction("UpgradePackage", "confirmUpgrade", "", "");
                    this.confirmCalled = true;
                    this.upgradePackageMo.actionConfirmUpgrade(null);
                    logger.traceGeneral(THIS_CLASS, "Confirm upgrade sent");
                }
                catch (MoAccessException mae) {
                    logger.traceError(THIS_CLASS, "notificationReceived(" + upgradeNotification + "): Failed to confirm upgrade", (Throwable)mae);
                    String errorMsg = "Failed to confirm upgrade. " + mae.getReasonTag();
                    String slogan = "Confirm Upgrade Failed";
                    configHelper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Confirm Upgrade Failed", errorMsg);
                    this.unsubscribe();
                    this.upgradeReadyListener.upgradeFailed(errorMsg);
                }
            } else if (upgradeNotification.equals(UpState.STATE_UPGRADE_COMPLETED)) {
                logger.traceGeneral(THIS_CLASS, "Upgrade completed successfully");
                localReportLogger.logAttribute("UpgradePackage", "state", upgradeNotification.getStateDescription());
                this.unsubscribe();
                this.upgradeReadyListener.upgradeSuccessful();
            }
        }
    }

    private void handleUpHeader(UpHeader upgradeNotification, String additionalInfo, RbsConfigurationHelper configHelper, RbsConfigurationReportLogger localReportLogger) {
        if (upgradeNotification.isRebootRequested()) {
            String infoMsg = "Received reboot header: " + upgradeNotification.getHeaderDescription();
            logger.traceGeneral(THIS_CLASS, infoMsg);
            localReportLogger.logAttribute("UpgradePackage", "progressHeader", upgradeNotification.getHeaderDescription());
            this.unsubscribe();
            this.upgradeReadyListener.upgradeSuccessful();
        } else if (upgradeNotification.isFailed()) {
            String errorMsg = "Upgrade failed: \"" + upgradeNotification.getHeaderDescription() + "\", \"" + additionalInfo + "\"";
            logger.traceAbnormal(THIS_CLASS, errorMsg);
            String slogan = "Upgrade Failure";
            configHelper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UPGRADE_FAULT, "Upgrade Failure", errorMsg);
            this.unsubscribe();
            this.upgradeReadyListener.upgradeFailed(errorMsg);
        }
    }
}

