/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moadd.model;

import java.util.ArrayList;
import java.util.logging.Level;
import se.ericsson.cello.emt.moadd.MoAddLog;
import se.ericsson.cello.emt.moadd.model.MoAddModel;
import se.ericsson.cello.emt.moadd.view.MoAddView;
import se.ericsson.cello.emt.moti.LdnSelectionListener;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.momodel.MoTemplate;
import se.ericsson.cello.emt.motools.common.momodel.ParentMo;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.neal.NodeConnectionEvent;
import se.ericsson.cello.neal.cm.Mo;

public class MoAddModelImpl
implements MoAddModel {
    private static final String MO_ADDED_NOTIFICATION = "se.ericsson.cello.emt.moadd.MO_ADDED";
    private ToolServices myToolServices = null;
    private Configuration myConfig = null;
    private ParentMo myParentMo;
    private MoAddView myView = null;
    private LdnSelectionListener myLdnSelectionListener = null;

    public MoAddModelImpl(ToolServices ts, Configuration configuration, ParentMo aParentMo) {
        this.myToolServices = ts;
        this.myConfig = configuration;
        this.myParentMo = aParentMo;
    }

    public void addUiView(MoAddView uiView) {
        this.myView = uiView;
    }

    public void exit() {
        this.myView.exit();
    }

    public Configuration getConfiguration() {
        return this.myConfig;
    }

    public String getParentLDN() {
        return this.myConfig.getLdn();
    }

    public ParentMo getParentMo() {
        return this.myParentMo;
    }

    public ToolServices getToolServices() {
        return this.myToolServices;
    }

    public void connectionLost(NodeConnectionEvent event) {
    }

    public void connectionRestored(NodeConnectionEvent event) {
    }

    public Mo createMO(MoTemplate aTemplate, String name, String parentLdn, Mo sourceMo) {
        Mo createdMo = null;
        try {
            MoAddLog.logger().log(Level.FINE, "Creates an " + aTemplate.getMomClass().getName());
            createdMo = this.myParentMo.createChild(aTemplate, name, parentLdn, sourceMo);
            if (null == createdMo) {
                MoAddLog.logger().log(Level.WARNING, "The " + aTemplate.getMomClass().getName() + " MO was not created");
                return null;
            }
            String newLdn = createdMo.getLdn();
            if (this.getToolServices().getNodeServices().getNode().getCmService().getMo(newLdn).exists()) {
                MoAddLog.logger().log(Level.FINE, "Notifies the Ldn Selection Listener that the MO was created");
                ArrayList<String> ldnList = new ArrayList<String>();
                ldnList.add(newLdn);
                if (null != this.myLdnSelectionListener) {
                    this.myLdnSelectionListener.ldnSelected(ldnList);
                }
                this.myToolServices.sendEmNotification(MO_ADDED_NOTIFICATION, "A new MO has been added: \n" + newLdn, newLdn, 0L, System.currentTimeMillis(), this);
                MoAddLog.logger().log(Level.FINE, "The MO " + aTemplate.getMomClass().getName() + " was created.");
            }
        }
        catch (Exception e) {
            MoAddLog.logger().log(Level.SEVERE, "Failed to create the " + aTemplate.getMomClass().getName() + " MO");
            throw new RuntimeException(e);
        }
        return createdMo;
    }

    public void setLdnSelectionListener(LdnSelectionListener listener) {
        MoAddLog.logger().log(Level.FINER, "Set the Ldn Selection Listener");
        this.myLdnSelectionListener = listener;
    }
}

