/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.moproperties.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.moproperties.controller.ActionExecutionListener;
import se.ericsson.cello.emt.moproperties.controller.MoPropertiesController;
import se.ericsson.cello.emt.moproperties.view.gui.ProgressGui;
import se.ericsson.cello.emt.motools.common.gui.components.ComponentFactory;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.InformationButtonGui;
import se.ericsson.cello.emt.motools.common.gui.components.LabelledComponentTable;
import se.ericsson.cello.emt.motools.common.gui.components.SmartProperties;
import se.ericsson.cello.emt.motools.common.gui.components.StringGUI;
import se.ericsson.cello.emt.motools.common.momodel.ActionModel;
import se.ericsson.cello.emt.motools.common.momodel.ParameterModel;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.StringTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;

public class ActionDetailsGUI {
    private GUI gui = null;
    private Container owner = null;
    private SmartProperties properties = null;
    private ActionModel myActionModel = null;
    private static ImageIcon readOnlyImage = null;
    private static ImageIcon readWriteImage = null;
    private JPanel parameterAndResultAndExceptionArea = null;
    private JButton executeButton = null;
    private JButton cancelB = null;
    private static final String EXECUTE = "Execute";
    private static final String NO_VALUE_RETRNED = "No value will be returned";
    private static final int DISABLE_TIME = 5000;
    private static final boolean imageURL = false;
    private List<DataTypeGUI> myParameterGuiList = new ArrayList<DataTypeGUI>(0);
    private Timer setCursorTimer;
    protected ToolServices myToolServices = null;
    protected MoPropertiesController myMoPropController = null;
    private ProgressGui myProgressGui = null;
    private JPanel progressAttributesPanel = null;
    private JPanel progressBarPanel = null;
    private JPanel progressAdditionalActionPanel = null;
    private GridBagConstraints c = new GridBagConstraints();
    private int numberOfPanels = 0;
    private LabelledComponentTable selectedAttrP = null;
    private LabelledComponentTable progressBarP = null;
    private LabelledComponentTable progressAdditionalActionP = null;
    private JScrollPane scroller = null;

    public ActionDetailsGUI(Container owner, SmartProperties properties, ActionModel aAction, String actionName, ToolServices aToolServices, MoPropertiesController controller) {
        this.owner = owner;
        this.properties = properties;
        this.myToolServices = aToolServices;
        this.myMoPropController = controller;
        this.myActionModel = aAction;
        this.init();
    }

    private void init() {
        if (null == readOnlyImage) {
            readOnlyImage = this.getImageIcon(false, "outparam.gif");
        }
        if (null == readWriteImage) {
            readWriteImage = this.getImageIcon(false, "inoutparam.gif");
        }
        try {
            this.gui = new GUI();
            this.gui.init();
        }
        catch (Exception e) {
            this.myMoPropController.showErrorMessage("Failed to initialize the user interface for action " + this.myActionModel.getName(), e);
        }
    }

    public JPanel getParameterResultExceptionArea() {
        return this.parameterAndResultAndExceptionArea;
    }

    public JButton getExecuteBtn() {
        return this.executeButton;
    }

    private ImageIcon getImageIcon(boolean url, String iconImageName) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = !url ? new ImageIcon(Toolkit.getDefaultToolkit().getImage(GUI.class.getResource(iconImageName))) : new ImageIcon(iconImageName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return imageIcon;
    }

    private void pushGuiValuesToActionParameterModels() {
        for (DataTypeGUI parameterGUI : this.myParameterGuiList) {
            parameterGUI.applyValue();
            parameterGUI.setModified(false);
        }
    }

    private void execute() {
        if (this.reallyExecuteTheAction()) {
            try {
                this.parameterAndResultAndExceptionArea.setCursor(new Cursor(3));
                this.getExecuteBtn().setEnabled(false);
                this.clearActionResultsGUI();
                this.pushGuiValuesToActionParameterModels();
                this.myMoPropController.executeActionAsynchronous(this.myActionModel, new ActionExecutionListener(){

                    public void notifyActionIsDone(ActionModel actionModelThatPerformedTheAction, final TypeValue actionResultTypeValue, final boolean actionSucceeded) {
                        if (ActionDetailsGUI.this.myActionModel == actionModelThatPerformedTheAction) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    try {
                                        if (actionSucceeded) {
                                            ActionDetailsGUI.this.gui.setMyActionExecuted(true);
                                            ActionDetailsGUI.this.gui.updateResult(actionResultTypeValue);
                                            if (ActionDetailsGUI.this.myActionModel.isVoidAction()) {
                                                ActionDetailsGUI.this.setCursorTimer = new Timer(5000, new ActionListener(){

                                                    public void actionPerformed(ActionEvent evt) {
                                                        ActionDetailsGUI.this.parameterAndResultAndExceptionArea.setCursor(new Cursor(0));
                                                        ActionDetailsGUI.this.getExecuteBtn().setEnabled(true);
                                                        ActionDetailsGUI.this.setCursorTimer.stop();
                                                    }
                                                });
                                                ActionDetailsGUI.this.setCursorTimer.start();
                                            } else {
                                                ActionDetailsGUI.this.parameterAndResultAndExceptionArea.setCursor(new Cursor(0));
                                                ActionDetailsGUI.this.getExecuteBtn().setEnabled(true);
                                            }
                                        } else {
                                            ActionDetailsGUI.this.gui.setMyActionExecuted(false);
                                            ActionDetailsGUI.this.parameterAndResultAndExceptionArea.setCursor(new Cursor(0));
                                            ActionDetailsGUI.this.getExecuteBtn().setEnabled(true);
                                        }
                                    }
                                    catch (Exception e) {
                                        ActionDetailsGUI.this.gui.setMyActionExecuted(false);
                                        ActionDetailsGUI.this.myMoPropController.showErrorMessage("Failed to update the action result.", e);
                                        ActionDetailsGUI.this.parameterAndResultAndExceptionArea.setCursor(new Cursor(0));
                                        ActionDetailsGUI.this.getExecuteBtn().setEnabled(true);
                                    }
                                    ActionDetailsGUI.this.myToolServices.sendEmNotification(GuiTestEventTypes.ACTION_EXECUTED, this.getClass().getSimpleName() + " has been refreshed" + " after execution of an action", null, GuiTestEventTypes.claimSeqNum(), System.currentTimeMillis(), this);
                                }
                            });
                        }
                    }
                });
            }
            catch (Exception e) {
                this.parameterAndResultAndExceptionArea.setCursor(new Cursor(0));
                this.myMoPropController.showErrorMessage("Could not execute the action " + this.myActionModel.getName(), e);
            }
        }
    }

    private boolean reallyExecuteTheAction() {
        boolean reallyDoIt = true;
        String disturbances = this.myActionModel.getMomAction().getDisturbances();
        if (null != disturbances) {
            Object[] options = new Object[]{EXECUTE, "Cancel"};
            Object result = options[1];
            StringBuilder message = new StringBuilder();
            String title = this.myMoPropController.getModel().getConfiguration().getManagerTitle() + " - Warning";
            String nodetype = this.myMoPropController.getModel().getConfiguration().getNodeType();
            message.append("The execution of this action can cause disturbances:");
            message.append("\n\n");
            message.append(disturbances);
            message.append("\n\n");
            message.append("Do you want to proceed?");
            NarrowOptionPane narrowOptionPane = new NarrowOptionPane(70);
            narrowOptionPane.setMessage(message.toString());
            narrowOptionPane.setMessageType(2);
            narrowOptionPane.setOptionType(0);
            narrowOptionPane.setOptions(options);
            narrowOptionPane.setInitialValue(options[1]);
            JDialog dialog = narrowOptionPane.createDialog(this.owner, title);
            StringBuilder headerText = new StringBuilder();
            if (null != nodetype) {
                headerText.append(nodetype);
                headerText.append(" ");
            }
            headerText.append("Disturbance!");
            JPanel headerPanel = new JPanel(new BorderLayout(5, 8));
            if (null != nodetype) {
                Image nodeImage = this.myMoPropController.getModel().getConfiguration().getIconImage();
                ImageIcon nodeImageIcon = new ImageIcon(nodeImage);
                JLabel iconLabel = new JLabel(headerText.toString(), nodeImageIcon, 0);
                headerPanel.add((Component)iconLabel, "Center");
            } else {
                JLabel textLabel = new JLabel(headerText.toString(), 0);
                headerPanel.add((Component)textLabel, "Center");
            }
            headerPanel.add((Component)new JPanel(), "North");
            headerPanel.add((Component)new JPanel(), "South");
            dialog.add((Component)headerPanel, "North");
            dialog.pack();
            dialog.setVisible(true);
            result = narrowOptionPane.getValue();
            if (result != options[0]) {
                reallyDoIt = false;
            }
        }
        return reallyDoIt;
    }

    public String getExecTooltip() {
        String toolTip = "Execute " + this.myActionModel.getName();
        if (this.myActionModel.isVoidAction()) {
            toolTip = toolTip + ". " + NO_VALUE_RETRNED + ".";
        }
        return toolTip;
    }

    private ActionListener getExecActionListener() {
        return new ExecActionListener();
    }

    private void clearActionResultsGUI() {
        if (null != this.gui.resultP) {
            this.gui.resultP.removeAll();
        }
        this.gui.updateNeeded();
        this.parameterAndResultAndExceptionArea.repaint();
    }

    private synchronized ProgressGui getProgressGui() {
        if (null == this.myProgressGui) {
            this.myProgressGui = new ProgressGui(this.myMoPropController);
        }
        return this.myProgressGui;
    }

    public class GUI
    extends JPanel
    implements GUI_Container {
        private static final long serialVersionUID = 3847168131946977748L;
        LabelledComponentTable parametersP = null;
        LabelledComponentTable resultP = null;
        private JLabel stateIcon = null;
        private String propertyHeightName = null;
        private String propertyWidthName = null;
        private final boolean BUTTON_NOT_VISIBLE = false;
        private boolean myActionExecuted = false;

        public GUI() {
            this.propertyHeightName = ActionDetailsGUI.this.myActionModel.getName() + "-Oper_Height";
            this.propertyWidthName = ActionDetailsGUI.this.myActionModel.getName() + "-Oper_Width";
            ActionDetailsGUI.this.parameterAndResultAndExceptionArea = this.buildParameterAndResultAndExceptionArea();
            ActionDetailsGUI.this.executeButton = new JButton(ActionDetailsGUI.EXECUTE);
            ActionDetailsGUI.this.executeButton.setMnemonic('E');
            ActionDetailsGUI.this.executeButton.setToolTipText(ActionDetailsGUI.this.getExecTooltip());
            ActionDetailsGUI.this.executeButton.addActionListener(ActionDetailsGUI.this.getExecActionListener());
            ActionDetailsGUI.this.cancelB = new JButton("  Cancel  ");
            ActionDetailsGUI.this.cancelB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                }
            });
            for (DataTypeGUI gui : ActionDetailsGUI.this.myParameterGuiList) {
                String name;
                String value;
                if (gui == null || gui.getTypeValue() == null || (value = ActionDetailsGUI.this.myMoPropController.getMoActionParameterValue(name = gui.getTypeValue().getName())) == null) continue;
                gui.setValue(value);
            }
        }

        private JPanel buildParameterAndResultAndExceptionArea() {
            JButton additionalButton;
            JPanel parAndResPAndExcP = new JPanel(new BorderLayout(1, 1));
            JPanel parAndResP = new JPanel();
            JPanel progressAndResultP = new JPanel();
            progressAndResultP.setLayout(new GridBagLayout());
            parAndResP.setLayout(new BorderLayout());
            parAndResP.setOpaque(true);
            ActionDetailsGUI.this.scroller = new JScrollPane(parAndResP, 20, 30);
            ActionDetailsGUI.this.scroller.getHorizontalScrollBar().setUnitIncrement(50);
            ActionDetailsGUI.this.scroller.getVerticalScrollBar().setUnitIncrement(30);
            ActionDetailsGUI.this.scroller.getHorizontalScrollBar().setCursor(new Cursor(0));
            ActionDetailsGUI.this.scroller.getVerticalScrollBar().setCursor(new Cursor(0));
            parAndResPAndExcP.add((Component)ActionDetailsGUI.this.scroller, "Center");
            JPanel excP = new JPanel(new BorderLayout(1, 1));
            parAndResPAndExcP.add((Component)excP, "North");
            excP.setOpaque(false);
            if (ActionDetailsGUI.this.myActionModel.getNumberOfParameters() > 0) {
                this.parametersP = new LabelledComponentTable("", "Parameters:", 3, 3, null, null, true, this, false, ActionDetailsGUI.this.myToolServices);
                parAndResP.add((Component)this.parametersP.getPanel(), "North");
            }
            ActionDetailsGUI.this.myParameterGuiList.clear();
            for (int i = 0; i < ActionDetailsGUI.this.myActionModel.getNumberOfParameters(); ++i) {
                ParameterModel par = ActionDetailsGUI.this.myActionModel.getParameterModelAt(i);
                JPanel infoAndLabelPanel = new JPanel(new FlowLayout(0, 0, 0));
                JPanel infoButtonPanel = new JPanel();
                InformationButtonGui infoButtonGui = new InformationButtonGui(this, ActionDetailsGUI.this.myToolServices);
                infoButtonGui.setName(par.getName());
                infoButtonPanel.setName(par.getName() + "_Name");
                infoButtonGui.setDescription(par.getMomParameter().getExtendedDescription());
                infoButtonPanel.add(infoButtonGui);
                JLabel nameLabel = new JLabel(par.getName() + ":");
                infoAndLabelPanel.add(infoButtonPanel);
                infoAndLabelPanel.add((Component)nameLabel, "Center");
                this.parametersP.addI(infoAndLabelPanel);
                this.stateIcon = new JLabel();
                this.parametersP.addI(this.stateIcon);
                DataTypeGUI parameterGUI = ComponentFactory.create(par.getTypeValue(), false, this, par.getName(), true, ActionDetailsGUI.this.myToolServices);
                ActionDetailsGUI.this.myParameterGuiList.add(parameterGUI);
                parameterGUI.setLayout(new FlowLayout(0, 0, 12));
                this.parametersP.addI(parameterGUI);
            }
            ActionDetailsGUI.this.progressBarPanel = ActionDetailsGUI.this.getProgressGui().buildProgressBarAreaForMoActionGui();
            if (null != ActionDetailsGUI.this.progressBarPanel) {
                String progressHeading = "";
                if (null == ActionDetailsGUI.this.progressBarP) {
                    ActionDetailsGUI.this.progressBarP = new LabelledComponentTable("", progressHeading, 3, 3, null, null, true, this, false, ActionDetailsGUI.this.myToolServices);
                }
                ActionDetailsGUI.this.progressBarP.addI(ActionDetailsGUI.this.progressBarPanel);
                this.setLayoutConstraints(2);
                progressAndResultP.add((Component)ActionDetailsGUI.this.progressBarP.getPanel(), ActionDetailsGUI.this.c);
            }
            if ((additionalButton = ActionDetailsGUI.this.getProgressGui().buildProgressAdditionalArea()) != null) {
                if (ActionDetailsGUI.this.progressAdditionalActionPanel == null) {
                    ActionDetailsGUI.this.progressAdditionalActionPanel = new JPanel(new BorderLayout(5, 5));
                }
                ActionDetailsGUI.this.progressAdditionalActionPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
                ActionDetailsGUI.this.progressAdditionalActionPanel.add((Component)additionalButton, "North");
                String progressHeading = "";
                if (null == ActionDetailsGUI.this.progressAdditionalActionP) {
                    ActionDetailsGUI.this.progressAdditionalActionP = new LabelledComponentTable("", progressHeading, 3, 3, null, null, true, this, false, ActionDetailsGUI.this.myToolServices);
                }
                ActionDetailsGUI.this.progressAdditionalActionP.addI(ActionDetailsGUI.this.progressAdditionalActionPanel);
                this.setLayoutConstraints(1);
                progressAndResultP.add((Component)ActionDetailsGUI.this.progressAdditionalActionP.getPanel(), ActionDetailsGUI.this.c);
            }
            ActionDetailsGUI.this.progressAttributesPanel = ActionDetailsGUI.this.getProgressGui().buildProgressAttributesAreaForMoActionGui();
            if (null != ActionDetailsGUI.this.progressAttributesPanel) {
                if (null == ActionDetailsGUI.this.selectedAttrP) {
                    ActionDetailsGUI.this.selectedAttrP = new LabelledComponentTable("", "", 3, 3, null, null, true, this, false, ActionDetailsGUI.this.myToolServices);
                }
                ActionDetailsGUI.this.selectedAttrP.addI(ActionDetailsGUI.this.progressAttributesPanel);
                this.setLayoutConstraints(2);
                progressAndResultP.add((Component)ActionDetailsGUI.this.selectedAttrP.getPanel(), ActionDetailsGUI.this.c);
            }
            String resultHeading = "";
            resultHeading = "<html>Result:</html>";
            this.resultP = new LabelledComponentTable("", resultHeading, 3, 3, null, null, true, this, false, ActionDetailsGUI.this.myToolServices);
            this.setLayoutConstraints(2);
            progressAndResultP.add((Component)this.resultP.getPanel(), ActionDetailsGUI.this.c);
            parAndResP.add((Component)progressAndResultP, "West");
            Dimension minSize = new Dimension(5, 10);
            Dimension prefSize = new Dimension(10, 30);
            Dimension maxSize = new Dimension(Short.MAX_VALUE, 300);
            Box.Filler filler = new Box.Filler(minSize, prefSize, maxSize);
            parAndResP.add((Component)filler, "South");
            return parAndResPAndExcP;
        }

        private void setLayoutConstraints(int columnStretch) {
            ((ActionDetailsGUI)ActionDetailsGUI.this).c.fill = 2;
            ((ActionDetailsGUI)ActionDetailsGUI.this).c.gridx = 0;
            ((ActionDetailsGUI)ActionDetailsGUI.this).c.gridy = ActionDetailsGUI.this.numberOfPanels;
            ((ActionDetailsGUI)ActionDetailsGUI.this).c.anchor = 23;
            ((ActionDetailsGUI)ActionDetailsGUI.this).c.gridwidth = columnStretch;
            ((ActionDetailsGUI)ActionDetailsGUI.this).c.weighty = 1.0;
            ActionDetailsGUI.this.numberOfPanels++;
        }

        public void init() {
            ActionDetailsGUI.this.parameterAndResultAndExceptionArea.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    Dimension newSize = GUI.this.getSize();
                    ActionDetailsGUI.this.properties.setInt(GUI.this.propertyHeightName, newSize.height);
                    ActionDetailsGUI.this.properties.setInt(GUI.this.propertyWidthName, newSize.width);
                    Container c = null;
                    Container cc = null;
                    if (null != ActionDetailsGUI.this.parameterAndResultAndExceptionArea && null != (c = ActionDetailsGUI.this.parameterAndResultAndExceptionArea.getParent())) {
                        cc = c.getParent();
                    }
                    if (null != cc) {
                        cc.invalidate();
                        cc.validate();
                    }
                }
            });
            ActionDetailsGUI.this.executeButton.setEnabled(this.validateParameters());
            if (null != ActionDetailsGUI.this.scroller) {
                this.scrollToTop(ActionDetailsGUI.this.scroller);
            }
        }

        private void scrollToTop(final JScrollPane scroll) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GUI.this.scrollToTop(scroll);
                    }
                });
            } else {
                scroll.getVerticalScrollBar().setValue(0);
            }
        }

        public void updateNeeded() {
            ActionDetailsGUI.this.parameterAndResultAndExceptionArea.invalidate();
            ActionDetailsGUI.this.parameterAndResultAndExceptionArea.validate();
        }

        public boolean validateParameters() {
            boolean returnValue = true;
            if (null == this.parametersP) {
                return true;
            }
            for (DataTypeGUI parameterGUI : ActionDetailsGUI.this.myParameterGuiList) {
                if (parameterGUI.faultyValueEntered()) {
                    returnValue = false;
                    break;
                }
                String currentText = parameterGUI.getValue();
                if (null == currentText || !currentText.equalsIgnoreCase("")) continue;
                if (parameterGUI instanceof StringGUI) {
                    StringTypeValue stringModel = ((StringGUI)parameterGUI).getStringTypeValue();
                    String minValue = stringModel.getMinAsStringValue();
                    if (!currentText.equalsIgnoreCase("") || "".equals(minValue) || "0".equalsIgnoreCase(minValue)) continue;
                    returnValue = false;
                    break;
                }
                returnValue = false;
                break;
            }
            return returnValue;
        }

        public void valueChanged() {
            ActionDetailsGUI.this.executeButton.setEnabled(this.validateParameters());
            this.setMyActionExecuted(false);
            this.clearResultLabel();
        }

        private void updateResult(TypeValue actionResultTypeValue) {
            MoPropLog.logger().info("before ActionDetails updateResult(...)");
            if (null != this.resultP) {
                this.resultP.removeAll();
                this.updateNeeded();
            }
            try {
                if (null != this.resultP) {
                    String resultHtml = "<html> Result:";
                    if (this.myActionExecuted) {
                        resultHtml = resultHtml + "<br>Executed.";
                    }
                    if (ActionDetailsGUI.this.myActionModel.isVoidAction()) {
                        resultHtml = resultHtml + "<BR>No value will be returned.";
                    }
                    resultHtml = resultHtml + "</html>";
                    this.resultP.setLabelText(resultHtml);
                    if (null != actionResultTypeValue) {
                        this.layoutTheReturnedActionResults(ActionDetailsGUI.this.myActionModel, actionResultTypeValue);
                    }
                    MoPropLog.logger().info("resultHtml: " + resultHtml);
                }
            }
            catch (Exception e) {
                ActionDetailsGUI.this.myMoPropController.showErrorMessage("Failed to update result for action " + ActionDetailsGUI.this.myActionModel.getName(), e);
            }
            ActionDetailsGUI.this.parameterAndResultAndExceptionArea.invalidate();
            ActionDetailsGUI.this.parameterAndResultAndExceptionArea.validate();
            MoPropLog.logger().info("done with ActionDetails updateResult(...)");
        }

        public boolean isMyActionExecuted() {
            return this.myActionExecuted;
        }

        public void setMyActionExecuted(boolean myActionExecuted) {
            this.myActionExecuted = myActionExecuted;
        }

        private void layoutTheReturnedActionResults(ActionModel actionModel, TypeValue actionResultTypeValue) {
            MoPropLog.logger().info("start ActionDetails layoutTheReturnedActionResults(...)");
            TypeValue returnValue = actionResultTypeValue;
            LabelledComponentTable returnParamContainer = null;
            String actionName = actionModel.getName();
            boolean resultVisible = true;
            boolean resultReadOnly = true;
            if (null != returnValue) {
                returnParamContainer = this.resultP;
                returnParamContainer.addI(new JLabel(""));
                JLabel stateIcon = new JLabel();
                returnParamContainer.addI(stateIcon);
                DataTypeGUI valueGUI = ComponentFactory.create(returnValue, resultReadOnly, this, actionName, resultVisible, ActionDetailsGUI.this.myToolServices);
                valueGUI.setLayout(new FlowLayout(0, 0, 12));
                returnParamContainer.addI(valueGUI);
            }
            MoPropLog.logger().info("done with ActionDetails layoutTheReturnedActionResults(...)");
        }

        public void clearResultLabel() {
            String resultLabel = "";
            resultLabel = "<html>Result:</html>";
            this.resultP.setLabelText(resultLabel);
        }
    }

    private class ExecActionListener
    implements ActionListener {
        private ExecActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            ActionDetailsGUI.this.execute();
        }
    }

    class NarrowOptionPane
    extends JOptionPane {
        private static final long serialVersionUID = -6030192043650018176L;
        int maxCharactersPerLineCount = 50;

        NarrowOptionPane(int maxCharactersPerLineCount) {
            this.maxCharactersPerLineCount = maxCharactersPerLineCount;
        }

        public int getMaxCharactersPerLineCount() {
            return this.maxCharactersPerLineCount;
        }
    }
}

