/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.mosearch;

import java.util.Properties;
import se.ericsson.cello.emt.motools.common.config.impl.CommonConfiguration;
import se.ericsson.cello.emt.motools.common.toolservices.Tool;

public class MoSearchConfiguration
extends CommonConfiguration {
    private static final String DEFAULT_LDN = "ManagedElement=1";
    private static final String EMPTY_STRING = "";
    private String myLdn;
    private boolean moClassSpecified = false;
    private String moClassToSearchFor = null;

    public MoSearchConfiguration(Properties properties) {
        super(properties);
        this.moClassToSearchFor = properties.getProperty("MOCLASS");
        if (this.moClassToSearchFor != null) {
            this.moClassSpecified = true;
        }
        this.parseLDNs();
    }

    public String getLdn() {
        return this.myLdn;
    }

    public String getMoClass() {
        return this.moClassToSearchFor;
    }

    public boolean moClassSpecified() {
        return this.moClassSpecified;
    }

    public Tool getUserPreferenceTool() {
        return null;
    }

    public Tool getMoSearchTool() {
        return null;
    }

    public void setMoClassSpecified(boolean isMoClassSpecified) {
        this.moClassSpecified = isMoClassSpecified;
    }

    public void setLdn(String ldn) {
        this.myLdn = ldn;
    }

    private void parseLDNs() {
        String ldns = this.properties.getProperty("LDNs");
        if (ldns == null || ldns.equalsIgnoreCase(EMPTY_STRING)) {
            this.myLdn = DEFAULT_LDN;
        } else {
            String[] ldnsArray = ldns.split(";");
            this.myLdn = ldnsArray[0];
        }
    }
}

