/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.gui.components.ComponentFactory;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.EnumGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.InformationButtonGui;
import se.ericsson.cello.emt.motools.common.gui.components.LabelledComponentTable;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.ClassTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.CorbaTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.EnumTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.SequenceTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.StructTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

public class ArrayGUI
extends LabelledComponentTable
implements GUI_Container {
    private static final long serialVersionUID = 6613553470130505250L;
    private int initialNumberOfElements;
    private boolean readOnly;
    private boolean supportNullValue;
    private JButton plusButton = null;
    private JButton minusButton = null;
    private SequenceTypeValue seqModel;
    private boolean isValidInput = true;
    private static int ARRAY_MAX_SIZE = 1000;
    private static int COMPONENTS_PER_ELEMENT = 2;

    public ArrayGUI(SequenceTypeValue aSuArray, boolean isReadOnly, GUI_Container container, boolean supportNullValue, ToolServices aToolServices, boolean initiallyExpanded) {
        super("", "", 2, COMPONENTS_PER_ELEMENT, null, null, initiallyExpanded, container, aToolServices);
        this.readOnly = isReadOnly;
        this.supportNullValue = supportNullValue;
        this.seqModel = aSuArray;
        this.setName(aSuArray.getName() + "_Value");
        if (this.seqModel.getDescription() != null) {
            this.add((Component)this.infoBtn, "East");
            this.infoBtn.setMargin(this.infoInsets);
            this.infoBtn.addActionListener(this.infoActionListener);
        }
        this.initialNumberOfElements = this.seqModel.getElements().size();
        if (this.initialNumberOfElements > ARRAY_MAX_SIZE) {
            MoPropLog.logger().log(Level.FINEST, "Number of elements = " + this.initialNumberOfElements + ". Only the first " + ARRAY_MAX_SIZE + " will be displayed.");
            this.initialNumberOfElements = ARRAY_MAX_SIZE;
            this.readOnly = true;
        }
        TypeValue aElementModel2 = null;
        List<TypeValue> elementList = null;
        elementList = this.seqModel.getElements();
        for (TypeValue aElementModel2 : elementList) {
            this.addArrayElementGUI(aElementModel2);
        }
        if (!this.readOnly && this.seqModel.isDynamic()) {
            this.makeGUIDynamic(true);
        }
    }

    private void makeGUIDynamic(boolean dynamic) {
        if (this.plusButton == null) {
            this.plusButton = new JButton(" + ");
            this.minusButton = new JButton(" - ");
            Insets insets = new Insets(0, 0, 0, 0);
            this.plusButton.setMargin(insets);
            this.minusButton.setMargin(insets);
            this.plusButton.setToolTipText("Add element");
            this.minusButton.setToolTipText("Remove element");
            this.plusButton.setEnabled(this.plusButtonStatus());
            this.minusButton.setEnabled(this.minusButtonStatus());
            this.plusButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    int length = ArrayGUI.this.seqModel.getElements().size();
                    int maxMomLength = ArrayGUI.this.seqModel.getMaxLength();
                    if (length < ARRAY_MAX_SIZE && (-1 == maxMomLength || length < maxMomLength)) {
                        TypeValue newElement = ArrayGUI.this.seqModel.createNewElement();
                        ArrayGUI.this.addArrayElementGUI(newElement);
                        ArrayGUI.this.valueChanged();
                        ArrayGUI.this.minusButton.setEnabled(true);
                    }
                    ArrayGUI.this.plusButton.setEnabled(ArrayGUI.this.plusButtonStatus());
                    ArrayGUI.this.updateNeeded();
                }
            });
            this.minusButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ArrayGUI.this.removeAnElement();
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridLayout(2, 1));
            buttonPanel.add(this.plusButton);
            buttonPanel.add(this.minusButton);
            JPanel labelPanel = this.getLabelPanel();
            labelPanel.setName(this.seqModel.getName());
            labelPanel.add(buttonPanel);
        }
    }

    private void removeAnElement() {
        int numberOfElements = this.seqModel.getLength();
        Object[] selectionValues = new Integer[numberOfElements];
        for (int ordinal = 0; ordinal < numberOfElements; ++ordinal) {
            selectionValues[ordinal] = ordinal;
        }
        Object[] options = new Object[]{"Remove", "Cancel"};
        JOptionPane pane = new JOptionPane("Ordinal no. of the item:", 1, 0, null, options, options[0]);
        pane.setSelectionValues(selectionValues);
        JDialog dialog = pane.createDialog(this.tablePanel, "Select Item to Remove");
        dialog.setVisible(true);
        Object selectedButtonText = pane.getValue();
        if (null != selectedButtonText && selectedButtonText.equals("Remove")) {
            Integer elementNo = (Integer)pane.getInputValue();
            this.seqModel.removeElement(elementNo);
            this.removeArrayElementGUI(elementNo);
            this.valueChanged();
            this.plusButton.setEnabled(true);
            this.minusButton.setEnabled(this.minusButtonStatus());
            this.updateNeeded();
        }
    }

    private boolean plusButtonStatus() {
        return -1 == this.seqModel.getMaxLength() || this.seqModel.getElements().size() < this.seqModel.getMaxLength();
    }

    private boolean minusButtonStatus() {
        return this.seqModel.getLength() > 0;
    }

    protected void addArrayElementGUI(TypeValue element) {
        if (super.getComponentCount() < ARRAY_MAX_SIZE * COMPONENTS_PER_ELEMENT) {
            JPanel infoBtnPanel = new JPanel();
            JPanel infoLabelPanel = new JPanel();
            InformationButtonGui infoButtonGui = new InformationButtonGui(this, this.myToolServices);
            infoButtonGui.setName(element.getName());
            this.getDescription(element);
            infoButtonGui.setDescription(this.getDescription(element));
            infoLabelPanel.setLayout(new FlowLayout(0, 0, 0));
            infoBtnPanel.add(infoButtonGui);
            int index = super.getComponentCount() / COMPONENTS_PER_ELEMENT;
            JLabel ordinalLabel = new JLabel(Integer.toString(index) + ":");
            ordinalLabel.setVerticalAlignment(1);
            infoLabelPanel.add(infoBtnPanel);
            infoLabelPanel.add(ordinalLabel);
            infoLabelPanel.setName(this.getName() + ":" + index + "_Name");
            this.addI(infoLabelPanel);
            DataTypeGUI elementGUI = ComponentFactory.create(element, this.readOnly, this, this.fullName, this.supportNullValue, this.myToolServices);
            elementGUI.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 1));
            elementGUI.setLayout(new FlowLayout(0, 0, 11));
            elementGUI.setOpaque(false);
            elementGUI.setName(this.getName() + ":" + index + "_Value");
            this.addI(elementGUI);
            this.updateNeeded();
        }
    }

    private void updateElementOrdinals() {
        for (int i = 0; i < this.seqModel.getLength(); ++i) {
            Component compLabel;
            JPanel panel;
            Component comp = this.getComponent(i * COMPONENTS_PER_ELEMENT);
            if (!(comp instanceof JPanel) || (panel = (JPanel)comp).getComponentCount() <= 1 || !((compLabel = panel.getComponent(1)) instanceof JLabel)) continue;
            JLabel ordinalLabel = (JLabel)compLabel;
            ordinalLabel.setText(i + ":");
            comp.setName(this.getName() + ":" + i + "_Name");
            this.getComponent(i * COMPONENTS_PER_ELEMENT + 1).setName(this.getName() + ":" + i + "_Value");
        }
    }

    private String getDescription(TypeValue element) {
        String description = "";
        if (element instanceof StructTypeValue) {
            StructTypeValue typeValue = (StructTypeValue)element;
            description = typeValue.getMomStruct().getExtendedDescription();
        } else if (element instanceof EnumTypeValue) {
            EnumTypeValue typeValue = (EnumTypeValue)element;
            description = typeValue.getMomEnum().getExtendedDescription();
        } else if (element instanceof ClassTypeValue) {
            ClassTypeValue typeValue = (ClassTypeValue)element;
            description = typeValue.getMomClass().getExtendedDescription();
        } else {
            CorbaTypeValue typeValue = (CorbaTypeValue)element;
            description = typeValue.getMomCorbaTypeAttribute().getExtendedDescription();
        }
        return description;
    }

    public String applyValue() {
        int numberOfElements = this.seqModel.getElements().size();
        DataTypeGUI aGui = null;
        for (int i = 0; i < numberOfElements; ++i) {
            aGui = (DataTypeGUI)this.getComponent(i * COMPONENTS_PER_ELEMENT + 1);
            aGui.applyValue();
        }
        this.setModified(false);
        this.initialNumberOfElements = numberOfElements;
        return null;
    }

    public void setValue(String value) {
        int numberOfElements = this.seqModel.getElements().size();
        for (int i = 0; i < numberOfElements; ++i) {
            DataTypeGUI valueGUI = (DataTypeGUI)this.getComponent(i * COMPONENTS_PER_ELEMENT + 1);
            if (valueGUI instanceof EnumGUI) {
                ((EnumGUI)valueGUI).addItem(value);
            }
            valueGUI.setValue(value);
        }
        this.setModified(false);
    }

    public void setGUIEditable(boolean editable) {
        this.makeGUIDynamic(editable);
        int numberOfElements = this.seqModel.getElements().size();
        for (int i = 0; i < numberOfElements; ++i) {
            ((DataTypeGUI)this.getComponent(i * COMPONENTS_PER_ELEMENT + 1)).setGUIEditable(editable);
        }
    }

    public void refreshValue() {
        int numberOfRows;
        int numberOfElements = this.seqModel.getLength();
        if (numberOfElements > ARRAY_MAX_SIZE) {
            MoPropLog.logger().log(Level.INFO, "Number of elements = " + numberOfElements + ". Only the first " + ARRAY_MAX_SIZE + " will be displayed.");
            numberOfElements = ARRAY_MAX_SIZE;
        }
        if ((numberOfRows = super.getComponentCount() / COMPONENTS_PER_ELEMENT) > numberOfElements) {
            while (numberOfRows-- > numberOfElements) {
                this.removeArrayElementGUI();
            }
        } else if (numberOfRows < numberOfElements) {
            while (numberOfRows < numberOfElements) {
                this.addArrayElementGUI(this.seqModel.getElementAt(numberOfRows++));
            }
        }
        for (int i = 0; i < numberOfElements; ++i) {
            ((DataTypeGUI)this.getComponent(i * COMPONENTS_PER_ELEMENT + 1)).refreshValue();
        }
        this.setModified(false);
    }

    protected void removeArrayElementGUI() {
        super.removeI(super.getComponentCount() - 1);
        super.removeI(super.getComponentCount() - 1);
        this.updateNeeded();
    }

    protected void removeArrayElementGUI(int elementNo) {
        if (elementNo < super.getComponentCount() / COMPONENTS_PER_ELEMENT) {
            for (int i = 0; i < COMPONENTS_PER_ELEMENT; ++i) {
                super.removeI(elementNo * COMPONENTS_PER_ELEMENT);
            }
            this.updateElementOrdinals();
            this.updateNeeded();
        } else {
            MoPropLog.logger().info("A try to remove an array element with a larger index than the array length.");
        }
    }

    public void updateNeeded() {
        this.panel.invalidate();
        this.container.updateNeeded();
    }

    public void setIsValid(boolean isValid) {
        this.isValidInput = isValid;
    }

    public boolean faultyValueEntered() {
        return !this.isValidInput;
    }

    public void valueChanged() {
        boolean anyChange = false;
        boolean anyFaulty = false;
        int numberOfElements = super.getComponentCount() / COMPONENTS_PER_ELEMENT;
        if (numberOfElements != this.initialNumberOfElements) {
            anyChange = true;
        }
        for (int i = 0; i < numberOfElements; ++i) {
            if (((DataTypeGUI)this.getComponent(i * COMPONENTS_PER_ELEMENT + 1)).isModified()) {
                anyChange = true;
            }
            if (!((DataTypeGUI)this.getComponent(i * COMPONENTS_PER_ELEMENT + 1)).faultyValueEntered()) continue;
            anyFaulty = true;
        }
        this.setIsValid(!anyFaulty);
        this.setModified(anyChange);
    }

    public DataTypeGUI[] getMemberGUIs() {
        int numberOfElements = this.seqModel.getLength();
        DataTypeGUI[] memberGUIs = new DataTypeGUI[numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            memberGUIs[i] = (DataTypeGUI)this.getComponent(i * COMPONENTS_PER_ELEMENT + 1);
        }
        return memberGUIs;
    }
}

