/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.mimparser;

import se.ericsson.cello.emt.motools.common.mimparser.Entities;
import se.ericsson.cello.emt.motools.common.mimparser.Methods;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.MomStructMember;

public class MimCompatibility {
    static boolean[][] availableMethods = new boolean[Methods.values().length][Entities.values().length];
    static boolean[][] testedMethods = new boolean[Methods.values().length][Entities.values().length];

    public static String getDeprecated(MomEntity momEntity) {
        String deprecated = null;
        Methods method = Methods.GET_DEPRECATED;
        Entities entity = Entities.getEnum4Entity(momEntity);
        if (entity != Entities.UNKNOWN) {
            if (testedMethods[method.ordinal()][entity.ordinal()]) {
                if (availableMethods[method.ordinal()][entity.ordinal()]) {
                    deprecated = MimCompatibility.forwardGetDeprecated(entity, momEntity);
                }
            } else {
                try {
                    MimCompatibility.testedMethods[method.ordinal()][entity.ordinal()] = true;
                    deprecated = MimCompatibility.forwardGetDeprecated(entity, momEntity);
                    MimCompatibility.availableMethods[method.ordinal()][entity.ordinal()] = true;
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
        }
        return deprecated;
    }

    public static String getObsolete(MomEntity momEntity) {
        String obsolete = null;
        Methods method = Methods.GET_OBSOLETE;
        Entities entity = Entities.getEnum4Entity(momEntity);
        if (entity != Entities.UNKNOWN) {
            if (testedMethods[method.ordinal()][entity.ordinal()]) {
                if (availableMethods[method.ordinal()][entity.ordinal()]) {
                    obsolete = MimCompatibility.forwardGetObsolete(entity, momEntity);
                }
            } else {
                try {
                    MimCompatibility.testedMethods[method.ordinal()][entity.ordinal()] = true;
                    obsolete = MimCompatibility.forwardGetObsolete(entity, momEntity);
                    MimCompatibility.availableMethods[method.ordinal()][entity.ordinal()] = true;
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
        }
        return obsolete;
    }

    public static boolean isInterfaceOnly(MomEntity momEntity) {
        boolean interfaceOnly = false;
        Methods method = Methods.IS_INTERFACE_ONLY;
        Entities entity = Entities.getEnum4Entity(momEntity);
        if (entity != Entities.UNKNOWN) {
            if (testedMethods[method.ordinal()][entity.ordinal()]) {
                if (availableMethods[method.ordinal()][entity.ordinal()]) {
                    interfaceOnly = MimCompatibility.forwardIsInterfaceOnly(entity, momEntity);
                }
            } else {
                try {
                    MimCompatibility.testedMethods[method.ordinal()][entity.ordinal()] = true;
                    interfaceOnly = MimCompatibility.forwardIsInterfaceOnly(entity, momEntity);
                    MimCompatibility.availableMethods[method.ordinal()][entity.ordinal()] = true;
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
        }
        return interfaceOnly;
    }

    private static String forwardGetDeprecated(Entities entity, MomEntity momEntity) {
        switch (entity) {
            case ACTION: {
                MomAction momAction = (MomAction)momEntity;
                return momAction.getDeprecated();
            }
            case ATTRIBUTE: {
                MomAttribute momAttribute = (MomAttribute)momEntity;
                return momAttribute.getDeprecated();
            }
            case ENUM_MEMBER: {
                MomEnumMember momEnumMember = (MomEnumMember)momEntity;
                return momEnumMember.getDeprecated();
            }
            case STRUCT_MEMBER: {
                MomStructMember momStructMember = (MomStructMember)momEntity;
                return momStructMember.getDeprecated();
            }
        }
        return null;
    }

    private static String forwardGetObsolete(Entities entity, MomEntity momEntity) {
        switch (entity) {
            case ACTION: {
                MomAction momAction = (MomAction)momEntity;
                return momAction.getObsolete();
            }
            case ATTRIBUTE: {
                MomAttribute momAttribute = (MomAttribute)momEntity;
                return momAttribute.getObsolete();
            }
            case ENUM_MEMBER: {
                MomEnumMember momEnumMember = (MomEnumMember)momEntity;
                return momEnumMember.getObsolete();
            }
            case STRUCT_MEMBER: {
                MomStructMember momStructMember = (MomStructMember)momEntity;
                return momStructMember.getObsolete();
            }
        }
        return null;
    }

    private static boolean forwardIsInterfaceOnly(Entities entity, MomEntity momEntity) {
        switch (entity) {
            case ACTION: {
                MomAction momAction = (MomAction)momEntity;
                return momAction.isInterfaceOnly();
            }
            case ATTRIBUTE: {
                MomAttribute momAttribute = (MomAttribute)momEntity;
                return momAttribute.isInterfaceOnly();
            }
        }
        return false;
    }

    static {
        for (Methods method : Methods.values()) {
            for (Entities entity : Entities.values()) {
                MimCompatibility.availableMethods[method.ordinal()][entity.ordinal()] = false;
                MimCompatibility.testedMethods[method.ordinal()][entity.ordinal()] = false;
            }
        }
    }
}

