/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.common;

import java.util.ResourceBundle;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

public class Severity
implements Comparable {
    private static ResourceBundle myBundle = null;
    public static Severity CriticalSeverity = new Severity(2);
    public static Severity MajorSeverity = new Severity(3);
    public static Severity WarningSeverity = new Severity(5);
    public static Severity ClearedSeverity = new Severity(6);
    public static Severity MinorSeverity = new Severity(4);
    public static Severity IndeterminateSeverity = new Severity(1);
    private Short mySeverityState;
    private String myPresentationString = "";

    private Severity(short severityState) {
        if (myBundle == null) {
            String languageKey = "se.ericsson.cello.emas.fm.resources.language.FaultManagementLanguage";
            myBundle = GuilibResourceBundle.getBundle((String)languageKey, (ClassLoader)this.getClass().getClassLoader());
        }
        this.mySeverityState = new Short(severityState);
        switch (severityState) {
            case 2: {
                this.myPresentationString = myBundle.getString("PS_CRITICAL_STRING");
                break;
            }
            case 3: {
                this.myPresentationString = myBundle.getString("PS_MAJOR_STRING");
                break;
            }
            case 5: {
                this.myPresentationString = myBundle.getString("PS_WARNING_STRING");
                break;
            }
            case 6: {
                this.myPresentationString = myBundle.getString("PS_CLEARED_STRING");
                break;
            }
            case 4: {
                this.myPresentationString = myBundle.getString("PS_MINOR_STRING");
                break;
            }
            case 1: {
                this.myPresentationString = myBundle.getString("PS_INDETERMINATE_STRING");
                break;
            }
            default: {
                Log.logError((String)"Can't create a Severity object");
            }
        }
    }

    public static Severity getSeverity(Short severityState) {
        return Severity.getSeverity((short)severityState);
    }

    public static Severity getSeverity(short severityState) {
        Severity tmpSev = null;
        switch (severityState) {
            case 2: {
                tmpSev = CriticalSeverity;
                break;
            }
            case 3: {
                tmpSev = MajorSeverity;
                break;
            }
            case 5: {
                tmpSev = WarningSeverity;
                break;
            }
            case 6: {
                tmpSev = ClearedSeverity;
                break;
            }
            case 4: {
                tmpSev = MinorSeverity;
                break;
            }
            case 1: {
                tmpSev = IndeterminateSeverity;
                break;
            }
            default: {
                Log.logError((String)"Can't find a Severity object");
            }
        }
        return tmpSev;
    }

    public Short getSeverityShortValue() {
        return this.mySeverityState;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Severity) {
            return this.myPresentationString.compareTo(obj.toString());
        }
        throw new ClassCastException();
    }

    public String toString() {
        return this.myPresentationString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Severity) {
            Short shortValue = ((Severity)obj).getSeverityShortValue();
            return this.mySeverityState.equals(shortValue);
        }
        return false;
    }

    public int hashCode() {
        return this.mySeverityState.hashCode();
    }
}

