/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.common.fropxy;

import enea.ose.system.InSignal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.cello.common.fropxy.MoAlarmable;
import se.ericsson.cello.mao.AlarmHandler;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public abstract class FroProxy
implements SignalObserver,
SubscriptionObserver {
    protected Hashtable subscriptions = new Hashtable();
    private Vector txHandlerList = new Vector();
    private static final int REGISTER_FOR_NOTIF = 1;
    private static final int DEREGISTER_FOR_NOTIF = 2;

    public void registerForNotifications(Coordinator coordinator, ManagedObject managedObject, int n) {
        this.registerForNotifications(managedObject, n);
        if (coordinator != null) {
            OrderedAction orderedAction = new OrderedAction(n, managedObject, 1);
            if (!this.subscriptions.containsKey(new Integer(n))) {
                this.subscriptions.put(new Integer(n), managedObject);
            }
            if (!this.isRegisteredInTransaction(coordinator)) {
                this.txHandlerList.addElement(new TxHandlerFroProxy(this, orderedAction, coordinator));
            } else {
                this.storeAction(orderedAction, coordinator);
            }
        }
    }

    private void registerForNotifications(ManagedObject managedObject, int n) {
        if (!this.subscriptions.containsKey(new Integer(n))) {
            this.subscriptions.put(new Integer(n), managedObject);
        }
    }

    public void deregisterForNotifications(Coordinator coordinator, int n) {
        ManagedObject managedObject = (ManagedObject)this.subscriptions.get(new Integer(n));
        OrderedAction orderedAction = new OrderedAction(n, managedObject, 2);
        if (!this.isRegisteredInTransaction(coordinator)) {
            this.txHandlerList.addElement(new TxHandlerFroProxy(this, orderedAction, coordinator));
        } else {
            this.storeAction(orderedAction, coordinator);
        }
    }

    private void deregisterForNotifications(ManagedObject managedObject, int n) {
        this.subscriptions.remove(new Integer(n));
    }

    private void removeTxHandler(TxHandlerFroProxy txHandlerFroProxy) {
        boolean bl = false;
        for (int i = 0; i < this.txHandlerList.size(); ++i) {
            if ((TxHandlerFroProxy)this.txHandlerList.elementAt(i) != txHandlerFroProxy) continue;
            this.txHandlerList.removeElementAt(i);
            bl = true;
        }
        if (!bl) {
            MessageLog.traceError((Class)FroProxy.class, (String)"Private method removeTxHandler error", null);
        }
    }

    private void storeAction(OrderedAction orderedAction, Coordinator coordinator) {
        int n = coordinator.getTransactionID();
        boolean bl = false;
        for (int i = 0; i < this.txHandlerList.size(); ++i) {
            if (((TxHandlerFroProxy)this.txHandlerList.elementAt(i)).getTranId() != n) continue;
            ((TxHandlerFroProxy)this.txHandlerList.elementAt(i)).addAction(orderedAction, coordinator.getTransactionID());
            bl = true;
        }
        if (!bl) {
            MessageLog.traceError((Class)FroProxy.class, (String)"Private method storeAction error", null);
        }
    }

    private boolean isRegisteredInTransaction(Coordinator coordinator) {
        boolean bl = false;
        int n = coordinator.getTransactionID();
        for (int i = 0; i < this.txHandlerList.size(); ++i) {
            if (((TxHandlerFroProxy)this.txHandlerList.elementAt(i)).getTranId() != n) continue;
            bl = true;
        }
        return bl;
    }

    public void serviceRemoved(String string) {
        Enumeration enumeration = this.subscriptions.elements();
        while (enumeration.hasMoreElements()) {
            ManagedObject managedObject = (ManagedObject)enumeration.nextElement();
            if (managedObject == null || !(managedObject instanceof MoAlarmable)) continue;
            MoAlarmable moAlarmable = (MoAlarmable)managedObject;
            moAlarmable.ceaseAllAlarms(this.getClass().getName());
        }
        AlarmHandler.clearNonGenericAlarms(this.getClass().getName());
    }

    public abstract void signalReceived(InSignal var1);

    public abstract void serviceAdded(String var1);

    private class TxHandlerFroProxy
    implements Resource {
        private int tranId;
        private Vector actionList = new Vector();
        FroProxy froProxyRef;

        private TxHandlerFroProxy(FroProxy froProxy2, OrderedAction orderedAction, Coordinator coordinator) {
            this.froProxyRef = froProxy2;
            this.tranId = coordinator.getTransactionID();
            this.actionList.addElement(orderedAction);
            try {
                coordinator.registerResource((Resource)this);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                this.rollback();
            }
        }

        public void addAction(OrderedAction orderedAction, int n) {
            if (this.tranId != n) {
                MessageLog.traceError((Class)(class$se$ericsson$cello$common$fropxy$FroProxy == null ? (class$se$ericsson$cello$common$fropxy$FroProxy = FroProxy.class$("se.ericsson.cello.common.fropxy.FroProxy")) : class$se$ericsson$cello$common$fropxy$FroProxy), (String)"Method addAction error.", null);
            }
            OrderedAction orderedAction2 = orderedAction;
            this.actionList.addElement(orderedAction2);
        }

        public int getTranId() {
            return this.tranId;
        }

        public void commit() {
            for (int i = 0; i < this.actionList.size(); ++i) {
                OrderedAction orderedAction = (OrderedAction)this.actionList.elementAt(i);
                if (orderedAction.action == 1) continue;
                if (orderedAction.action == 2) {
                    this.froProxyRef.deregisterForNotifications(orderedAction.maoRef, orderedAction.froId);
                    continue;
                }
                MessageLog.traceError((Class)(class$se$ericsson$cello$common$fropxy$FroProxy == null ? FroProxy.class$("se.ericsson.cello.common.fropxy.FroProxy") : class$se$ericsson$cello$common$fropxy$FroProxy), (String)"rollback - trouble report this", null);
            }
            this.froProxyRef.removeTxHandler(this);
        }

        public void rollback() {
            for (int i = 0; i < this.actionList.size(); ++i) {
                OrderedAction orderedAction = (OrderedAction)this.actionList.elementAt(i);
                if (orderedAction.action == 1) {
                    this.froProxyRef.deregisterForNotifications(orderedAction.maoRef, orderedAction.froId);
                    continue;
                }
                if (orderedAction.action == 2) continue;
                MessageLog.traceError((Class)(class$se$ericsson$cello$common$fropxy$FroProxy == null ? FroProxy.class$("se.ericsson.cello.common.fropxy.FroProxy") : class$se$ericsson$cello$common$fropxy$FroProxy), (String)"rollback - trouble report this", null);
            }
            this.froProxyRef.removeTxHandler(this);
        }

        public boolean prepare() {
            return true;
        }
    }

    public class OrderedAction {
        public int froId;
        public ManagedObject maoRef;
        public int action;

        private OrderedAction(int n, ManagedObject managedObject, int n2) {
            this.froId = n;
            this.maoRef = managedObject;
            this.action = n2;
        }
    }
}

