/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.common.fropxy;

import enea.ose.system.InSignal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import se.ericsson.cello.common.fropxy.ObserverList;
import se.ericsson.cello.common.fropxy.PnpSignalPort;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.thread.BlockingQueue;

public final class PnpSignalPortManager
implements PnpSignalPort,
SignalObserver,
Runnable {
    private static PnpSignalPortManager pm = new PnpSignalPortManager();
    private ObserverList ol;
    private Thread myThread;
    private BlockingQueue myQueue;
    private int waitingThreads = 0;
    private Set lockedBy = Collections.synchronizedSet(new HashSet());
    private SignalPort signalPort = PortManager.instance();
    private static final String CMA_PNP_SIGNALPORT_NAME = "CmaPnpSignalPortManagerThread";
    private static final int MAX_SIGNAL_QUEUE_SIZE = 500;

    public static PnpSignalPort instance() {
        return pm;
    }

    public void addSignalObserver(SignalObserver signalObserver, Class clazz) {
        MessageLog.trace((int)5, this.getClass(), (String)("addSignalObserver() , adding observer: " + signalObserver + " on signal: " + clazz));
        this.ol.add(signalObserver, clazz);
        this.signalPort.addSignalObserver((SignalObserver)this, clazz);
    }

    public void addInternalSignalObserver(SignalObserver signalObserver, Class clazz) {
        MessageLog.trace((int)5, this.getClass(), (String)("addInternalSignalObserver() , adding observer: " + signalObserver + " on signal: " + clazz));
        this.ol.add(signalObserver, clazz);
    }

    public void removeSignalObserver(SignalObserver signalObserver, Class clazz) {
        this.ol.remove(signalObserver, clazz);
        this.signalPort.removeSignalObserver((SignalObserver)this, clazz);
    }

    public void removeInternalSignalObserver(SignalObserver signalObserver, Class clazz) {
        this.ol.remove(signalObserver, clazz);
    }

    public void addSignalToQueue(InSignal inSignal) {
        MessageLog.trace((int)5, this.getClass(), (String)("addToSignalQueue(), thread: " + Thread.currentThread() + " adding signal: " + inSignal + " to queue."));
        if (!this.myQueue.enqueue((Object)inSignal)) {
            MessageLog.traceError(this.getClass(), (String)"addToSignalQueue() to many incomming signals!. The queue is full and signals are dropped.");
            this.myQueue.clear();
        }
    }

    public boolean isIdle() {
        return this.myQueue.getNoOfWaitingThreads() > 0;
    }

    public void signalReceived(InSignal inSignal) {
        MessageLog.trace((int)5, this.getClass(), (String)("signalReceived(), received signal: " + inSignal + " from sender PID " + Integer.toHexString(inSignal.getSender().getPID())));
        if (!this.myQueue.enqueue((Object)inSignal)) {
            MessageLog.traceError(this.getClass(), (String)"signalReceived() to many incomming signals!. The queue is full and signals are dropped.");
            this.myQueue.clear();
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    InSignal inSignal = (InSignal)this.myQueue.dequeue();
                    this.notifySubscribers(inSignal);
                }
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), (String)"run() ", (Throwable)throwable);
                continue;
            }
            break;
        }
    }

    private synchronized void notifySubscribers(InSignal inSignal) {
        Enumeration enumeration;
        MessageLog.trace((int)5, this.getClass(), (String)"enter notifySubscribers()");
        if (this.isLocked()) {
            while (this.isLocked()) {
                MessageLog.trace((int)5, this.getClass(), (String)("locked by: " + this.printLockedByContent() + ", thread " + Thread.currentThread().getName() + " is blocked and waiting to execute in notifySubscribers()"));
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    MessageLog.trace((int)5, this.getClass(), (String)("notifySubscribers(), exception: " + interruptedException));
                }
                this.removeDeadThreads();
            }
        }
        if ((enumeration = this.ol.getEnumeratedObservers(inSignal.getClass())) != null) {
            while (enumeration.hasMoreElements()) {
                SignalObserver signalObserver = (SignalObserver)enumeration.nextElement();
                MessageLog.trace((int)5, this.getClass(), (String)(" calling observer: " + signalObserver + " with signal: " + inSignal));
                signalObserver.signalReceived(inSignal);
            }
        }
        MessageLog.trace((int)5, this.getClass(), (String)"return notifySubscribers()");
    }

    public synchronized void unlock() {
        Thread thread = Thread.currentThread();
        if (this.lockedBy.contains(thread)) {
            this.lockedBy.remove(thread);
            MessageLog.trace((int)5, this.getClass(), (String)("unlock(), requested by thread " + thread.getName()));
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)("unlock(), requested thread " + thread.getName() + " requested unlocked but the signalPort was never locked by this thread"));
        }
        this.notify();
    }

    private synchronized void removeDeadThreads() {
        MessageLog.trace((int)5, this.getClass(), (String)"removeDeadThreads()");
        Iterator iterator = this.lockedBy.iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            if (thread.isAlive()) continue;
            MessageLog.info(this.getClass(), (String)("removeDeadThreads() thread: " + thread.getName() + " has died while holding the lock and will be removed from queue."));
            iterator.remove();
        }
    }

    public synchronized boolean isLocked() {
        MessageLog.trace((int)5, this.getClass(), (String)("isLocked() " + !this.lockedBy.isEmpty()));
        return !this.lockedBy.isEmpty();
    }

    public boolean isLockedByThread() {
        MessageLog.trace((int)5, this.getClass(), (String)("isLockedBy(),  thread " + Thread.currentThread().getName() + " owner of a lock :" + this.lockedBy.contains(Thread.currentThread())));
        return this.lockedBy.contains(Thread.currentThread());
    }

    private String printLockedByContent() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.lockedBy.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(": " + ((Thread)iterator.next()).getName());
        }
        return stringBuffer.toString();
    }

    public synchronized void lock() {
        Thread thread = Thread.currentThread();
        if (!this.lockedBy.contains(thread)) {
            this.lockedBy.add(thread);
            MessageLog.trace((int)5, this.getClass(), (String)("lock(), requested by thread: " + thread.getName()));
        } else {
            MessageLog.trace((int)5, this.getClass(), (String)("lock(), requested but the signalPort was already locked by user: " + thread.getName()));
        }
    }

    private PnpSignalPortManager() {
        this.ol = new ObserverList();
        this.myQueue = new BlockingQueue(500);
        this.myThread = new Thread((Runnable)this, CMA_PNP_SIGNALPORT_NAME);
        this.myThread.start();
    }
}

