/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.indications.fropxy;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactory;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerImpl;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.support.debug.MessageLog;

public class MaoFroIndicationHandlerFactoryImpl
implements MaoFroIndicationHandlerFactory {
    private static MaoFroIndicationHandlerFactory instance = null;
    private static final String FROTYPE = "froType";
    private static final String SERVICE_NAME = "serviceName";
    private Map froTypeMap = new HashMap();

    public static MaoFroIndicationHandlerFactory instance() {
        if (instance == null) {
            instance = new MaoFroIndicationHandlerFactoryImpl();
        }
        return instance;
    }

    private MaoFroIndicationHandlerFactoryImpl() {
    }

    public MaoFroIndicationHandlerImpl create(Class clazz) {
        TagNameDictionary tagNameDictionary = null;
        MaoFroIndicationHandlerImpl maoFroIndicationHandlerImpl = null;
        try {
            tagNameDictionary = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(clazz.getName()));
            int n = Integer.parseInt(tagNameDictionary.lookupValue(FROTYPE), 16);
            String string = tagNameDictionary.lookupValue(SERVICE_NAME);
            maoFroIndicationHandlerImpl = this.create(string, n);
        }
        catch (Throwable throwable) {
            MessageLog.traceError(this.getClass(), (String)("Create indicationHandler instance for " + clazz.getName() + " failed"), (Throwable)throwable);
        }
        return maoFroIndicationHandlerImpl;
    }

    public MaoFroIndicationHandlerImpl create(String string, int n) {
        MaoFroIndicationHandlerImpl maoFroIndicationHandlerImpl = null;
        if (!this.froTypeMap.containsKey(new Integer(n))) {
            try {
                maoFroIndicationHandlerImpl = new MaoFroIndicationHandlerImpl(string, n);
                this.froTypeMap.put(new Integer(n), maoFroIndicationHandlerImpl);
            }
            catch (Throwable throwable) {
                MessageLog.traceError(this.getClass(), (String)("Create indicationHandler instance for " + string + ", " + n + " failed"), (Throwable)throwable);
            }
        } else {
            maoFroIndicationHandlerImpl = (MaoFroIndicationHandlerImpl)this.froTypeMap.get(new Integer(n));
            if (!maoFroIndicationHandlerImpl.getServiceName().equals(string)) {
                MessageLog.traceError(this.getClass(), (String)("IndicationHandler for froType " + n + " can not be created for serviceName " + string + " since it already exists for different serviceName " + maoFroIndicationHandlerImpl.getServiceName()));
            }
        }
        return maoFroIndicationHandlerImpl;
    }
}

