/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.InetAddressUtil;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;

public class Ipv4AddressValidation {
    private String addrAsString;
    private long addrAsLong;
    private static Ipv4AddressValidation defaultIpAddress;

    public Ipv4AddressValidation(String string) throws IpFormatException {
        this.addrAsLong = Ipv4AddressValidation.ipAddrString2Long(string);
        this.addrAsString = this.ipAddrInt2String((int)this.addrAsLong);
    }

    public Ipv4AddressValidation(long l) throws IpFormatException {
        this.addrAsString = this.ipAddrInt2String((int)l);
        this.addrAsLong = Ipv4AddressValidation.ipAddrString2Long(this.addrAsString);
    }

    public static boolean isDefault(String string) throws IpFormatException {
        IpAddress ipAddress = new IpAddress(string);
        return ipAddress.toInt() == 0;
    }

    public static boolean isIpv4(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '.') {
                ++n;
            }
            if (string.charAt(i) != ':') continue;
            ++n2;
        }
        return n == 3 && n2 <= 0;
    }

    protected static void validateIpv4(String string) throws IpFormatException {
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(".");
        while (n4 >= 0) {
            string2 = string.substring(n3, n4);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Ipv4AddressValidation.formatException(string, "v4");
            }
            if (string2.length() > 3 || n < 0 || n > 255) {
                Ipv4AddressValidation.formatException(string, "v4");
            }
            n3 = n4 + 1;
            n4 = string.indexOf(".", n3);
            ++n2;
        }
        string2 = string.substring(n3);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Ipv4AddressValidation.formatException(string, "v4");
        }
        if (string2.length() > 3 || n < 0 || n > 255) {
            Ipv4AddressValidation.formatException(string, "v4");
        }
        if (n2 != 3) {
            Ipv4AddressValidation.formatException(string, "v4");
        }
    }

    public static boolean isValidIpv4Address(String string) {
        if (Ipv4AddressValidation.isIpv4(string)) {
            try {
                Ipv4AddressValidation.validateIpv4(string);
                return true;
            }
            catch (IpFormatException ipFormatException) {
                return false;
            }
        }
        return false;
    }

    public static void validateIpV4addressWithPrefix(String string) throws IpFormatException {
        int n;
        String[] stringArray = new String[2];
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '/') continue;
            ++n2;
        }
        if (n2 == 0) {
            Ipv4AddressValidation.validateIpv4(string);
        } else if (n2 == 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            Ipv4AddressValidation.validateIpv4(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            if (n3 < 1 || n3 > 32) {
                throw new IpFormatException("Not a valid prefix length");
            }
        } else {
            Ipv4AddressValidation.formatException(string, "v4");
        }
    }

    public static InetAddress getIpAddress(String string) throws IpFormatException {
        try {
            if (string.equals("")) {
                return InetAddress.getLocalHost();
            }
            InetAddressUtil inetAddressUtil = new InetAddressUtil();
            byte[] byArray = inetAddressUtil.ipStringToBytes(string);
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            Ipv4AddressValidation.formatException(string, "");
            return null;
        }
    }

    public static boolean isLoopBackIpAddress(String string) throws IpFormatException {
        return Ipv4AddressValidation.getIpAddress(string).isLoopbackAddress();
    }

    public static boolean isMultiCastIpAddress(String string) throws IpFormatException {
        return Ipv4AddressValidation.getIpAddress(string).isMulticastAddress();
    }

    public static Ipv4AddressValidation getDefaultIpAddress() throws IpFormatException {
        if (defaultIpAddress == null) {
            defaultIpAddress = new Ipv4AddressValidation("0.0.0.0");
        }
        return defaultIpAddress;
    }

    public String toString() {
        return this.addrAsString;
    }

    public int toInt() {
        return (int)this.addrAsLong;
    }

    public long toLong() {
        return this.addrAsLong;
    }

    public Ipv4AddressValidation getSubnetAddress(int n) throws IpException, IpFormatException {
        return new Ipv4AddressValidation(Ipv4AddressValidation.getSubnetMask(n) & this.toInt());
    }

    public static int getSubnetMask(int n) throws IpException {
        if (n < 0 || n > 32) {
            throw new IpException("Illegal value for networkPrefix. Allowed value is [0,32]. Value is: " + n);
        }
        if (n == 32) {
            return -1;
        }
        int n2 = -1;
        int n3 = 0;
        n3 = n2 >>> n;
        return n3 ^= 0xFFFFFFFF;
    }

    public void validateIpAddrWithinSubnet(int n, Ipv4AddressValidation ipv4AddressValidation, String string) throws MoAccessException {
        Ipv4AddressValidation ipv4AddressValidation2 = this.getSubnetAddress(n);
        if (!ipv4AddressValidation2.equals(ipv4AddressValidation)) {
            throw new ValueOutOfRangeException("The ipAddress " + this.addrAsString + " and prefix " + n + " produces the subnet: " + ipv4AddressValidation2 + " which is not equal to subnet: " + ipv4AddressValidation, string);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Ipv4AddressValidation && this.addrAsString.equals(object.toString());
    }

    public int hashCode() {
        return this.addrAsString.hashCode();
    }

    protected static long ipAddrString2Long(String string) throws IpFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        int n2 = 0;
        String string2 = "";
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n3;
        }
        if (n3 != 3) {
            Ipv4AddressValidation.formatException(string, "");
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                Ipv4AddressValidation.formatException(string, "");
            }
            if (n < 0 || n > 255) {
                Ipv4AddressValidation.formatException(string, "");
            }
            string2 = (string3 = Integer.toHexString(n)).length() == 1 ? string2 + "0" + string3 : string2 + string3;
            ++n2;
        }
        if (n2 != 4) {
            Ipv4AddressValidation.formatException(string, "");
        }
        return Long.parseLong(string2, 16);
    }

    private String ipAddrInt2String(int n) {
        long l = n < 0 ? 0x100000000L + (long)n : (long)n;
        String string = Long.toString(l >>> 24) + "." + Long.toString(l >>> 16 & 0xFFL) + "." + Long.toString(l >>> 8 & 0xFFL) + "." + Long.toString(l & 0xFFL);
        return string;
    }

    private static void formatException(String string, String string2) throws IpFormatException {
        throw new IpFormatException("The address " + string + " is not a valid IP" + string2 + "address");
    }

    public static void validate(String string) throws IpFormatException {
        Ipv6Address.validate(string);
    }
}

