/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.DomainNameFormatException;
import se.ericsson.cello.mao.DomainNameValidation;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.InetAddressUtil;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;

public class Ipv6Address {
    public static boolean isIpv4(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n;
        }
        return n == 3;
    }

    public static boolean isIpv6(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ':') continue;
            ++n;
        }
        return n >= 2 && n <= 7;
    }

    public static boolean isDefault(String string) throws IpFormatException {
        if (Ipv4AddressValidation.isIpv4(string)) {
            return Ipv4AddressValidation.isDefault(string);
        }
        if (Ipv6AddressValidation.isIpv6(string)) {
            return Ipv6AddressValidation.isUnspecifiedIpv6(string);
        }
        Ipv6Address.formatException(string, "");
        return false;
    }

    private static void validateIpv4(String string) throws IpFormatException {
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(".");
        while (n4 >= 0) {
            string2 = string.substring(n3, n4);
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Ipv6Address.formatException(string, "v4");
            }
            if (string2.length() > 3 || n < 0 || n > 255) {
                Ipv6Address.formatException(string, "v4");
            }
            n3 = n4 + 1;
            n4 = string.indexOf(".", n3);
            ++n2;
        }
        string2 = string.substring(n3);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Ipv6Address.formatException(string, "v4");
        }
        if (string2.length() > 3 || n < 0 || n > 255) {
            Ipv6Address.formatException(string, "v4");
        }
        if (n2 != 3) {
            Ipv6Address.formatException(string, "v4");
        }
    }

    private static void validateIpv6(String string) throws IpFormatException {
        String string2 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = string.indexOf(":");
        String string3 = string;
        if (string.indexOf("::") > -1) {
            bl = false;
            if (string.indexOf("::") != string.lastIndexOf("::")) {
                Ipv6Address.formatException(string, "v6");
            }
        }
        if (string.indexOf(".") > 0) {
            String string4 = string.substring(string.lastIndexOf(":") + 1);
            Ipv6Address.validateIpv4(string4);
            string3 = string.substring(0, string.lastIndexOf(":") + 1);
            ++n;
        }
        while (n3 >= 0) {
            string2 = string3.substring(n2, n3);
            if (!Ipv6Address.isHexValue(string2)) {
                Ipv6Address.formatException(string3, "v6");
            }
            n2 = n3 + 1;
            n3 = string3.indexOf(":", n2);
            ++n;
        }
        if (bl) {
            if (n != 7) {
                Ipv6Address.formatException(string3, "v6");
            }
        } else if (n > 7 && (n != 8 || !string.endsWith("::") && !string.startsWith("::"))) {
            Ipv6Address.formatException(string3, "v6");
        }
        if (string.startsWith(":") && !string.startsWith("::") || string.endsWith(":") && !string.endsWith("::")) {
            Ipv6Address.formatException(string, "v6");
        }
        if (!Ipv6Address.isHexValue(string2 = string3.substring(n2))) {
            Ipv6Address.formatException(string3, "v6");
        }
    }

    private static boolean isHexValue(String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        boolean bl = false;
        if ((string = string.toLowerCase()).length() == 0) {
            return true;
        }
        if (string.length() > 4) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            bl = false;
            for (int j = 0; j < cArray.length; ++j) {
                if (string.charAt(i) != cArray[j]) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return bl;
    }

    public static void validate(String string) throws IpFormatException {
        if (Ipv6Address.isDefault(string)) {
            return;
        }
        if (Ipv6Address.isIpv6(string)) {
            Ipv6Address.validateIpv6(string);
        } else if (Ipv6Address.isIpv4(string)) {
            Ipv6Address.validateIpv4(string);
        } else {
            Ipv6Address.formatException(string, "");
        }
    }

    private static void formatException(String string, String string2) throws IpFormatException {
        throw new IpFormatException("The address " + string + " is not a valid IP" + string2 + " address");
    }

    public static boolean isProperIPv6Address(String string) throws IpFormatException {
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ':') continue;
            ++n;
        }
        if (n < 2) {
            bl = false;
        }
        return bl;
    }

    public static InetAddress getIpAddress(String string) throws IpFormatException {
        try {
            if (string.equals("")) {
                return InetAddress.getLocalHost();
            }
            InetAddressUtil inetAddressUtil = new InetAddressUtil();
            byte[] byArray = inetAddressUtil.ipStringToBytes(string);
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            Ipv6Address.formatException(string, "");
            return null;
        }
    }

    public static Inet6Address getIpv6Addres(String string) throws IpFormatException {
        try {
            if (string.equals("")) {
                return (Inet6Address)InetAddress.getLocalHost();
            }
            InetAddressUtil inetAddressUtil = new InetAddressUtil();
            byte[] byArray = inetAddressUtil.ipStringToBytes(string);
            return (Inet6Address)InetAddress.getByAddress(byArray);
        }
        catch (ClassCastException classCastException) {
            Ipv6Address.formatException(string, "v6");
        }
        catch (UnknownHostException unknownHostException) {
            Ipv6Address.formatException(string, "v6");
        }
        return null;
    }

    public static boolean isLinkLocalIpv6(String string) throws IpFormatException {
        return Ipv6Address.getIpv6Addres(string).isLinkLocalAddress();
    }

    public static boolean isUnspecifiedIpv6(String string) throws IpFormatException {
        return Ipv6Address.getIpv6Addres(string).equals(Ipv6Address.getIpv6Addres("::"));
    }

    public static boolean isGlobalUnicastIpv6(String string) throws IpFormatException {
        return !Ipv6Address.getIpv6Addres(string).isLinkLocalAddress() && !Ipv6Address.getIpv6Addres(string).isLoopbackAddress() && !Ipv6Address.getIpv6Addres(string).isMulticastAddress() && !Ipv6Address.isUnspecifiedIpv6(string);
    }

    public static boolean isLoopBackIpv6Address(String string) throws IpFormatException {
        return Ipv6Address.getIpv6Addres(string).isLoopbackAddress();
    }

    public static boolean isLoopBackIpAddress(String string) throws IpFormatException {
        return Ipv6Address.getIpAddress(string).isLoopbackAddress();
    }

    public static boolean isMultiCastIpAddress(String string) throws IpFormatException {
        return Ipv6Address.getIpAddress(string).isMulticastAddress();
    }

    public static boolean isValidIpv6Addres(String string) {
        if (Ipv6Address.isIpv6(string)) {
            try {
                Ipv6Address.validateIpv6(string);
                return true;
            }
            catch (IpFormatException ipFormatException) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidIpv4Address(String string) {
        if (Ipv6Address.isIpv4(string)) {
            try {
                Ipv6Address.validateIpv4(string);
                return true;
            }
            catch (IpFormatException ipFormatException) {
                return false;
            }
        }
        return false;
    }

    public static boolean compareNetPrefix(String string, String string2, int n) throws IpFormatException {
        byte[] byArray = Ipv6Address.getIpv6Addres(string).getAddress();
        byte[] byArray2 = Ipv6Address.getIpv6Addres(string2).getAddress();
        byte by = 0;
        int n2 = n / 8;
        Arrays.fill(byArray, n2, 16, by);
        Arrays.fill(byArray2, n2, 16, by);
        return Arrays.equals(byArray, byArray2);
    }

    public static String getNetworkPrefix(String string, int n) throws IpFormatException {
        int n2 = n / 8;
        Inet6Address inet6Address = null;
        byte[] byArray = Ipv6Address.getIpv6Addres(string).getAddress();
        byte by = 0;
        Arrays.fill(byArray, n2, 16, by);
        try {
            inet6Address = (Inet6Address)InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            Ipv6Address.formatException(string, "v6");
        }
        return inet6Address.getHostAddress();
    }

    public static void validateIpV4addressWithPrefix(String string) throws IpFormatException {
        int n;
        String[] stringArray = new String[2];
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '/') continue;
            ++n2;
        }
        if (n2 == 0) {
            Ipv6Address.validateIpv4(string);
        } else if (n2 == 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            Ipv6Address.validateIpv4(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            if (n3 < 0 || n3 > 32) {
                throw new IpFormatException("Not a valid prefix length");
            }
        } else {
            Ipv6Address.formatException(string, "v4");
        }
    }

    public static void validateHostName(String string, String string2) throws ValueOutOfRangeException {
        try {
            Ipv6Address.validate(string);
        }
        catch (IpFormatException ipFormatException) {
            try {
                DomainNameValidation.validate(string);
            }
            catch (DomainNameFormatException domainNameFormatException) {
                throw new ValueOutOfRangeException(string, string2, "Invalid format of IpAddress and domain name");
            }
        }
    }

    public static void validateIpV6addressWithPrefix(String string) throws IpFormatException {
        int n;
        String[] stringArray = new String[2];
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '/') continue;
            ++n2;
        }
        if (n2 == 0) {
            Ipv6Address.validateIpv6(string);
        } else if (n2 == 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            Ipv6Address.validateIpv6(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            if (n3 < 0 || n3 > 128) {
                throw new IpFormatException("Not a valid prefix length");
            }
        } else {
            Ipv6Address.formatException(string, "v6");
        }
    }

    public static String getHostAddress(String string, String string2) throws MoAccessException {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalAttributeValueException("Given " + string + " is an invalid IpAddress or DomainName", string2);
        }
        return string;
    }
}

