/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import se.ericsson.cello.mao.InetAddressUtil;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;

public class Ipv6AddressValidation {
    public static boolean isIpv6(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ':') continue;
            ++n;
        }
        return n >= 2 && n <= 7;
    }

    protected static void validateIpv6(String string) throws IpFormatException {
        String string2 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = string.indexOf(":");
        String string3 = string;
        if (string.indexOf("::") > -1) {
            bl = false;
            if (string.indexOf("::") != string.lastIndexOf("::")) {
                Ipv6AddressValidation.formatException(string, "v6");
            }
        }
        if (string.indexOf(".") > 0) {
            String string4 = string.substring(string.lastIndexOf(":") + 1);
            Ipv4AddressValidation.validateIpv4(string4);
            string3 = string.substring(0, string.lastIndexOf(":") + 1);
            ++n;
        }
        while (n3 >= 0) {
            string2 = string3.substring(n2, n3);
            if (!Ipv6AddressValidation.isHexValue(string2)) {
                Ipv6AddressValidation.formatException(string3, "v6");
            }
            n2 = n3 + 1;
            n3 = string3.indexOf(":", n2);
            ++n;
        }
        if (bl) {
            if (n != 7) {
                Ipv6AddressValidation.formatException(string3, "v6");
            }
        } else if (n > 7 && (n != 8 || !string.endsWith("::") && !string.startsWith("::"))) {
            Ipv6AddressValidation.formatException(string3, "v6");
        }
        if (string.startsWith(":") && !string.startsWith("::") || string.endsWith(":") && !string.endsWith("::")) {
            Ipv6AddressValidation.formatException(string, "v6");
        }
        if (!Ipv6AddressValidation.isHexValue(string2 = string3.substring(n2))) {
            Ipv6AddressValidation.formatException(string3, "v6");
        }
    }

    private static boolean isHexValue(String string) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        boolean bl = false;
        if ((string = string.toLowerCase()).length() == 0) {
            return true;
        }
        if (string.length() > 4) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            bl = false;
            for (int j = 0; j < cArray.length; ++j) {
                if (string.charAt(i) != cArray[j]) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return bl;
    }

    public static boolean isProperIPv6Address(String string) throws IpFormatException {
        int n = 0;
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ':') continue;
            ++n;
        }
        if (n < 2) {
            bl = false;
        }
        return bl;
    }

    public static Inet6Address getIpv6Addres(String string) throws IpFormatException {
        try {
            if (string.equals("")) {
                return (Inet6Address)InetAddress.getLocalHost();
            }
            InetAddressUtil inetAddressUtil = new InetAddressUtil();
            byte[] byArray = inetAddressUtil.ipStringToBytes(string);
            return (Inet6Address)InetAddress.getByAddress(byArray);
        }
        catch (ClassCastException classCastException) {
            Ipv6AddressValidation.formatException(string, "v6");
        }
        catch (UnknownHostException unknownHostException) {
            Ipv6AddressValidation.formatException(string, "v6");
        }
        return null;
    }

    public static boolean isLinkLocalIpv6(String string) throws IpFormatException {
        return Ipv6AddressValidation.getIpv6Addres(string).isLinkLocalAddress();
    }

    public static boolean isUnspecifiedIpv6(String string) throws IpFormatException {
        return Ipv6AddressValidation.getIpv6Addres(string).equals(Ipv6AddressValidation.getIpv6Addres("::"));
    }

    public static boolean isGlobalUnicastIpv6(String string) throws IpFormatException {
        return !Ipv6AddressValidation.getIpv6Addres(string).isLinkLocalAddress() && !Ipv6AddressValidation.getIpv6Addres(string).isLoopbackAddress() && !Ipv6AddressValidation.getIpv6Addres(string).isMulticastAddress() && !Ipv6AddressValidation.isUnspecifiedIpv6(string);
    }

    public static boolean isLoopBackIpv6Address(String string) throws IpFormatException {
        return Ipv6AddressValidation.getIpv6Addres(string).isLoopbackAddress();
    }

    public static boolean isValidIpv6Addres(String string) {
        if (Ipv6AddressValidation.isIpv6(string)) {
            try {
                Ipv6AddressValidation.validateIpv6(string);
                return true;
            }
            catch (IpFormatException ipFormatException) {
                return false;
            }
        }
        return false;
    }

    public static boolean compareNetPrefix(String string, String string2, int n) throws IpFormatException {
        byte[] byArray = Ipv6AddressValidation.getIpv6Addres(string).getAddress();
        byte[] byArray2 = Ipv6AddressValidation.getIpv6Addres(string2).getAddress();
        byte by = 0;
        int n2 = n / 8;
        Arrays.fill(byArray, n2, 16, by);
        Arrays.fill(byArray2, n2, 16, by);
        return Arrays.equals(byArray, byArray2);
    }

    public static String getNetworkPrefix(String string, int n) throws IpFormatException {
        int n2 = n / 8;
        Inet6Address inet6Address = null;
        byte[] byArray = Ipv6AddressValidation.getIpv6Addres(string).getAddress();
        byte by = 0;
        Arrays.fill(byArray, n2, 16, by);
        try {
            inet6Address = (Inet6Address)InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            Ipv6AddressValidation.formatException(string, "v6");
        }
        return inet6Address.getHostAddress();
    }

    private static void formatException(String string, String string2) throws IpFormatException {
        throw new IpFormatException("The address " + string + " is not a valid IP" + string2 + "address");
    }
}

