/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.StringTokenizer;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.IdentityNotAllowedException;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class MoAttributeValidator {
    public static final String USERLABEL = "userLabel";
    public static final String RESERVED_BY = "reservedBy";
    public static final String ADMINISTRATIVE_STATE = "administrativeState";
    public static final String FRO_ID = "froId";
    public static final Class THIS_CLASS = MoAttributeValidator.class;

    public static Object checkAndGetMandatoryAttribute(String string, AttrList attrList, String string2, Class clazz) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n < 0) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        Object object = attrList.getValue(n);
        if (!object.getClass().equals(clazz)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        attrList.removeElementAt(n);
        return object;
    }

    public static int checkAndGetFroIdFromMoRefAttribute(String string, Object object, String string2, Coordinator coordinator) throws MoAccessException {
        if (!(object instanceof CelloMao)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        CelloMao celloMao = (CelloMao)object;
        return celloMao.getFroId(coordinator);
    }

    public static String checkAndGetStringAttribute(String string, AttrList attrList, boolean bl, String string2, String string3) throws MoAccessException {
        String string4 = MoAttributeValidator.checkAndGetStringAttributeWithLength(string, attrList, bl, string2, string3, Integer.MAX_VALUE, 0);
        return string4;
    }

    public static String checkAndGetStringAttributeWithLength(String string, AttrList attrList, boolean bl, String string2, String string3, int n, int n2) throws MoAccessException {
        int n3 = attrList.indexOf(string);
        if (bl && n3 == -1) {
            throw new AttrMissingAtCreateException(string, string3);
        }
        if (!bl && n3 == -1) {
            return string2;
        }
        if (!(attrList.getValue(n3) instanceof String)) {
            throw new WrongAttributeTypeException(string, string3);
        }
        MoAttributeValidator.checkStringWithLength((String)attrList.getValue(n3), string, string3, n, 0);
        String string4 = (String)attrList.getValue(n3);
        attrList.removeElementAt(n3);
        return string4;
    }

    public static String checkAndGetStringType(String string, AttrList attrList, String string2) throws MoAccessException {
        return (String)MoAttributeValidator.checkAndGetAttributeType(string, attrList, String.class, string2);
    }

    public static void checkStringWithLength(String string, String string2, String string3, int n, int n2) throws MoAccessException {
        if (string.length() > n || string.length() < n2) {
            throw new ValueOutOfRangeException(string2, string3);
        }
    }

    private static void isAcceptedClass(Object object, String string, String string2, String[] stringArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!object.getClass().getName().equals(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            throw new WrongAttributeTypeException(string, string2);
        }
    }

    private static void isAcceptedClass2(ManagedObject managedObject, String string, String string2, String[] stringArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!managedObject.getType().equals(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            throw new WrongAttributeTypeException(string, string2);
        }
    }

    public static int checkAndGetIntegerAttribute(String string, AttrList attrList, boolean bl, int n, int n2, int n3, String string2) throws MoAccessException {
        return MoAttributeValidator.checkAndGetIntegerAttribute(string, attrList, bl, n, new int[]{n2}, new int[]{n3}, string2);
    }

    public static int checkAndGetIntegerAttribute(String string, AttrList attrList, boolean bl, int n, int[] nArray, int[] nArray2, String string2) throws MoAccessException {
        int n2 = attrList.indexOf(string);
        if (bl && n2 == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        int n3 = (Integer)attrList.getValue(n2);
        boolean bl2 = false;
        for (int i = 0; i < nArray2.length; ++i) {
            if (n3 < nArray[i] || n3 > nArray2[i]) continue;
            bl2 = true;
        }
        if (!bl2) {
            throw new ValueOutOfRangeException(string, string2);
        }
        attrList.removeElementAt(n2);
        return n3;
    }

    public static void checkIntegerAttribute(String string, int n, int n2, int n3, String string2) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute(string, n, new int[]{n2}, new int[]{n3}, string2);
    }

    public static void checkIntegerAttribute(String string, int n, int[] nArray, int[] nArray2, String string2) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < nArray2.length; ++i) {
            if (n < nArray[i] || n > nArray2[i]) continue;
            bl = true;
        }
        if (!bl) {
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static Integer checkAndGetIntegerType(String string, AttrList attrList, String string2) throws MoAccessException {
        return (Integer)MoAttributeValidator.checkAndGetAttributeType(string, attrList, Integer.class, string2);
    }

    public static int checkAndGetEnumAttribute(String string, AttrList attrList, boolean bl, int n, int[] nArray, String string2) throws MoAccessException {
        int n2 = attrList.indexOf(string);
        if (bl && n2 == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n2 == -1) {
            if (!MoAttributeValidator.isWithinEnum(n, nArray)) {
                throw new ValueOutOfRangeException(string, string2);
            }
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        int n3 = (Integer)attrList.getValue(n2);
        if (!MoAttributeValidator.isWithinEnum(n3, nArray)) {
            throw new ValueOutOfRangeException(string, string2);
        }
        attrList.removeElementAt(n2);
        return n3;
    }

    public static void checkEnumAttribute(String string, int n, int[] nArray, String string2) throws MoAccessException {
        if (!MoAttributeValidator.isWithinEnum(n, nArray)) {
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static void checkEnumAttributeAsArray(String string, int[] nArray, int[] nArray2, String string2) throws MoAccessException {
        for (int i = 0; i < nArray.length; ++i) {
            if (MoAttributeValidator.isWithinEnum(nArray[i], nArray2)) continue;
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static boolean isWithinEnum(int n, int[] nArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static long checkAndGetLongAttribute(String string, AttrList attrList, boolean bl, long l, long l2, long l3, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (bl && n == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n == -1) {
            return l;
        }
        if (!(attrList.getValue(n) instanceof Long)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        long l4 = (Long)attrList.getValue(n);
        if (l4 < l2 || l4 > l3) {
            throw new ValueOutOfRangeException(string, string2);
        }
        attrList.removeElementAt(n);
        return l4;
    }

    public static Long checkAndGetLongType(String string, AttrList attrList, String string2) throws MoAccessException {
        return (Long)MoAttributeValidator.checkAndGetAttributeType(string, attrList, Long.class, string2);
    }

    public static boolean checkAndGetBooleanAttribute(String string, AttrList attrList, boolean bl, boolean bl2, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (bl && n == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n == -1) {
            return bl2;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        boolean bl3 = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl3;
    }

    public static Boolean checkAndGetBooleanType(String string, AttrList attrList, String string2) throws MoAccessException {
        return (Boolean)MoAttributeValidator.checkAndGetAttributeType(string, attrList, Boolean.class, string2);
    }

    public static ManagedObject checkAndGetReferenceAttribute(String string, AttrList attrList, boolean bl, Class[] classArray, String string2) throws MoAccessException {
        ManagedObject managedObject = null;
        int n = attrList.indexOf(string);
        if (bl && n == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n == -1) {
            return managedObject;
        }
        if (bl && attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (attrList.getValue(n) != null) {
            boolean bl2 = false;
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isInstance(attrList.getValue(n))) continue;
                bl2 = true;
            }
            if (!bl2) {
                throw new WrongAttributeTypeException(string, string2);
            }
        }
        managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    public static ManagedObject checkAndGetReferenceType(String string, AttrList attrList, Class[] classArray, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            return null;
        }
        if (attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isInstance(attrList.getValue(n))) continue;
            bl = true;
        }
        if (!bl) {
            throw new WrongAttributeTypeException(string, string2);
        }
        ManagedObject managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    public static ManagedObject checkAndGetReferenceAttribute(String string, AttrList attrList, boolean bl, Class clazz, String string2) throws MoAccessException {
        return MoAttributeValidator.checkAndGetReferenceAttribute(string, attrList, bl, new Class[]{clazz}, string2);
    }

    public static ManagedObject checkAndGetReferenceType(String string, AttrList attrList, Class clazz, String string2) throws MoAccessException {
        return MoAttributeValidator.checkAndGetReferenceType(string, attrList, new Class[]{clazz}, string2);
    }

    public static ManagedObject checkAndGetReferenceAttribute(String string, AttrList attrList, boolean bl, String string2) throws MoAccessException {
        ManagedObject managedObject = null;
        int n = attrList.indexOf(string);
        if (bl && n == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n == -1) {
            return managedObject;
        }
        if (bl && attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (attrList.getValue(n) != null && !(attrList.getValue(n) instanceof ManagedObject)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    public static ManagedObject checkAndGetReferenceType(String string, AttrList attrList, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            return null;
        }
        if (attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (!(attrList.getValue(n) instanceof ManagedObject)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        ManagedObject managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    public static ManagedObject checkAndGetReferenceAttribute(String string, AttrList attrList, boolean bl, String[] stringArray, String string2) throws MoAccessException {
        ManagedObject managedObject = null;
        int n = attrList.indexOf(string);
        if (bl && n == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n == -1) {
            return managedObject;
        }
        if (bl && attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (attrList.getValue(n) != null && !(attrList.getValue(n) instanceof ManagedObject)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        MoAttributeValidator.isAcceptedClass(attrList.getValue(n), string, string2, stringArray);
        managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    public static ManagedObject checkAndGetReferenceType(String string, AttrList attrList, String[] stringArray, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            return null;
        }
        if (attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (!(attrList.getValue(n) instanceof ManagedObject)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        MoAttributeValidator.isAcceptedClass(attrList.getValue(n), string, string2, stringArray);
        ManagedObject managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    public static ManagedObject checkAndGetReferenceAttribute2(String string, AttrList attrList, boolean bl, String[] stringArray, String string2) throws MoAccessException {
        ManagedObject managedObject = null;
        int n = attrList.indexOf(string);
        if (bl && n == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n == -1) {
            return managedObject;
        }
        if (bl && attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (attrList.getValue(n) != null) {
            if (!(attrList.getValue(n) instanceof ManagedObject)) {
                throw new WrongAttributeTypeException(string, string2);
            }
            MoAttributeValidator.isAcceptedClass2((ManagedObject)attrList.getValue(n), string, string2, stringArray);
        }
        managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    public static ManagedObject checkAndGetReferenceType2(String string, AttrList attrList, String string2, String string3) throws MoAccessException {
        return MoAttributeValidator.checkAndGetReferenceType2(string, attrList, new String[]{string2}, string3);
    }

    public static ManagedObject checkAndGetReferenceType2(String string, AttrList attrList, String[] stringArray, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            return null;
        }
        if (attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (!(attrList.getValue(n) instanceof ManagedObject)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        MoAttributeValidator.isAcceptedClass2((ManagedObject)attrList.getValue(n), string, string2, stringArray);
        ManagedObject managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    public static ManagedObject[] checkAndGetRefArrayType(String string, AttrList attrList, String string2, String string3) throws MoAccessException {
        return MoAttributeValidator.checkAndGetRefArrayType(string, attrList, new String[]{string2}, string3);
    }

    public static ManagedObject[] checkAndGetRefArrayType(String string, AttrList attrList, String[] stringArray, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            return null;
        }
        if (attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (!(attrList.getValue(n) instanceof ManagedObject[])) {
            throw new WrongAttributeTypeException(string, string2);
        }
        ManagedObject[] managedObjectArray = (ManagedObject[])attrList.getValue(n);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            MoAttributeValidator.isAcceptedClass2(managedObjectArray[i], string, string2, stringArray);
        }
        attrList.removeElementAt(n);
        return managedObjectArray;
    }

    public static void checkParent(ManagedObject managedObject, String string) throws MoAccessException {
        if (!managedObject.getType().equals(string)) {
            throw new IllegalParentException(string);
        }
    }

    public static void checkParents(ManagedObject managedObject, String[] stringArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!managedObject.getType().equals(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalParentException(managedObject.getType());
        }
    }

    public static void checkTransaction(Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
    }

    public static int getTransactionId(Coordinator coordinator) {
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        return n;
    }

    public static void checkOtherAttributes(AttrList attrList, String string) throws NoSuchAttributeException {
        int n = attrList.size();
        if (n != 0) {
            throw new NoSuchAttributeException(attrList.getName(0), string);
        }
    }

    public static void checkIdentity(String string, String string2) throws IdentityNotAllowedException {
        if (string2 == null || string2.equals("")) {
            throw new IdentityNotAllowedException(string);
        }
    }

    public static void checkCardinality(String string, int n) throws MaxNumberExceededException {
        MoIterator moIterator = MoRepository.instance().lookupType(string);
        if (moIterator != null && moIterator.size() >= n) {
            throw new MaxNumberExceededException(string, "Max number of this MO is exceeded");
        }
    }

    public static void checkNoOfSiblings(ManagedObject managedObject, String string, int n) throws MaxNumberExceededException {
        MoIterator moIterator = managedObject.getChildren();
        int n2 = 0;
        for (int i = 0; i < moIterator.size(); ++i) {
            if (!moIterator.nextMo().getType().equals(string) || ++n2 < n) continue;
            throw new MaxNumberExceededException(string, "Max number of this MO is exceeded. Max number=" + n + ", parent=" + managedObject.getType());
        }
    }

    public static void checkNumberOfMoTypes(String string, String[] stringArray, int n) throws MaxNumberExceededException {
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            MoIterator moIterator = MoRepository.instance().lookupType(stringArray[i]);
            if (moIterator == null) continue;
            n2 += moIterator.size();
        }
        if (n2 >= n) {
            throw new MaxNumberExceededException(string, "Max number of this MO is exceeded");
        }
    }

    public static String formatProductNumber(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringBuffer.toString(), "/");
            String string2 = "";
            while (stringTokenizer2.hasMoreElements()) {
                String string3 = stringTokenizer2.nextToken();
                if (!string3.startsWith("CXC")) continue;
                string2 = string3;
            }
            if (string2.equals("")) {
                return null;
            }
            return string2;
        }
        return null;
    }

    private static Object checkAndGetAttributeType(String string, AttrList attrList, Class clazz, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            return null;
        }
        if (!attrList.getValue(n).getClass().equals(clazz)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        Object object = attrList.getValue(n);
        attrList.removeElementAt(n);
        return object;
    }

    public static Struct[] checkAndGetArrayOfStructs(String string, AttrList attrList, boolean bl, int n, int n2, String string2) throws MoAccessException {
        int n3 = attrList.indexOf(string);
        if (bl && n3 == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n3 == -1) {
            return new Struct[0];
        }
        if (attrList.getValue(n3) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        Object object = attrList.getValue(n3);
        if (!object.getClass().isArray()) {
            throw new WrongAttributeTypeException(string, string2);
        }
        if (!(object instanceof Struct[])) {
            throw new WrongAttributeTypeException(string, string2);
        }
        Object[] objectArray = (Object[])object;
        boolean bl2 = true;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Struct) continue;
            bl2 = false;
        }
        if (!bl2) {
            throw new WrongAttributeTypeException(string + " is expected to contain array of structs", string2);
        }
        if (objectArray.length < n) {
            throw new ValueOutOfRangeException(string + " array is not allowed to contain less than " + n + " elements", string2);
        }
        if (objectArray.length > n2) {
            throw new ValueOutOfRangeException(string + " array is not allowed to contain more than " + n2 + " elements", string2);
        }
        attrList.removeElementAt(n3);
        return (Struct[])objectArray;
    }

    public static Struct checkAndGetStructAttribute(String string, AttrList attrList, boolean bl, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (bl && n == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n == -1) {
            return null;
        }
        if (bl && attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        if (attrList.getValue(n) != null && !(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        Struct struct = (Struct)attrList.getValue(n);
        attrList.removeElementAt(n);
        return struct;
    }

    public static int[] checkAndGetArrayOfPrimitiveIntegers(String string, AttrList attrList, boolean bl, int n, int n2, String string2) throws MoAccessException {
        int n3 = attrList.indexOf(string);
        if (bl && n3 == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n3 == -1) {
            return new int[0];
        }
        if (attrList.getValue(n3) == null) {
            throw new ValueOutOfRangeException(string, string2);
        }
        Object object = attrList.getValue(n3);
        if (!object.getClass().isArray()) {
            throw new WrongAttributeTypeException(string, string2);
        }
        if (!(object instanceof int[])) {
            throw new WrongAttributeTypeException(string, string2);
        }
        int[] nArray = (int[])object;
        if (nArray.length < n) {
            throw new ValueOutOfRangeException(string + " array is not allowed to contain less than " + n + " elements", string2);
        }
        if (nArray.length > n2) {
            throw new ValueOutOfRangeException(string + " array is not allowed to contain more than " + n2 + " elements", string2);
        }
        attrList.removeElementAt(n3);
        return nArray;
    }

    public static int[] checkAndGetArrayOfPrimitiveIntegers(String string, AttrList attrList, boolean bl, int n, int n2, int[] nArray, String string2) throws MoAccessException {
        int[] nArray2 = MoAttributeValidator.checkAndGetArrayOfPrimitiveIntegers(string, attrList, bl, n, n2, string2);
        MoAttributeValidator.checkEnumAttributeAsArray(string, nArray2, nArray, string2);
        return nArray2;
    }
}

