/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.mao.PmRequestContextBase;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.pmapp.ExtendedMoTypeHandler;
import se.ericsson.cello.pmapp.PmAppException;
import se.ericsson.cello.pmapp.PmAppPortalImpl;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyException;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyFactory;
import se.ericsson.cello.pmapp.fropxy.Mo2FroIdTranslator;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public final class PmRequestContextImpl
extends PmRequestContextBase {
    private ArrayList requestedAttrList;
    private ArrayList pmAttrList;
    private Map proxyRegisterMap = new HashMap();
    public static final String MO_ALL_PM_ATTRIBUTES = "pmAttributes";
    public static final String MO_REQUESTED_PM_ATTRIBUTES = "requestedPmAttributes";

    public PmRequestContextImpl(ManagedObject managedObject, Map map, Coordinator coordinator) throws MoAccessException {
        super(managedObject, map, coordinator);
    }

    public void init() {
        this.pmAttrList = (ArrayList)this.getVariable(MO_ALL_PM_ATTRIBUTES);
        this.requestedAttrList = (ArrayList)this.getVariable(MO_REQUESTED_PM_ATTRIBUTES);
    }

    final void resolveProxies(Map map) throws PmAppException {
        Map map2 = ExtendedMoTypeHandler.getMoTypeMap();
        List list = (List)map2.get(this.owner.getType());
        GenericPmFroProxyFactory genericPmFroProxyFactory = PmAppPortalImpl.create().getGenericPmFroProxyFactory();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                GenericPmFroProxy genericPmFroProxy = genericPmFroProxyFactory.lookupByMoType(string);
                if (genericPmFroProxy == null) {
                    throw new PmAppException("Pm Fro proxy could not be looked up for MO type: " + this.owner.getType());
                }
                int n = Mo2FroIdTranslator.getFroId(this.owner, string);
                map.put(genericPmFroProxy, new Integer(n));
            }
        }
    }

    public String getPmAttrNameValue(String string) throws MoAccessException {
        if (!this.isResolved()) {
            throw new SoftwareErrorException((Throwable)new IllegalStateException("Unresolved proxies for request, " + this));
        }
        Iterator iterator = this.proxy2FroIdMap.keySet().iterator();
        while (iterator.hasNext()) {
            GenericPmFroProxy genericPmFroProxy = (GenericPmFroProxy)iterator.next();
            List<String> list = Arrays.asList(genericPmFroProxy.getPmAttributeNames());
            if (!list.contains(string)) continue;
            String[] stringArray = (String[])this.proxyRegisterMap.get(genericPmFroProxy);
            if (stringArray == null) {
                stringArray = this.getPmRegisterFromRes(genericPmFroProxy);
                this.proxyRegisterMap.put(genericPmFroProxy, stringArray);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].substring(0, stringArray[i].indexOf("="));
                String string3 = string2.trim();
                if (!string3.equals(string)) continue;
                return stringArray[i];
            }
        }
        return "";
    }

    public String[] getCurrentPmRegister() throws MoAccessException {
        if (!this.isResolved()) {
            throw new SoftwareErrorException((Throwable)new IllegalStateException("Unresolved proxies for request, " + this));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.proxy2FroIdMap.keySet().iterator();
        while (iterator.hasNext()) {
            GenericPmFroProxy genericPmFroProxy = (GenericPmFroProxy)iterator.next();
            String[] stringArray = (String[])this.proxyRegisterMap.get(genericPmFroProxy);
            if (stringArray == null) {
                stringArray = this.getPmRegisterFromRes(genericPmFroProxy);
                this.proxyRegisterMap.put(genericPmFroProxy, stringArray);
            }
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList.toArray(new String[0]);
    }

    String[] getPmRegisterFromRes(GenericPmFroProxy genericPmFroProxy) {
        String[] stringArray;
        int n = (Integer)this.proxy2FroIdMap.get(genericPmFroProxy);
        try {
            stringArray = genericPmFroProxy.getCurrentPmRegister(n);
        }
        catch (GenericPmFroProxyException genericPmFroProxyException) {
            MessageLog.trace((int)5, this.getClass(), (String)genericPmFroProxyException.getMessage());
            stringArray = this.generatedPmRegister(genericPmFroProxy);
        }
        return stringArray;
    }

    String[] generatedPmRegister(GenericPmFroProxy genericPmFroProxy) {
        String[] stringArray = genericPmFroProxy.translate2PmTags(genericPmFroProxy.getPmAttributeNames());
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray2[i] = genericPmFroProxy.getDictionary().lookupKey(stringArray[i]) + "=" + -1;
                continue;
            }
            catch (TagNameDictionaryException tagNameDictionaryException) {
                throw new GenericPmFroProxyException(103, 22, tagNameDictionaryException.toString());
            }
        }
        return stringArray2;
    }

    public String toString() {
        String string = "MO type:" + this.owner.getType() + ", Tx:" + (this.coordinator == null ? "null" : "" + this.coordinator.getTransactionID()) + ", attrs to fetch: " + (this.requestedAttrList == null ? "NO_INFO" : "" + this.requestedAttrList.toArray(new String[0])) + ", proxyFroIdMap: \n";
        if (this.isResolved()) {
            Iterator iterator = this.proxy2FroIdMap.keySet().iterator();
            while (iterator.hasNext()) {
                GenericPmFroProxy genericPmFroProxy = (GenericPmFroProxy)iterator.next();
                Integer n = (Integer)this.proxy2FroIdMap.get(genericPmFroProxy);
                string = string + "Key=" + n + "/Value=" + genericPmFroProxy.getFroType() + "/session=" + genericPmFroProxy.isSessionCreated() + "/fetchAttempt=" + (this.proxyRegisterMap.get(genericPmFroProxy) != null ? "success;" : "unknown,null register;");
            }
        } else {
            string = string + "EMPTY_MAP";
        }
        return string;
    }

    private boolean isResolved() {
        return !this.proxy2FroIdMap.isEmpty();
    }
}

