/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MoNotReservedByUserException;
import se.ericsson.cello.mao.MoReservedByOtherUserException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class ReservableImpl {
    private static boolean isAcceptedClass(Object object, Class[] classArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isInstance(object)) continue;
            bl = true;
        }
        return bl;
    }

    private static boolean isAcceptedClass(Object object, String[] stringArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!object.getClass().getName().equals(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    public static ReferenceAttribute findReserver(ManagedObject managedObject, Coordinator coordinator, MoData moData, SequenceAttribute sequenceAttribute) throws MoAccessException {
        moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        Enumeration enumeration = sequenceAttribute.elements();
        while (enumeration.hasMoreElements()) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
            try {
                ManagedObject managedObject2 = referenceAttribute.getValue(coordinator);
                if (!managedObject.equals(managedObject2)) continue;
                return referenceAttribute;
            }
            catch (MoRemovedException moRemovedException) {
                sequenceAttribute.removeElement((Attribute)referenceAttribute);
                referenceAttribute.setValue(null);
            }
        }
        return null;
    }

    public static SequenceAttribute reserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, SequenceAttribute sequenceAttribute) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException(string, managedObject);
        }
        if (ReservableImpl.findReserver(managedObject, coordinator, moData, sequenceAttribute) == null) {
            moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            ReferenceAttribute referenceAttribute = new ReferenceAttribute("", false);
            referenceAttribute.setValue(managedObject);
            sequenceAttribute.addElement((Attribute)referenceAttribute);
        } else {
            MessageLog.trace((int)5, (Class)ReservableImpl.class, (String)("reserve(): userId (" + managedObject + ") already reserving " + string + "/another MO."));
        }
        return sequenceAttribute;
    }

    public static SequenceAttribute reserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, SequenceAttribute sequenceAttribute, String[] stringArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, stringArray)) {
            throw new InvalidReferenceException(string, managedObject);
        }
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, sequenceAttribute);
    }

    public static SequenceAttribute reserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, SequenceAttribute sequenceAttribute, Class[] classArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, classArray)) {
            throw new InvalidReferenceException(string, managedObject);
        }
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, sequenceAttribute);
    }

    public static SequenceAttribute release(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, SequenceAttribute sequenceAttribute) throws MoAccessException {
        moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException(string, managedObject);
        }
        ReferenceAttribute referenceAttribute = ReservableImpl.findReserver(managedObject, coordinator, moData, sequenceAttribute);
        if (referenceAttribute == null) {
            MessageLog.trace((int)5, (Class)ReservableImpl.class, (String)("release(): userId (" + managedObject + ") is not reserver/has already released " + string));
        } else {
            sequenceAttribute.removeElement((Attribute)referenceAttribute);
            referenceAttribute.setValue(null);
        }
        return sequenceAttribute;
    }

    public static SequenceAttribute release(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, SequenceAttribute sequenceAttribute, String[] stringArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, stringArray)) {
            throw new InvalidReferenceException(string, managedObject);
        }
        return ReservableImpl.release(managedObject, coordinator, string, moData, sequenceAttribute);
    }

    public static SequenceAttribute release(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, SequenceAttribute sequenceAttribute, Class[] classArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, classArray)) {
            throw new InvalidReferenceException(string, managedObject);
        }
        return ReservableImpl.release(managedObject, coordinator, string, moData, sequenceAttribute);
    }

    public static ReferenceAttribute reserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException(string, managedObject);
        }
        moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject managedObject2 = referenceAttribute.getValue(coordinator);
        if (managedObject2 == null) {
            moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            referenceAttribute.setValue(managedObject);
        } else if (managedObject2 == managedObject) {
            MessageLog.trace((int)5, (Class)ReservableImpl.class, (String)("reserve(): userId (" + managedObject + ") already reserving " + string));
        } else {
            throw new MoReservedByOtherUserException(managedObject.getLocalDistinguishedName(), moData.getLocalDistinguishedName(), managedObject2.getLocalDistinguishedName());
        }
        return referenceAttribute;
    }

    public static ReferenceAttribute reserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, String[] stringArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, stringArray)) {
            throw new InvalidReferenceException(string, managedObject);
        }
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, referenceAttribute);
    }

    public static ReferenceAttribute reserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, Class[] classArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, classArray)) {
            throw new InvalidReferenceException(string, managedObject);
        }
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, referenceAttribute);
    }

    public static ReferenceAttribute trafficReserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute) throws MoAccessException {
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, referenceAttribute);
    }

    public static ReferenceAttribute trafficReserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, String[] stringArray) throws MoAccessException {
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, referenceAttribute, stringArray);
    }

    public static ReferenceAttribute trafficReserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, Class[] classArray) throws MoAccessException {
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, referenceAttribute, classArray);
    }

    public static ReferenceAttribute syncReserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute) throws MoAccessException {
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, referenceAttribute);
    }

    public static ReferenceAttribute syncReserve(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, String[] stringArray) throws MoAccessException {
        return ReservableImpl.reserve(managedObject, coordinator, string, moData, referenceAttribute, stringArray);
    }

    public static ReferenceAttribute release(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException(string, managedObject);
        }
        moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject managedObject2 = referenceAttribute.getValue(coordinator);
        if (managedObject2 == managedObject) {
            moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            referenceAttribute.setValue(null);
        } else if (managedObject2 == null) {
            MessageLog.trace((int)5, (Class)ReservableImpl.class, (String)("release(): userId (" + managedObject + ") has already released " + string));
        } else {
            throw new MoNotReservedByUserException(managedObject.getType(), managedObject2.getType());
        }
        return referenceAttribute;
    }

    public static ReferenceAttribute release(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, String[] stringArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, stringArray)) {
            throw new InvalidReferenceException(string, managedObject);
        }
        return ReservableImpl.release(managedObject, coordinator, string, moData, referenceAttribute);
    }

    public static ReferenceAttribute release(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, Class[] classArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, classArray)) {
            throw new InvalidReferenceException(string, managedObject);
        }
        return ReservableImpl.release(managedObject, coordinator, string, moData, referenceAttribute);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void reserve(ManagedObject managedObject, Coordinator coordinator, MoData moData, String string) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException(moData.getMoTypeName(), managedObject);
        }
        moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute attribute = moData.getAttribute(string);
        if (attribute.getClass().equals(SequenceAttribute.class)) {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)moData.getAttribute(string);
            if (ReservableImpl.findReserver(managedObject, coordinator, moData, sequenceAttribute) == null) {
                moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                ReferenceAttribute referenceAttribute = new ReferenceAttribute("", false);
                referenceAttribute.setValue(managedObject);
                sequenceAttribute.addElement((Attribute)referenceAttribute);
                return;
            } else {
                MessageLog.trace((int)5, (Class)ReservableImpl.class, (String)("reserve(): userId (" + managedObject + ") already reserving " + moData.getMoTypeName() + "/another MO."));
            }
            return;
        } else {
            if (!attribute.getClass().equals(ReferenceAttribute.class)) throw new WrongAttributeTypeException(string, moData.getMoTypeName());
            ManagedObject managedObject2 = ((ReferenceAttribute)moData.getAttribute(string)).getValue(coordinator);
            if (managedObject2 == null) {
                moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                ((ReferenceAttribute)moData.getAttribute(string)).setValue(managedObject);
                return;
            } else {
                if (managedObject2 != managedObject) throw new MoReservedByOtherUserException(managedObject.getLocalDistinguishedName(), moData.getLocalDistinguishedName(), managedObject2.getLocalDistinguishedName());
                MessageLog.trace((int)5, (Class)ReservableImpl.class, (String)("reserve(): userId (" + managedObject + ") already reserving " + moData.getMoTypeName()));
            }
        }
    }

    public static void reserve(ManagedObject managedObject, Coordinator coordinator, MoData moData, String string, String[] stringArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, stringArray)) {
            throw new InvalidReferenceException(moData.getMoTypeName(), managedObject);
        }
        ReservableImpl.reserve(managedObject, coordinator, moData, string);
    }

    public static void reserve(ManagedObject managedObject, Coordinator coordinator, MoData moData, String string, Class[] classArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, classArray)) {
            throw new InvalidReferenceException(moData.getMoTypeName(), managedObject);
        }
        ReservableImpl.reserve(managedObject, coordinator, moData, string);
    }

    public static void release(ManagedObject managedObject, Coordinator coordinator, MoData moData, String string) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException(moData.getMoTypeName(), managedObject);
        }
        moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute attribute = moData.getAttribute(string);
        if (attribute.getClass().equals(SequenceAttribute.class)) {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)moData.getAttribute(string);
            ReferenceAttribute referenceAttribute = ReservableImpl.findReserver(managedObject, coordinator, moData, sequenceAttribute);
            if (referenceAttribute == null) {
                MessageLog.trace((int)5, (Class)ReservableImpl.class, (String)("release(): userId (" + managedObject + ") is not reserver/has already released " + moData.getMoTypeName()));
            } else {
                moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                do {
                    sequenceAttribute.removeElement((Attribute)referenceAttribute);
                    referenceAttribute.setValue(null);
                } while ((referenceAttribute = ReservableImpl.findReserver(managedObject, coordinator, moData, sequenceAttribute)) != null);
            }
        } else if (attribute.getClass().equals(ReferenceAttribute.class)) {
            ManagedObject managedObject2 = ((ReferenceAttribute)moData.getAttribute(string)).getValue(coordinator);
            if (managedObject2 == managedObject) {
                moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                ((ReferenceAttribute)moData.getAttribute(string)).setValue(null);
            } else if (managedObject2 == null) {
                MessageLog.trace((int)5, (Class)ReservableImpl.class, (String)("release(): userId (" + managedObject + ") has already released " + moData.getMoTypeName()));
            } else {
                throw new MoNotReservedByUserException(managedObject.getType(), managedObject2.getType());
            }
        }
    }

    public static void release(ManagedObject managedObject, Coordinator coordinator, MoData moData, String string, String[] stringArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, stringArray)) {
            throw new InvalidReferenceException(moData.getMoTypeName(), managedObject);
        }
        ReservableImpl.release(managedObject, coordinator, moData, string);
    }

    public static void release(ManagedObject managedObject, Coordinator coordinator, MoData moData, String string, Class[] classArray) throws MoAccessException {
        if (!ReservableImpl.isAcceptedClass((Object)managedObject, classArray)) {
            throw new InvalidReferenceException(moData.getMoTypeName(), managedObject);
        }
        ReservableImpl.release(managedObject, coordinator, moData, string);
    }

    public static ReferenceAttribute trafficRelease(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute) throws MoAccessException {
        return ReservableImpl.release(managedObject, coordinator, string, moData, referenceAttribute);
    }

    public static ReferenceAttribute trafficRelease(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, String[] stringArray) throws MoAccessException {
        return ReservableImpl.release(managedObject, coordinator, string, moData, referenceAttribute, stringArray);
    }

    public static ReferenceAttribute trafficRelease(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, Class[] classArray) throws MoAccessException {
        return ReservableImpl.release(managedObject, coordinator, string, moData, referenceAttribute, classArray);
    }

    public static ReferenceAttribute syncRelease(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute) throws MoAccessException {
        return ReservableImpl.release(managedObject, coordinator, string, moData, referenceAttribute);
    }

    public static ReferenceAttribute syncRelease(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, String[] stringArray) throws MoAccessException {
        return ReservableImpl.release(managedObject, coordinator, string, moData, referenceAttribute, stringArray);
    }

    public static ReferenceAttribute syncRelease(ManagedObject managedObject, Coordinator coordinator, String string, MoData moData, ReferenceAttribute referenceAttribute, Class[] classArray) throws MoAccessException {
        return ReservableImpl.release(managedObject, coordinator, string, moData, referenceAttribute, classArray);
    }

    public static int noOfReservers(SequenceAttribute sequenceAttribute, String string, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (sequenceAttribute == null) {
            return 0;
        }
        Attribute[] attributeArray = sequenceAttribute.getValue(coordinator);
        for (int i = 0; i < sequenceAttribute.size(); ++i) {
            ManagedObject managedObject = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
            if (!managedObject.getClass().getName().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public static ManagedObject[] retrieveRefArrayFromSequence(SequenceAttribute sequenceAttribute, Coordinator coordinator) throws MoAccessException {
        Attribute[] attributeArray = sequenceAttribute.getValue(coordinator);
        Vector<ManagedObject> vector = new Vector<ManagedObject>();
        ReferenceAttribute referenceAttribute = null;
        for (int i = 0; i < attributeArray.length; ++i) {
            referenceAttribute = (ReferenceAttribute)attributeArray[i];
            try {
                ManagedObject managedObject = referenceAttribute.getValue(coordinator);
                vector.add(managedObject);
                continue;
            }
            catch (MoRemovedException moRemovedException) {
                // empty catch block
            }
        }
        return vector.toArray(new ManagedObject[vector.size()]);
    }

    public static Collection initReservedBy(Coordinator coordinator, String string, String string2, ManagedObject managedObject) throws MoAccessException {
        ManagedObject managedObject2 = null;
        MoRepository moRepository = MoRepository.instance();
        MoIterator moIterator = moRepository.lookupType(string);
        Vector<ManagedObject> vector = new Vector<ManagedObject>();
        if (moIterator == null) {
            return vector;
        }
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject3;
                managedObject2 = moIterator.nextMo();
                if (managedObject2 == null || (managedObject3 = (ManagedObject)managedObject2.getAttribute(string2, coordinator)) == null || !managedObject3.equals(managedObject)) continue;
                vector.add(managedObject2);
            }
        }
        return vector;
    }
}

