/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.transaction.Coordinator;

public class SetRequestContextImpl
implements SetRequestContext {
    private Map paramLists = new HashMap();
    private Coordinator coordinator = null;
    private String[] names = null;
    private Object[] values = null;
    private Map tempVars = new HashMap();
    private List notificationEntries = new ArrayList();

    public SetRequestContextImpl() {
        this(null, null, null);
    }

    public SetRequestContextImpl(String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        this.names = stringArray;
        this.values = objectArray;
        this.coordinator = coordinator;
    }

    public SetRequestContextImpl(AttrList attrList, Coordinator coordinator) throws NotHandledAttributeTypeException, MoNotFoundException {
        int n = 0;
        if (attrList != null) {
            n = attrList.size();
        }
        this.names = new String[n];
        this.values = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.names[i] = attrList.getName(i);
            this.values[i] = attrList.getValue(i);
        }
        this.coordinator = coordinator;
    }

    public void assertNoDuplicateAttributes(String string) throws MoAccessException {
        int n = this.names.length;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            string2 = this.names[i];
            if (hashSet.contains(string2)) {
                throw new NoSuchAttributeException(string2, string);
            }
            hashSet.add(string2);
        }
    }

    public void assertAllowedAttributes(String[] stringArray, String string) throws MoAccessException {
        int n = this.names.length;
        for (int i = 0; i < n; ++i) {
            if (this.isInList(this.names[i], stringArray)) continue;
            throw new NoSuchAttributeException(this.names[i], string);
        }
    }

    private boolean isInList(String string, String[] stringArray) {
        boolean bl = false;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isIncludedInRequest(String string) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public Object getAttributeFromRequest(String string) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(string)) continue;
            return this.values[i];
        }
        return null;
    }

    public void addParameter(FroProxy froProxy, Parameter parameter) {
        ArrayList<Parameter> arrayList = (ArrayList<Parameter>)this.paramLists.get(froProxy);
        if (arrayList == null) {
            arrayList = new ArrayList<Parameter>();
            this.paramLists.put(froProxy, arrayList);
        }
        arrayList.add(parameter);
    }

    public void replaceParameter(FroProxy froProxy, Parameter parameter) {
        Collection collection = (Collection)this.paramLists.get(froProxy);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Parameter parameter2 = (Parameter)iterator.next();
            if (!parameter.getName().equals(parameter2.getName())) continue;
            iterator.remove();
            break;
        }
        collection.add(parameter);
    }

    public void sendSetRequest(FroProxy froProxy, int n) throws MoAccessException {
        Collection collection = (Collection)this.paramLists.get(froProxy);
        if (collection != null && !collection.isEmpty()) {
            froProxy.setAttributes(this.getCoordinator(), n, collection);
        }
    }

    public FroData sendCreateRequest(FroProxy froProxy) throws MoAccessException {
        Collection collection = (Collection)this.paramLists.get(froProxy);
        return froProxy.create(this.getCoordinator(), collection);
    }

    public void addAvcNotification(String string, Object object) {
        this.notificationEntries.add(new NotificationEntry(string, object));
    }

    public void sendAvcNotifications(ManagedObject managedObject) {
        int n = this.notificationEntries.size();
        if (n > 0) {
            String[] stringArray = new String[n];
            Object[] objectArray = new Object[n];
            NotificationEntry notificationEntry = null;
            for (int i = 0; i < n; ++i) {
                notificationEntry = (NotificationEntry)this.notificationEntries.get(i);
                stringArray[i] = notificationEntry.attrName;
                objectArray[i] = notificationEntry.value;
            }
            NotificationSender.instance().pushAVC(managedObject, stringArray, objectArray, this.getCoordinator());
        }
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public void setVariable(Object object, Object object2) {
        this.tempVars.put(object, object2);
    }

    public Object getVariable(Object object) {
        return this.tempVars.get(object);
    }

    private static class NotificationEntry {
        public String attrName;
        public Object value;

        public NotificationEntry(String string, Object object) {
            this.attrName = string;
            this.value = object;
        }
    }
}

