/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp;

import java.util.LinkedList;
import java.util.List;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.pmapp.CelloScannerFactory;
import se.ericsson.cello.pmapp.ExtendedMoTypeHandler;
import se.ericsson.cello.pmapp.PmAppCounterCalculator;
import se.ericsson.cello.pmapp.PmAppException;
import se.ericsson.cello.pmapp.PmAppPortal;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxyFactory;
import se.ericsson.cello.pmapp.fropxy.OsePmFroProxyFactory;
import se.ericsson.cello.pmapp.fropxy.PmSignalDistributor;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.CounterCalculator;
import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.ActionListener;

public final class PmAppPortalImpl
implements PmAppPortal {
    public static final String PM_APP_PORTAL_CLASS_PROPERTY_NAME = "PmAppPortal.class";
    private PmAppCounterCalculator pmAppCounterCalculator = new PmAppCounterCalculator(this);

    public boolean startProxyWithCalculator(String string, String[] stringArray) {
        boolean bl = this.startProxy(string, stringArray);
        PmsPortalImpl.getPortal().getLoadControl().registerCounterCalculator(new String[]{string}, (CounterCalculator)this.pmAppCounterCalculator);
        this.pmAppCounterCalculator.addMoType(string);
        return bl;
    }

    public boolean startProxy(String string, String[] stringArray) {
        try {
            Object object;
            PmSignalDistributor.start(this.getGenericPmFroProxyFactory());
            LinkedList<String> linkedList = new LinkedList<String>();
            LinkedList<String[]> linkedList2 = new LinkedList<String[]>();
            LinkedList<List> linkedList3 = new LinkedList<List>();
            for (int i = 0; i < stringArray.length; ++i) {
                object = this.getGenericPmFroProxyFactory().create(stringArray[i]);
                String[] stringArray2 = object.getMoTypes();
                String string2 = ExtendedMoTypeHandler.lookupExtendedMoType(string, stringArray2);
                List list = object.getNoOfValuesPerAttribute(object.getAttributeNames());
                linkedList.add(i, string2);
                linkedList2.add(i, object.getAttributeNames());
                linkedList3.add(i, list);
            }
            ExtendedMoTypeHandler.putToMoTypeMap(string, linkedList);
            ExtendedMoTypeHandler.putToAttributeMap(string, linkedList2);
            String[] stringArray3 = ExtendedMoTypeHandler.mergeAttributes(linkedList2);
            object = ExtendedMoTypeHandler.mergeNoOfValues(linkedList3);
            PmsPortalImpl.getPortal().registerCounterTypes(string, stringArray3, (int[])object, (BasicScannerFactory)CelloScannerFactory.getInstance());
            return true;
        }
        catch (TagNameDictionaryException tagNameDictionaryException) {
            MessageLog.traceError(this.getClass(), (String)("startProxy(): Problem with pm properties file:" + stringArray), (Throwable)tagNameDictionaryException);
            return false;
        }
        catch (PmAppException pmAppException) {
            MessageLog.traceError(this.getClass(), (String)"startProxy(): Wrong specified mo type name.", (Throwable)((Object)pmAppException));
            return false;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"startProxy(): Internal or configuration problem!", (Throwable)runtimeException);
            return false;
        }
    }

    public static PmAppPortal create() {
        String string = System.getProperty(PM_APP_PORTAL_CLASS_PROPERTY_NAME);
        if (string == null) {
            return new PmAppPortalImpl();
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (PmAppPortal)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Class not found: " + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Can't instantiate: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("No access: " + illegalAccessException.getMessage());
        }
    }

    public boolean hasGenericPmProxy(String string) {
        return ExtendedMoTypeHandler.getMoTypeMap().containsKey(string);
    }

    private PmAppPortalImpl() {
    }

    public GenericPmFroProxyFactory getGenericPmFroProxyFactory() {
        return OsePmFroProxyFactory.getInstance();
    }

    public ActionListener getMoLifeCycleListener() {
        return CelloScannerFactory.getInstance();
    }

    public CelloScannerFactory getCelloScannerFactory() {
        return CelloScannerFactory.getInstance();
    }
}

