/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.aal2;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.atm.aal2.Aal2PathVccTpMo;
import se.ericsson.cello.atm.aal2.Aal2QosProfileMoImpl;
import se.ericsson.cello.atm.aal2.AalCounterMode;
import se.ericsson.cello.atm.aal2.aet_aal2pep;
import se.ericsson.cello.atm.aal2.aet_aal2pepmi;
import se.ericsson.cello.atm.aal2.aet_vccep;
import se.ericsson.cello.atm.atm.AlarmReport;
import se.ericsson.cello.atm.atm.AtmInfoExtend;
import se.ericsson.cello.atm.atm.AtmNomPmBlkSize;
import se.ericsson.cello.atm.atm.VclTpMo;
import se.ericsson.cello.atm.atm.VclTpMoImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class Aal2PathVccTpMoImpl
extends CelloMao
implements Aal2PathVccTpMo,
Reservable {
    private static FroProxy genVcCepProxy;
    private static FroProxy genAal2PepProxy;
    private static MaoFroIndicationHandler aal2pepIndicationHandler;
    private static MaoFroIndicationHandler vccepIndicationHandler;
    private static TagNameDictionary tnd;
    private AtmInfoExtend atmInfoExtend = new AtmInfoExtend();
    private MoData data;
    private static TransactionalFroIdMap froIdTable;
    private static final int MO_DATA_REVISION_51 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;
    private static final String DEFAULT_USER_LABEL = "";
    private static final int DEFAULT_TIMER_CU = 10;
    private static final int DEFAULT_ADMINISTRATIVE_STATE = 1;
    private static final boolean DEFAULT_CONTINUITY_CHECK = false;
    private static final int DEFAULT_COUNTER_MODE = 6;
    private static final int DEFAULT_NOM_PM_BLOCKSIZE = 1024;
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 1800;
    private static final int ALARM_REPORT_DEFAULT = 2;
    private static final int MAX_TIMER_CU = 100;
    private static final int DEFAULT_AVAILABLE_PROFILES = 15;
    private static final int MIN_VALUE_OF_AVAILABLE_PROFILES = 0;
    private static final int MAX_VALUE_OF_AVAILABLE_PROFILES = 15;
    private static final boolean DEFAULT_COUNTER_ACTIVATION = false;
    private static String[] vclTpClassName;
    private static String[] aal2QosProfileClassName;
    private static final int MAX_NO_AAL2PATHVCCTP = 2000;
    private static final String VCCEP_FRO_ID = "vccepFroId";
    public static final String AAL2_PEP_FRO_ID = "aal2pepFroId";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$se$ericsson$cello$atm$aal2$Aal2QosProfileMoImpl;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$se$ericsson$cello$atm$atm$VclTpMoImpl;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler, MaoFroIndicationHandler maoFroIndicationHandler2) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Aal2PathVccTp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        MoAttributeValidator.checkCardinality((String)"Aal2PathVccTp", (int)2000);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)DEFAULT_USER_LABEL, (String)"Aal2PathVccTp", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"aal2QoSAvailableProfiles", (AttrList)attrList, (boolean)false, (int)15, (int)0, (int)15, (String)"Aal2PathVccTp");
        Aal2QosProfileMoImpl aal2QosProfileMoImpl = (Aal2QosProfileMoImpl)MoAttributeValidator.checkAndGetReferenceAttribute((String)"aal2QoSProfileId", (AttrList)attrList, (boolean)true, (String[])aal2QosProfileClassName, (String)"Aal2PathVccTp");
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)MoAttributeValidator.checkAndGetReferenceAttribute((String)"vclTpId", (AttrList)attrList, (boolean)true, (Class)VclTpMo.class, (String)"Aal2PathVccTp");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)2, (String)"Aal2PathVccTp");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"aal2PathId", (AttrList)attrList, (boolean)true, (int)0, (int)1, (int)Integer.MAX_VALUE, (String)"Aal2PathVccTp");
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"aal2PathOwner", (AttrList)attrList, (boolean)true, (boolean)true, (String)"Aal2PathVccTp");
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"timerCu", (AttrList)attrList, (boolean)false, (int)10, (int)1, (int)100, (String)"Aal2PathVccTp");
        int n5 = MaoFroTypeConverter.boolean2int((boolean)MoAttributeValidator.checkAndGetBooleanAttribute((String)"continuityCheck", (AttrList)attrList, (boolean)false, (boolean)false, (String)"Aal2PathVccTp"));
        boolean bl2 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"counterActivation", (AttrList)attrList, (boolean)false, (boolean)false, (String)"Aal2PathVccTp");
        int n6 = Aal2PathVccTpMoImpl.checkAndGetAlarmReport(attrList);
        int n7 = Aal2PathVccTpMoImpl.checkAndGetCounterMode(attrList);
        int n8 = Aal2PathVccTpMoImpl.checkAndGetNomPmBlkSize(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Aal2PathVccTp");
        return new Aal2PathVccTpMoImpl(coordinator, managedObject, string, string2, vclTpMoImpl, aal2QosProfileMoImpl, n, n4, n2, n3, bl, n6, n5, n7, n8, bl2, initialMaoContext, froProxy, froProxy2, maoFroIndicationHandler, maoFroIndicationHandler2);
    }

    private Aal2PathVccTpMoImpl(Coordinator coordinator, ManagedObject managedObject, String string, String string2, VclTpMoImpl vclTpMoImpl, Aal2QosProfileMoImpl aal2QosProfileMoImpl, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, boolean bl2, InitialMaoContext initialMaoContext, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler, MaoFroIndicationHandler maoFroIndicationHandler2) throws MoAccessException {
        super(managedObject, "Aal2PathVccTp", string, coordinator, initialMaoContext);
        genVcCepProxy = froProxy2;
        genAal2PepProxy = froProxy;
        aal2pepIndicationHandler = maoFroIndicationHandler;
        vccepIndicationHandler = maoFroIndicationHandler2;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        vclTpMoImpl.reserve(this, coordinator);
        aal2QosProfileMoImpl.reserve(this, coordinator);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("vcCpFroId", vclTpMoImpl.getFroId(coordinator)));
        arrayList.add(new SignedIntParameter("alarmReport", n5));
        arrayList.add(new SignedIntParameter("continuityCheck", n6));
        arrayList.add(new SignedIntParameter("counterMode", n7));
        arrayList.add(new SignedIntParameter("nomPmBlockSize", n8));
        FroData froData = genVcCepProxy.create(coordinator, arrayList);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(VCCEP_FRO_ID, false, froData.getFroId()));
        vccepIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, froData.getFroId());
        ArrayList<SignedIntParameter> arrayList2 = new ArrayList<SignedIntParameter>();
        arrayList2.add(new SignedIntParameter("vcCpFroId", vclTpMoImpl.getFroId(coordinator)));
        arrayList2.add(new SignedIntParameter("vcCepFroId", this.getVcCepFroId(coordinator)));
        arrayList2.add(new SignedIntParameter("timerCu", n2));
        arrayList2.add(new SignedIntParameter("aal2QoSAvailableProfiles", n));
        arrayList2.add(new SignedIntParameter("administrativeState", n3));
        arrayList2.add(new SignedIntParameter("aal2QoSProfileFroId", aal2QosProfileMoImpl.getFroId(coordinator)));
        arrayList2.add(new SignedIntParameter("shutdownTimeout", 1800));
        froData = genAal2PepProxy.create(coordinator, arrayList2);
        froIdTable.put(froData.getFroId(), (ManagedObject)this, coordinator);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(AAL2_PEP_FRO_ID, false, froData.getFroId()));
        aal2pepIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, froData.getFroId());
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("reservedBy", false, null));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("aal2PathId", true, n4));
        this.data.registerPersistentAttr((Attribute)new BooleanAttribute("aal2PathOwner", true, bl));
        this.data.registerPersistentAttr((Attribute)new BooleanAttribute("counterActivation", true, bl2));
        this.data.setRevision(5100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Aal2PathVccTpMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, FroProxy froProxy2, MaoFroIndicationHandler maoFroIndicationHandler, MaoFroIndicationHandler maoFroIndicationHandler2) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        genVcCepProxy = froProxy2;
        genAal2PepProxy = froProxy;
        aal2pepIndicationHandler = maoFroIndicationHandler;
        vccepIndicationHandler = maoFroIndicationHandler2;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(VCCEP_FRO_ID);
        moDataRecoveryHelper.assertAttribute("aal2PathId");
        moDataRecoveryHelper.assertAttribute("aal2PathOwner");
        moDataRecoveryHelper.assertAttribute(AAL2_PEP_FRO_ID);
        moDataRecoveryHelper.assertAttribute("counterActivation");
        froIdTable.put(((IntegerAttribute)this.data.getAttribute(AAL2_PEP_FRO_ID)).getValue(null), (ManagedObject)this);
        vccepIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(VCCEP_FRO_ID)).getValue(null));
        aal2pepIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(AAL2_PEP_FRO_ID)).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        try {
            if (this.getReservedBy(coordinator) != null) {
                throw new MoReservedNotDeletableException("Aal2PathVccTp");
            }
        }
        catch (MoRemovedException moRemovedException) {
            MessageLog.info(this.getClass(), (String)"Deleted MO even though database is corrupt.the reserving MO was removed in a previous request");
        }
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)this.getVclTpId(coordinator);
        vclTpMoImpl.release(this, coordinator);
        Aal2QosProfileMoImpl aal2QosProfileMoImpl = (Aal2QosProfileMoImpl)this.getAal2QoSProfileId(coordinator);
        aal2QosProfileMoImpl.release(this, coordinator);
        vccepIndicationHandler.deregisterForNotifications(coordinator, this.getVcCepFroId(coordinator));
        genVcCepProxy.delete(coordinator, this.getVcCepFroId(coordinator), null);
        aal2pepIndicationHandler.deregisterForNotifications(coordinator, this.getAal2PepFroId(coordinator));
        genAal2PepProxy.delete(coordinator, this.getAal2PepFroId(coordinator), null);
        froIdTable.remove(this.getAal2PepFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public ManagedObject getVclTpId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("vclTpId", coordinator);
    }

    public void setVclTpId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vclTpId", managedObject, coordinator);
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("reservedBy", coordinator);
    }

    public boolean getContinuityCheck(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("continuityCheck", coordinator);
    }

    public void setContinuityCheck(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("continuityCheck", new Boolean(bl), coordinator);
    }

    public int getCounterMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("counterMode", coordinator);
    }

    public void setCounterMode(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("counterMode", new Integer(n), coordinator);
    }

    public int getNomPmBlocksize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("nomPmBlocksize", coordinator);
    }

    public void setNomPmBlocksize(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("nomPmBlocksize", new Integer(n), coordinator);
    }

    public int getTimerCu(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("timerCu", coordinator);
    }

    public void setTimerCu(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("timerCu", new Integer(n), coordinator);
    }

    public int getAal2PathId(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("aal2PathId", coordinator);
    }

    public void setAal2PathId(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aal2PathId", new Integer(n), coordinator);
    }

    public boolean getAal2PathOwner(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("aal2PathOwner", coordinator);
    }

    public void setAal2PathOwner(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aal2PathOwner", new Boolean(bl), coordinator);
    }

    public int getAlarmReport(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("alarmReport", coordinator);
    }

    public void setAlarmReport(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("alarmReport", new Integer(n), coordinator);
    }

    public ManagedObject getAal2QoSProfileId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("aal2QoSProfileId", coordinator);
    }

    public void setAal2QoSProfileId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aal2QoSProfileId", managedObject, coordinator);
    }

    public int getAal2QoSAvailableProfiles(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("aal2QoSAvailableProfiles", coordinator);
    }

    public void setAal2QoSAvailableProfiles(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aal2QoSAvailableProfiles", new Integer(n), coordinator);
    }

    public int getPmFwLostCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmFwLostCells", coordinator);
    }

    public int getPmFwMissinsCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmFwMissinsCells", coordinator);
    }

    public int getPmFwErrBlocks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmFwErrBlocks", coordinator);
    }

    public int getPmLostFpmCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmLostFpmCells", coordinator);
    }

    public int getPmBwLostCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmBwLostCells", coordinator);
    }

    public int getPmBwMissinsCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmBwMissinsCells", coordinator);
    }

    public int getPmBwErrBlocks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmBwErrBlocks", coordinator);
    }

    public int getPmLostBrCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmLostBrCells", coordinator);
    }

    public int getRemoteBlockingState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("remoteBlockingState", coordinator);
    }

    public boolean getCounterActivation(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("counterActivation", coordinator);
    }

    public void setCounterActivation(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("counterActivation", new Boolean(bl), coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public int getPmDiscardedEgressCpsPackets(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmDiscardedEgressCpsPackets", coordinator);
    }

    public int getPmEgressCpsPackets(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmEgressCpsPackets", coordinator);
    }

    public int getPmIngressCpsPackets(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIngressCpsPackets", coordinator);
    }

    public String getAal2PathVccTpId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("Aal2PathVccTpId", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        Map map2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("Aal2PathVccTpId")) {
                objectArray[i] = this.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("reservedBy")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2PathId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("aal2PathId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2PathOwner")) {
                objectArray[i] = new Boolean(((BooleanAttribute)this.data.getAttribute("aal2PathOwner")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2QoSProfileId")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("aal2QoSProfileFroId");
                objectArray[i] = Aal2QosProfileMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch aal2QoSProfileId reference ", "Aal2PathVccTp", "aal2QoSProfileId");
            }
            if (stringArray[i].equalsIgnoreCase(AAL2_PEP_FRO_ID)) {
                objectArray[i] = new Integer(this.getAal2PepFroId(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("timerCu")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("timerCu");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2QoSAvailableProfiles")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("aal2QoSAvailableProfiles");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("remoteBlockingState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("remoteBlockingState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("alarmReport")) {
                map2 = this.getVcFromRes(map2, coordinator);
                signedIntParameter = (SignedIntParameter)map2.get("alarmReport");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("continuityCheck")) {
                map2 = this.getVcFromRes(map2, coordinator);
                signedIntParameter = (SignedIntParameter)map2.get("continuityCheck");
                boolean bl = MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue());
                objectArray[i] = new Boolean(bl);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nomPmBlockSize")) {
                map2 = this.getVcFromRes(map2, coordinator);
                signedIntParameter = (SignedIntParameter)map2.get("nomPmBlockSize");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterMode")) {
                map2 = this.getVcFromRes(map2, coordinator);
                signedIntParameter = (SignedIntParameter)map2.get("counterMode");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vclTpId")) {
                map2 = this.getVcFromRes(map2, coordinator);
                signedIntParameter = (SignedIntParameter)map2.get("vcCpFroId");
                objectArray[i] = VclTpMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch vclTpId reference ", "Aal2PathVccTp", "vclTpId");
            }
            if (stringArray[i].equalsIgnoreCase("counterActivation")) {
                objectArray[i] = new Boolean(((BooleanAttribute)this.data.getAttribute("counterActivation")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmFwLostCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmFwLostCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmFwMissinsCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmFwMissinsCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmFwErrBlocks")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmFwErrBlocks", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmLostFpmCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmLostFpmCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmBwLostCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmBwLostCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmBwMissinsCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmBwMissinsCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmBwErrBlocks")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmBwErrBlocks", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmLostBrCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmLostBrCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmEgressCpsPackets")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmEgressCpsPackets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIngressCpsPackets")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIngressCpsPackets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmDiscardedEgressCpsPackets")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmDiscardedEgressCpsPackets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("atmInfo")) {
                objectArray[i] = this.atmInfoExtend.getAal2PathVccTpData(coordinator, this);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Aal2PathVccTp");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getVcFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getVcAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = genAal2PepProxy.getAttributes(coordinator, this.getAal2PepFroId(coordinator));
        return map;
    }

    private Map getVcAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = genVcCepProxy.getAttributes(coordinator, this.getVcCepFroId(coordinator), null);
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        ArrayList<SignedIntParameter> arrayList2 = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            Reservable reservable;
            if (objectArray[i] == null) {
                throw new WrongAttributeTypeException(stringArray[i], "Aal2PathVccTp");
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? Aal2PathVccTpMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Aal2PathVccTp");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Aal2PathVccTp", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2QoSProfileId")) {
                if (!objectArray[i].getClass().equals(class$se$ericsson$cello$atm$aal2$Aal2QosProfileMoImpl == null ? Aal2PathVccTpMoImpl.class$("se.ericsson.cello.atm.aal2.Aal2QosProfileMoImpl") : class$se$ericsson$cello$atm$aal2$Aal2QosProfileMoImpl)) {
                    throw new WrongAttributeTypeException("aal2QoSProfileId", "Aal2PathVccTp");
                }
                Aal2QosProfileMoImpl aal2QosProfileMoImpl = (Aal2QosProfileMoImpl)this.getAal2QoSProfileId(coordinator);
                aal2QosProfileMoImpl.release(this, coordinator);
                reservable = (Aal2QosProfileMoImpl)objectArray[i];
                reservable.reserve(this, coordinator);
                arrayList2.add(new SignedIntParameter("aal2QoSProfileFroId", reservable.getFroId(coordinator)));
                this.sendNotification("aal2QoSProfileId", reservable, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2QoSAvailableProfiles")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Aal2PathVccTpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("aal2QoSAvailableProfiles", "Aal2PathVccTp");
                }
                int n = (Integer)objectArray[i];
                if (n < 0 || n > 15) {
                    throw new ValueOutOfRangeException("aal2QoSAvailableProfiles", "Aal2PathVccTp");
                }
                arrayList2.add(new SignedIntParameter("aal2QoSAvailableProfiles", n));
                this.sendNotification("aal2QoSAvailableProfiles", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("timerCu")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Aal2PathVccTpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("timerCu", "Aal2PathVccTp");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"timerCu", (int)n, (int)1, (int)100, (String)"Aal2PathVccTp");
                arrayList2.add(new SignedIntParameter("timerCu", n));
                this.sendNotification("timerCu", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Aal2PathVccTpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "Aal2PathVccTp");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)2, (String)"Aal2PathVccTp");
                arrayList2.add(new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2PathId")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Aal2PathVccTpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("aal2PathId", "Aal2PathVccTp");
                }
                int n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"aal2PathId", (int)n, (int)1, (int)Integer.MAX_VALUE, (String)"Aal2PathVccTp");
                if (this.getReservedBy(coordinator) != null) {
                    throw new OperationNotAllowedException("aal2PathId cannot be set because this MO is reserved.", "Aal2PathVccTp");
                }
                ((IntegerAttribute)this.data.getAttribute("aal2PathId")).setValue(n);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2PathOwner")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? Aal2PathVccTpMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("aal2PathOwner", "Aal2PathVccTp");
                }
                boolean bl = (Boolean)objectArray[i];
                if ((Integer)this.getAttribute("administrativeState", coordinator) != 0) {
                    throw new OperationNotAllowedException("aal2PathOwner cannot be set because administrativeState is not locked.", "Aal2PathVccTp");
                }
                if (this.getReservedBy(coordinator) != null) {
                    throw new OperationNotAllowedException("aal2PathOwner cannot be set because this MO is reserved.", "Aal2PathVccTp");
                }
                ((BooleanAttribute)this.data.getAttribute("aal2PathOwner")).setValue(bl);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("continuityCheck")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? Aal2PathVccTpMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("continuityCheck", "Aal2PathVccTp");
                }
                boolean bl = (Boolean)objectArray[i];
                int n = MaoFroTypeConverter.boolean2int((boolean)bl);
                arrayList.add(new SignedIntParameter("continuityCheck", n));
                this.sendNotification("continuityCheck", new Boolean(bl), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterMode")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Aal2PathVccTpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("counterMode", "Aal2PathVccTp");
                }
                int n = Aal2PathVccTpMoImpl.rangeCheckCounterMode((Integer)objectArray[i]);
                arrayList.add(new SignedIntParameter("counterMode", n));
                this.sendNotification("counterMode", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("alarmReport")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Aal2PathVccTpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("alarmReport", "Aal2PathVccTp");
                }
                int n = Aal2PathVccTpMoImpl.rangeCheckAlarmReport((Integer)objectArray[i]);
                arrayList.add(new SignedIntParameter("alarmReport", n));
                this.sendNotification("alarmReport", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nomPmBlockSize")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Aal2PathVccTpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("nomPmBlockSize", "Aal2PathVccTp");
                }
                int n = Aal2PathVccTpMoImpl.rangeCheckNomPmBlkSize((Integer)objectArray[i]);
                arrayList.add(new SignedIntParameter("nomPmBlockSize", n));
                this.sendNotification("nomPmBlockSize", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vclTpId")) {
                if (!objectArray[i].getClass().equals(class$se$ericsson$cello$atm$atm$VclTpMoImpl == null ? Aal2PathVccTpMoImpl.class$("se.ericsson.cello.atm.atm.VclTpMoImpl") : class$se$ericsson$cello$atm$atm$VclTpMoImpl)) {
                    throw new WrongAttributeTypeException("vclTpId", "Aal2PathVccTp");
                }
                if ((Integer)this.getAttribute("administrativeState", coordinator) != 0) {
                    throw new OperationNotAllowedException("In order to set this attribute, the administrativeState must be LOCKED.", "Aal2PathVccTp");
                }
                VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)this.getVclTpId(coordinator);
                vclTpMoImpl.release(this, coordinator);
                reservable = (VclTpMoImpl)objectArray[i];
                reservable.reserve(this, coordinator);
                int n = reservable.getFroId(coordinator);
                arrayList.add(new SignedIntParameter("vcCpFroId", n));
                arrayList2.add(new SignedIntParameter("vcCpFroId", n));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterActivation")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? Aal2PathVccTpMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("counterActivation", "Aal2PathVccTp");
                }
                boolean bl = (Boolean)objectArray[i];
                if (((BooleanAttribute)this.data.getAttribute("counterActivation")).getValue(coordinator) != bl) {
                    super.setInstanceCounterActivation(bl, coordinator);
                }
                ((BooleanAttribute)this.data.getAttribute("counterActivation")).setValue(bl);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Aal2PathVccTp");
        }
        if (arrayList.size() > 0) {
            genVcCepProxy.setAttributes(coordinator, this.getVcCepFroId(coordinator), arrayList);
        }
        if (arrayList2.size() > 0) {
            genAal2PepProxy.setAttributes(coordinator, this.getAal2PepFroId(coordinator), arrayList2);
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    private static int checkAndGetAlarmReport(AttrList attrList) throws MoAccessException {
        int n = 2;
        int n2 = attrList.indexOf("alarmReport");
        if (n2 != -1) {
            if (!attrList.getValue(n2).getClass().equals(Integer.class)) {
                throw new WrongAttributeTypeException("alarmReport", "Aal2PathVccTp");
            }
            n = (Integer)attrList.getValue(n2);
            n = Aal2PathVccTpMoImpl.rangeCheckAlarmReport(n);
            attrList.removeElementAt(n2);
        }
        return Aal2PathVccTpMoImpl.rangeCheckAlarmReport(n);
    }

    private static int checkAndGetCounterMode(AttrList attrList) throws MoAccessException {
        int n = 6;
        int n2 = attrList.indexOf("counterMode");
        if (n2 != -1) {
            if (!attrList.getValue(n2).getClass().equals(Integer.class)) {
                throw new WrongAttributeTypeException("counterMode", "Aal2PathVccTp");
            }
            n = (Integer)attrList.getValue(n2);
            n = Aal2PathVccTpMoImpl.rangeCheckCounterMode(n);
            attrList.removeElementAt(n2);
        }
        return n;
    }

    private static int checkAndGetNomPmBlkSize(AttrList attrList) throws MoAccessException {
        int n = 1024;
        int n2 = attrList.indexOf("nomPmBlockSize");
        if (n2 != -1) {
            if (!attrList.getValue(n2).getClass().equals(Integer.class)) {
                throw new WrongAttributeTypeException("nomPmBlockSize", "Aal2PathVccTp");
            }
            n = (Integer)attrList.getValue(n2);
            n = Aal2PathVccTpMoImpl.rangeCheckNomPmBlkSize(n);
            attrList.removeElementAt(n2);
        }
        return n;
    }

    private static int rangeCheckAlarmReport(int n) throws MoAccessException {
        if (!AlarmReport.inRange(n)) {
            throw new ValueOutOfRangeException("alarmReport", "Aal2PathVccTp");
        }
        return n;
    }

    private static int rangeCheckCounterMode(int n) throws MoAccessException {
        if (!AalCounterMode.inRange(n)) {
            throw new ValueOutOfRangeException("counterMode", "Aal2PathVccTp");
        }
        return n;
    }

    private static int rangeCheckNomPmBlkSize(int n) throws MoAccessException {
        if (!AtmNomPmBlkSize.inRange(n)) {
            throw new ValueOutOfRangeException("nomPmBlockSize", "Aal2PathVccTp");
        }
        return n;
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(tnd);
            SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("administrativeState");
            if (signedIntParameter != null) {
                String[] stringArray = new String[]{new String("administrativeState")};
                Object[] objectArray = new Object[1];
                Integer n = new Integer(signedIntParameter.getValue());
                objectArray[0] = n;
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"parameterChanged(), attribute not in property file");
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator != null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        }
    }

    private int getVcCepFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(VCCEP_FRO_ID)).getValue(coordinator);
    }

    public int getAal2PepFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(AAL2_PEP_FRO_ID)).getValue(coordinator);
    }

    public String getType() {
        return "Aal2PathVccTp";
    }

    public int getPmFroId(String string, Coordinator coordinator) throws MoAccessException {
        if (aet_aal2pep.getExtendedMoType(this.getType()).equals(string)) {
            return this.getAal2PepFroId(coordinator);
        }
        if (aet_vccep.getExtendedMoType(this.getType()).equals(string)) {
            return this.getVcCepFroId(coordinator);
        }
        return -1;
    }

    public boolean hasCounterActivationAttribute() throws MoAccessException {
        return true;
    }

    public static Aal2PathVccTpMoImpl lookupInstance(int n, Coordinator coordinator) throws MoAccessException {
        return (Aal2PathVccTpMoImpl)froIdTable.get(n, coordinator);
    }

    static {
        aal2pepIndicationHandler = null;
        vccepIndicationHandler = null;
        tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(aet_aal2pepmi.class.getName()));
        froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
        vclTpClassName = new String[]{"se.ericsson.cello.atm.VclTpMoImpl"};
        aal2QosProfileClassName = new String[]{"se.ericsson.cello.atm.aal2.Aal2QosProfileMoImpl"};
    }
}

