/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.aal2;

import se.ericsson.cello.atm.aal2.Aal2SpMo;
import se.ericsson.cello.atm.aal2.fropxy.Aal2SpProxy;
import se.ericsson.cello.atm.aal2.fropxy.CreateAal2SpFroRsp;
import se.ericsson.cello.atm.aal2.fropxy.DeleteAal2SpFroRsp;
import se.ericsson.cello.atm.aal2.fropxy.GetAal2SpFroAttrRsp;
import se.ericsson.cello.atm.aal2.fropxy.GetAal2SpFroCountersRsp;
import se.ericsson.cello.atm.aal2.fropxy.SetAal2SpFroAttrRsp;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;

public class Aal2SpMoImpl
extends ManagedObjectBase
implements Aal2SpMo {
    private StringAttribute userLabel;
    private IntegerAttribute aal2SpFroId;
    private MoData data;
    private static Aal2SpProxy aal2SpProxy = Aal2SpProxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;
    private static final String AAL2_SP_FRO_ID = "aal2SpFroId";
    private static final String AFI_DEFAULT = "45";

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Aal2Sp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        MoIterator moIterator = MoRepository.instance().lookupType("Aal2Sp");
        if (moIterator != null && moIterator.size() >= 1) {
            throw new MaxNumberExceededException("Max number of Aal2Sp's is exceeded", "Aal2Sp");
        }
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Aal2Sp", (int)128, (int)0);
        String string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"afi", (AttrList)attrList, (boolean)false, (String)AFI_DEFAULT, (String)"Aal2Sp");
        String string4 = MoAttributeValidator.checkAndGetStringAttribute((String)"a2ea", (AttrList)attrList, (boolean)true, (String)"", (String)"Aal2Sp");
        if (string3.equals(AFI_DEFAULT) && (string4.length() > 15 || Aal2SpMoImpl.containsChars(string4))) {
            throw new ValueOutOfRangeException("Only digits are allowed in a2ea", "Aal2Sp");
        }
        int[] nArray = Aal2SpMoImpl.checkAndConvert(string4, "a2ea", 38);
        int[] nArray2 = Aal2SpMoImpl.checkAndConvert(string3, "afi", 2);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Aal2Sp");
        return new Aal2SpMoImpl(managedObject, string2, nArray, nArray2, string, coordinator);
    }

    private Aal2SpMoImpl(ManagedObject managedObject, String string, int[] nArray, int[] nArray2, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Aal2Sp", string2, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), "Aal2Sp", true, coordinator);
        this.data.setRevision(3000);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        int n = this.createAal2SpFro(coordinator, nArray, nArray2);
        this.aal2SpFroId = new IntegerAttribute(AAL2_SP_FRO_ID, false, n);
        this.data.registerPersistentAttr((Attribute)this.aal2SpFroId);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Aal2SpMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(AAL2_SP_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.aal2SpFroId = (IntegerAttribute)moData.getAttribute(AAL2_SP_FRO_ID);
    }

    private int createAal2SpFro(Coordinator coordinator, int[] nArray, int[] nArray2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        CreateAal2SpFroRsp createAal2SpFroRsp = aal2SpProxy.sendCreateFroReq(coordinator.getTransactionID(), nArray, nArray2);
        if (createAal2SpFroRsp == null) {
            throw new FroNotAccessibleException("Aal2Sp", "Aal2Sp");
        }
        if (createAal2SpFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal2Sp", "Aal2Sp", "CreateFroReq: " + aal2SpProxy.getResultMsg(createAal2SpFroRsp.getResult()), createAal2SpFroRsp.getResult());
        }
        return createAal2SpFroRsp.getFroId();
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        DeleteAal2SpFroRsp deleteAal2SpFroRsp = aal2SpProxy.sendDeleteFroReq(coordinator.getTransactionID(), this.aal2SpFroId.getValue(coordinator));
        if (deleteAal2SpFroRsp == null) {
            throw new FroNotAccessibleException("Aal2Sp", "Aal2Sp");
        }
        if (deleteAal2SpFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal2Sp", "Aal2Sp", "DeleteFroReq: " + aal2SpProxy.getResultMsg(deleteAal2SpFroRsp.getResult()), deleteAal2SpFroRsp.getResult());
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getType() {
        return "Aal2Sp";
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Aal2Sp", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setA2ea(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string2 = this.getAfi(coordinator);
        int n = 38;
        if (string2.equals(AFI_DEFAULT) && (string.length() > 15 || Aal2SpMoImpl.containsChars(string))) {
            throw new ValueOutOfRangeException("Only digits are allowed in a2ea", "Aal2Sp");
        }
        int[] nArray = Aal2SpMoImpl.checkAndConvert(string, "a2ea", 38);
        this.setFroAttributes(coordinator, nArray, Aal2SpMoImpl.checkAndConvert(string2, "afi", 2));
        String[] stringArray = new String[]{new String("a2ea")};
        Object[] objectArray = new Object[]{new String(string)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setAfi(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string2 = this.getA2ea(coordinator);
        if (string.equals(AFI_DEFAULT) && (string2.length() > 15 || Aal2SpMoImpl.containsChars(string2))) {
            throw new ValueOutOfRangeException("A2EA is currently a HEX value.Set it to a decimal value before setting AFI to default ", "Aal2Sp");
        }
        int[] nArray = Aal2SpMoImpl.checkAndConvert(string, "afi", 2);
        this.setFroAttributes(coordinator, Aal2SpMoImpl.checkAndConvert(string2, "a2ea", 38), nArray);
        String[] stringArray = new String[]{new String("afi")};
        Object[] objectArray = new Object[]{new String(string)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getA2ea(Coordinator coordinator) throws MoAccessException {
        GetAal2SpFroAttrRsp getAal2SpFroAttrRsp = this.getAllFroAttributes(coordinator);
        int[] nArray = getAal2SpFroAttrRsp.getA2ea();
        int n = 0;
        while (nArray[n] != 0) {
            ++n;
        }
        if (n < 1) {
            n = 1;
        } else if (n > 38) {
            n = 38;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return new String(cArray);
    }

    public String getAfi(Coordinator coordinator) throws MoAccessException {
        GetAal2SpFroAttrRsp getAal2SpFroAttrRsp = this.getAllFroAttributes(coordinator);
        int[] nArray = getAal2SpFroAttrRsp.getAfi();
        int n = 0;
        while (nArray[n] != 0) {
            ++n;
        }
        if (n < 1) {
            n = 1;
        } else if (n > 2) {
            n = 2;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return new String(cArray);
    }

    public int getAal2SpFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.aal2SpFroId.getValue(coordinator);
    }

    public int getPmUnSuccessfulConnsInternal(Coordinator coordinator) throws MoAccessException {
        GetAal2SpFroCountersRsp getAal2SpFroCountersRsp = this.getPmCounters(coordinator);
        return getAal2SpFroCountersRsp.getUnSuccConnsInternal();
    }

    public int getPmUnsuccessfulConnsInternal(Coordinator coordinator) throws MoAccessException {
        GetAal2SpFroCountersRsp getAal2SpFroCountersRsp = this.getPmCounters(coordinator);
        return getAal2SpFroCountersRsp.getUnSuccConnsInternal();
    }

    private GetAal2SpFroCountersRsp getPmCounters(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetAal2SpFroCountersRsp getAal2SpFroCountersRsp = aal2SpProxy.sendGetCountersReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.aal2SpFroId.getValue(coordinator));
        if (getAal2SpFroCountersRsp == null) {
            throw new FroNotAccessibleException("Aal2Sp", "Aal2Sp");
        }
        if (getAal2SpFroCountersRsp.getResult() == 100) {
            getAal2SpFroCountersRsp.setPmCountersUnavailable();
        } else if (getAal2SpFroCountersRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal2Sp", "Aal2Sp", "GetPmCountersReq: " + aal2SpProxy.getResultMsg(getAal2SpFroCountersRsp.getResult()), getAal2SpFroCountersRsp.getResult());
        }
        return getAal2SpFroCountersRsp;
    }

    private void setFroAttributes(Coordinator coordinator, int[] nArray, int[] nArray2) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SetAal2SpFroAttrRsp setAal2SpFroAttrRsp = aal2SpProxy.sendSetAttrReq(coordinator.getTransactionID(), this.aal2SpFroId.getValue(coordinator), nArray, nArray2);
        if (setAal2SpFroAttrRsp == null) {
            throw new FroNotAccessibleException("Aal2Sp", "setFroAttributes");
        }
        if (setAal2SpFroAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal2Sp", "Aal2Sp", "SetFroAttr: " + aal2SpProxy.getResultMsg(setAal2SpFroAttrRsp.getResult()), setAal2SpFroAttrRsp.getResult());
        }
    }

    private GetAal2SpFroAttrRsp getAllFroAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetAal2SpFroAttrRsp getAal2SpFroAttrRsp = aal2SpProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.aal2SpFroId.getValue(coordinator));
        if (getAal2SpFroAttrRsp == null) {
            throw new FroNotAccessibleException("Aal2Sp", "Aal2Sp");
        }
        if (getAal2SpFroAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal2Sp", "Aal2Sp", "GetAttrReq: " + aal2SpProxy.getResultMsg(getAal2SpFroAttrRsp.getResult()), getAal2SpFroAttrRsp.getResult());
        }
        return getAal2SpFroAttrRsp;
    }

    private static int[] checkAndConvert(String string, String string2, int n) throws MoAccessException {
        int n2;
        int n3 = 1;
        int n4 = n;
        if (string.length() < n3 || string.length() > n4) {
            throw new ValueOutOfRangeException(string2 + " is not in the size limits ", "Aal2Sp");
        }
        int[] nArray = new int[n4 + 1];
        String string3 = "0123456789abcdefABCDEF";
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (string3.indexOf(c) < 0) {
                throw new ValueOutOfRangeException("Not allowed character " + c + " in " + string2, "Aal2Sp");
            }
            nArray[n2] = c;
        }
        if (nArray[0] == 48) {
            throw new ValueOutOfRangeException("Not allowed to use leading zeros in " + string2, "Aal2Sp");
        }
        return nArray;
    }

    private static boolean containsChars(String string) {
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) {
                bl = true;
                break;
            }
            bl = false;
        }
        return bl;
    }
}

