/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import java.util.ArrayList;
import se.ericsson.cello.atm.atm.AtmPortMoImpl;
import se.ericsson.cello.atm.atm.ImaGroupMo;
import se.ericsson.cello.atm.atm.ImaLinkMoImpl;
import se.ericsson.cello.atm.atm.fropxy.AetImaGroupMiCreateRsp;
import se.ericsson.cello.atm.atm.fropxy.AetImaGroupMiDeleteRsp;
import se.ericsson.cello.atm.atm.fropxy.AetImaGroupMiGetAttrRsp;
import se.ericsson.cello.atm.atm.fropxy.AetImaGroupMiGetPmCountersRsp;
import se.ericsson.cello.atm.atm.fropxy.AetImaGroupMiProxy;
import se.ericsson.cello.atm.atm.fropxy.AetImaGroupMiSetAttrRsp;
import se.ericsson.cello.atm.terminations.Ds0BundleMoImpl;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IntArrayList;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.E1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.E1TtpMo;
import se.ericsson.cello.pdhsdhtrans.ImaReservable;
import se.ericsson.cello.pdhsdhtrans.J1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.T1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.T1TtpMo;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.transaction.Coordinator;

public class ImaGroupMoImpl
extends ManagedObjectBase
implements ImaGroupMo,
TrafficReservable {
    private MoData data;
    private StringAttribute userLabel;
    private SequenceAttribute physicalPortList;
    private ReferenceAttribute reservedBy;
    private IntegerAttribute imaGroupFroId;
    private static AetImaGroupMiProxy imaGroupProxy = AetImaGroupMiProxy.instance();
    private static TransactionalFroIdMap froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private static final int MO_DATA_REVISION_36 = 3600;
    private static final int MO_DATA_REVISION_50 = 5000;
    private static final int MO_DATA_REVISION_LATEST = 5000;
    private static final int REQUIRED_NUMBER_OF_LINKS_MIN = 1;
    private static final int REQUIRED_NUMBER_OF_LINKS_MAX = 28;
    private static final int REQUIRED_NUMBER_OF_LINKS_DEFAULT = 1;
    private static final String USER_LABEL_DEFAULT = "";
    private static final int IMAGROUP_MAX_PHYPORT = 28;
    private static final int IMAGROUP_MAX_IMALINKS = 28;
    public static final int MAX_NUMBER_OF_IMAGROUP = 200;
    private static final int ATTR_REQUIRED_NUMBER_OF_LINKS = 1;
    private static final int ATTR_PHYSICAL_PORT_LIST = 2;
    private static final int AET_IMAGROUPMI_RSP_OK = 0;
    private static final String IMAGROUP_FROID = "imaGroupFroId";

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"ImaGroup", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)USER_LABEL_DEFAULT, (String)"ImaGroup", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"requiredNumberOfLinks", (AttrList)attrList, (boolean)false, (int)1, (int)1, (int)28, (String)"ImaGroup");
        ManagedObject[] managedObjectArray = ImaGroupMoImpl.checkAndGetPhysicalPortList(attrList, n, coordinator);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"ImaGroup");
        return new ImaGroupMoImpl(managedObject, string, string2, managedObjectArray, n, coordinator);
    }

    private ImaGroupMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject[] managedObjectArray, int n, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "ImaGroup", string, coordinator);
        String string3;
        int n2;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        int[] nArray = new int[managedObjectArray.length];
        ManagedObject managedObject2 = null;
        for (n2 = 0; n2 < managedObjectArray.length; ++n2) {
            if (((TrafficReservable)managedObjectArray[n2]).getReservedByTraffic(coordinator) != null) {
                managedObject2 = ((TrafficReservable)managedObjectArray[n2]).getReservedByTraffic(coordinator);
                ((TrafficReservable)managedObjectArray[n2]).trafficRelease(coordinator, managedObject2);
            }
            string3 = new String(USER_LABEL_DEFAULT + (n2 + 1));
            AttrListImpl attrListImpl = new AttrListImpl(1);
            ManagedObject managedObject3 = managedObjectArray[n2];
            attrListImpl.addElement("uses", (Object)managedObject3);
            ManagedObject managedObject4 = ImaLinkMoImpl.create(this, (AttrList)attrListImpl, string3, coordinator);
            nArray[n2] = ((ImaLinkMoImpl)managedObject4).getImaLinkFroId(coordinator);
        }
        n2 = this.createImaGroupFro(coordinator, n, nArray);
        this.imaGroupFroId = new IntegerAttribute(IMAGROUP_FROID, false, n2);
        this.data.registerPersistentAttr((Attribute)this.imaGroupFroId);
        froIdTable.put(n2, (ManagedObject)this, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.physicalPortList = new SequenceAttribute("physicalPortList", true);
        this.data.registerPersistentAttr((Attribute)this.physicalPortList);
        string3 = null;
        this.reservedBy = new ReferenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.reservedBy.setValue(null);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            string3 = new ReferenceAttribute(USER_LABEL_DEFAULT, false, managedObjectArray[i]);
            this.moveUsesDeleteDs0Bundle(managedObjectArray[i], coordinator);
            this.physicalPortList.addElement((Attribute)string3);
        }
        if (managedObject2 != null) {
            ((AtmPortMoImpl)managedObject2).setAttribute("uses", this, coordinator);
        }
        this.data.setRevision(5000);
        imaGroupProxy.registerForNotifications(coordinator, this, this.imaGroupFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private void moveUsesDeleteDs0Bundle(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2;
            ManagedObject managedObject3 = moIterator.nextMo();
            if (!managedObject3.getType().equals("Ds0Bundle") || ((Ds0BundleMoImpl)managedObject3).getReservedBy(coordinator) == null || !(managedObject2 = ((Ds0BundleMoImpl)managedObject3).getReservedBy(coordinator)).getType().equals("AtmPort")) continue;
            ((AtmPortMoImpl)managedObject2).setAttribute("uses", this, coordinator);
        }
    }

    public ImaGroupMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5000);
        moDataRecoveryHelper.assertAttribute(IMAGROUP_FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("physicalPortList");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.imaGroupFroId = (IntegerAttribute)moData.getAttribute(IMAGROUP_FROID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.physicalPortList = (SequenceAttribute)moData.getAttribute("physicalPortList");
        this.reservedBy = (ReferenceAttribute)moData.getAttribute("reservedBy");
        froIdTable.put(this.imaGroupFroId.getValue(null), (ManagedObject)this);
        imaGroupProxy.registerForNotifications(null, this, this.imaGroupFroId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedBy.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("ImaGroup");
        }
        int n = this.imaGroupFroId.getValue(coordinator);
        imaGroupProxy.deregisterForNotifications(coordinator, n);
        this.deleteImaGroupFro(coordinator);
        froIdTable.remove(n, coordinator);
        MoIterator moIterator = this.getChildren();
        for (int i = 0; i < moIterator.size(); ++i) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof ImaLinkMoImpl)) continue;
            ((ImaLinkMoImpl)managedObject).deleteMo(coordinator);
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"ImaGroup", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public ManagedObject[] getPhysicalPortList(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.physicalPortList.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[this.physicalPortList.size()];
        for (int i = 0; i < this.physicalPortList.size(); ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public void setPhysicalPortList(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObjectArray == null) {
            throw new ValueOutOfRangeException("physicalPortList", "ImaGroup");
        }
        int n = this.getRequiredNumberOfLinks(coordinator);
        ImaGroupMoImpl.checkPhysicalPortList(managedObjectArray, n, coordinator);
        this.checkPureAddOrRemove(managedObjectArray);
        this.updateImaLinks(managedObjectArray, coordinator);
        ReferenceAttribute[] referenceAttributeArray = new ReferenceAttribute[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            referenceAttributeArray[i] = new ReferenceAttribute(USER_LABEL_DEFAULT, false, managedObjectArray[i]);
        }
        this.physicalPortList.setValue((Attribute[])referenceAttributeArray);
    }

    public int getRequiredNumberOfLinks(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaGroupMiGetAttrRsp aetImaGroupMiGetAttrRsp = this.getImaGroupFroAttributes(coordinator);
        return aetImaGroupMiGetAttrRsp.getReqNumberOfLinks();
    }

    public void setRequiredNumberOfLinks(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 1 || n > 28) {
            throw new ValueOutOfRangeException("requiredNumberOfLinks", "ImaGroup");
        }
        if (this.physicalPortList.size() < n) {
            throw new ValueOutOfRangeException("requiredNumberOfLinks", "ImaGroup");
        }
        this.setImaGroupAttributes(coordinator, n, 0, null, 1);
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        ManagedObject[] managedObjectArray = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("requiredNumberOfLinks")) {
                bl = true;
                n3 = (Integer)objectArray[n];
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("physicalPortList")) continue;
            bl2 = true;
            managedObjectArray = (ManagedObject[])objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            Object[] objectArray2;
            Object[] objectArray3;
            if (stringArray[n].equalsIgnoreCase("userLabel")) {
                objectArray3 = (ManagedObject[])objectArray[n];
                MoAttributeValidator.checkStringWithLength((String)objectArray3, (String)"userLabel", (String)"ImaGroup", (int)128, (int)0);
                this.userLabel.setValue((String)objectArray3);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("requiredNumberOfLinks")) {
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"requiredNumberOfLinks", (int)n2, (int)1, (int)28, (String)"ImaGroup");
                if (bl2 ? managedObjectArray.length < n2 : this.physicalPortList.size() < n2) {
                    throw new ValueOutOfRangeException("requiredNumberOfLinks", "ImaGroup");
                }
                this.setImaGroupAttributes(coordinator, n2, 0, null, 1);
                objectArray3 = new String[]{"requiredNumberOfLinks"};
                objectArray2 = new Object[]{new Integer(n2)};
                NotificationSender.instance().pushAVC((ManagedObject)this, (String[])objectArray3, objectArray2, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("physicalPortList")) {
                objectArray3 = (ManagedObject[])objectArray[n];
                if (objectArray3 == null) {
                    throw new ValueOutOfRangeException("physicalPortList", "ImaGroup");
                }
                if (bl) {
                    ImaGroupMoImpl.checkPhysicalPortList(objectArray3, n3, coordinator);
                } else {
                    ImaGroupMoImpl.checkPhysicalPortList(objectArray3, this.getRequiredNumberOfLinks(coordinator), coordinator);
                }
                this.checkPureAddOrRemove((ManagedObject[])objectArray3);
                this.updateImaLinks((ManagedObject[])objectArray3, coordinator);
                objectArray2 = new ReferenceAttribute[objectArray3.length];
                for (int i = 0; i < objectArray3.length; ++i) {
                    objectArray2[i] = new ReferenceAttribute(USER_LABEL_DEFAULT, false, objectArray3[i]);
                }
                this.physicalPortList.setValue((Attribute[])objectArray2);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[n], "ImaGroup");
        }
    }

    public int getActiveLinks(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaGroupMiGetAttrRsp aetImaGroupMiGetAttrRsp = this.getImaGroupFroAttributes(coordinator);
        return aetImaGroupMiGetAttrRsp.getNumberOfActiveLinks();
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        AetImaGroupMiGetAttrRsp aetImaGroupMiGetAttrRsp = this.getImaGroupFroAttributes(coordinator);
        return aetImaGroupMiGetAttrRsp.getOperationalState();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        AetImaGroupMiGetAttrRsp aetImaGroupMiGetAttrRsp = this.getImaGroupFroAttributes(coordinator);
        return AvailConverter.convert((int)aetImaGroupMiGetAttrRsp.getAvailabilityStatus());
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.imaGroupFroId.getValue(coordinator);
    }

    public int getPmGrUasIma(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaGroupMiGetPmCountersRsp aetImaGroupMiGetPmCountersRsp = this.getImaGroupPmCounters(coordinator);
        return aetImaGroupMiGetPmCountersRsp.getPmGrUasIma();
    }

    public int getPmGrFc(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaGroupMiGetPmCountersRsp aetImaGroupMiGetPmCountersRsp = this.getImaGroupPmCounters(coordinator);
        return aetImaGroupMiGetPmCountersRsp.getPmGrFc();
    }

    public int getPmGrFcFe(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaGroupMiGetPmCountersRsp aetImaGroupMiGetPmCountersRsp = this.getImaGroupPmCounters(coordinator);
        return aetImaGroupMiGetPmCountersRsp.getPmGrFcFe();
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBy.getValue(coordinator);
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBy.getValue(coordinator);
    }

    public String getType() {
        return "ImaGroup";
    }

    private int createImaGroupFro(Coordinator coordinator, int n, int[] nArray) throws MoAccessException {
        int n2;
        int n3 = nArray.length;
        long[] lArray = new long[28];
        for (n2 = 0; n2 < n3; ++n2) {
            lArray[n2] = nArray[n2];
        }
        for (n2 = n3; n2 < 28; ++n2) {
            lArray[n2] = 0L;
        }
        AetImaGroupMiCreateRsp aetImaGroupMiCreateRsp = imaGroupProxy.sendAetImaGroupMiCreateReq(coordinator.getTransactionID(), n, n3, lArray);
        if (aetImaGroupMiCreateRsp == null) {
            throw new FroNotAccessibleException("ImaGroup", "createImaGroupFro");
        }
        if (aetImaGroupMiCreateRsp.getResult() == 14) {
            throw new MaxNumberExceededException("ImaGroup", "The limit of possible number of ImaGroups is exceeded.");
        }
        if (aetImaGroupMiCreateRsp.getResult() == 15) {
            throw new MaxNumberExceededException("ImaGroup", "The limit of possible number of links per group is exceeded.");
        }
        if (aetImaGroupMiCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaGroup", "ImaGroup", "CreateFroReq: " + imaGroupProxy.getResultString(aetImaGroupMiCreateRsp.getResult()), aetImaGroupMiCreateRsp.getResult());
        }
        return aetImaGroupMiCreateRsp.getFroId();
    }

    private void deleteImaGroupFro(Coordinator coordinator) throws MoAccessException {
        AetImaGroupMiDeleteRsp aetImaGroupMiDeleteRsp = imaGroupProxy.sendAetImaGroupMiDeleteReq(coordinator.getTransactionID(), this.imaGroupFroId.getValue(coordinator));
        if (aetImaGroupMiDeleteRsp == null) {
            throw new FroNotAccessibleException("ImaGroup", "deleteImaGroupFro");
        }
        if (aetImaGroupMiDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaGroup", "ImaGroup", "DeleteFroReq: " + imaGroupProxy.getResultString(aetImaGroupMiDeleteRsp.getResult()), aetImaGroupMiDeleteRsp.getResult());
        }
    }

    private AetImaGroupMiGetAttrRsp getImaGroupFroAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaGroupMiGetAttrRsp aetImaGroupMiGetAttrRsp = imaGroupProxy.sendAetImaGroupMiGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.imaGroupFroId.getValue(coordinator));
        if (aetImaGroupMiGetAttrRsp == null) {
            throw new FroNotAccessibleException("ImaGroup", "getImaGroupFroAttributes");
        }
        if (aetImaGroupMiGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaGroup", "ImaGroup", "GetAttrReq: " + imaGroupProxy.getResultString(aetImaGroupMiGetAttrRsp.getResult()), aetImaGroupMiGetAttrRsp.getResult());
        }
        return aetImaGroupMiGetAttrRsp;
    }

    private AetImaGroupMiGetPmCountersRsp getImaGroupPmCounters(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AetImaGroupMiGetPmCountersRsp aetImaGroupMiGetPmCountersRsp = imaGroupProxy.sendAetImaGroupMiGetPmCountersReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.imaGroupFroId.getValue(coordinator));
        if (aetImaGroupMiGetPmCountersRsp == null) {
            throw new FroNotAccessibleException("ImaGroup", "GetImaGroupPmCounters");
        }
        if (aetImaGroupMiGetPmCountersRsp.getResult() == 100) {
            aetImaGroupMiGetPmCountersRsp.setPmCountersUnavailable();
        } else if (aetImaGroupMiGetPmCountersRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaGroup", "ImaGroup", "GetPmCountersReq: " + imaGroupProxy.getResultString(aetImaGroupMiGetPmCountersRsp.getResult()), aetImaGroupMiGetPmCountersRsp.getResult());
        }
        return aetImaGroupMiGetPmCountersRsp;
    }

    private void setImaGroupAttributes(Coordinator coordinator, int n, int n2, int[] nArray, int n3) throws MoAccessException {
        int n4;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        long[] lArray = new long[28];
        for (n4 = 0; n4 < n2; ++n4) {
            lArray[n4] = nArray[n4];
        }
        for (n4 = n2; n4 < 28; ++n4) {
            lArray[n4] = 0L;
        }
        AetImaGroupMiSetAttrRsp aetImaGroupMiSetAttrRsp = imaGroupProxy.sendAetImaGroupMiSetAttrReq(coordinator.getTransactionID(), this.imaGroupFroId.getValue(coordinator), n, n2, n3, lArray);
        if (aetImaGroupMiSetAttrRsp == null) {
            throw new FroNotAccessibleException("ImaGroup", "setImaGroupAttributes");
        }
        if (aetImaGroupMiSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("ImaGroup", "ImaGroup", "SetAttrReq: " + imaGroupProxy.getResultString(aetImaGroupMiSetAttrRsp.getResult()), aetImaGroupMiSetAttrRsp.getResult());
        }
    }

    private static ManagedObject[] checkAndGetPhysicalPortList(AttrList attrList, int n, Coordinator coordinator) throws MoAccessException {
        int n2 = attrList.indexOf("physicalPortList");
        if (n2 == -1) {
            throw new AttrMissingAtCreateException("physicalPortList", "ImaGroup");
        }
        if (!(attrList.getValue(n2) instanceof ManagedObject[])) {
            throw new WrongAttributeTypeException("physicalPortList", "ImaGroup");
        }
        ManagedObject[] managedObjectArray = (ManagedObject[])attrList.getValue(n2);
        ImaGroupMoImpl.checkPhysicalPortList(managedObjectArray, n, coordinator);
        attrList.removeElementAt(n2);
        return managedObjectArray;
    }

    private static void checkPhysicalPortList(ManagedObject[] managedObjectArray, int n, Coordinator coordinator) throws MoAccessException {
        int n2;
        if (managedObjectArray.length > 28) {
            throw new ValueOutOfRangeException("physicalPortList", "ImaGroup");
        }
        if (managedObjectArray.length < n) {
            throw new ValueOutOfRangeException("physicalPortList", "ImaGroup");
        }
        for (n2 = 0; n2 < managedObjectArray.length; ++n2) {
            if (managedObjectArray[n2] instanceof ImaReservable) continue;
            throw new WrongAttributeTypeException("physicalPortList", "ImaGroup");
        }
        for (n2 = 0; n2 < managedObjectArray.length; ++n2) {
            if (managedObjectArray[n2].getType().equals(managedObjectArray[0].getType())) continue;
            throw new WrongAttributeTypeException("physicalPortList", "ImaGroup");
        }
        n2 = 0;
        ManagedObject managedObject = null;
        ManagedObject managedObject2 = null;
        for (n2 = 0; n2 < managedObjectArray.length; ++n2) {
            if (managedObjectArray[n2] instanceof T1PhysPathTermMo || managedObjectArray[n2] instanceof J1PhysPathTermMo || managedObjectArray[n2] instanceof E1PhysPathTermMo) {
                if (n2 == 0) {
                    managedObject = managedObjectArray[0].getParent();
                } else {
                    managedObject2 = managedObjectArray[n2].getParent();
                }
            } else if (managedObjectArray[n2] instanceof E1TtpMo) {
                if (n2 == 0) {
                    managedObject = managedObjectArray[n2].getParent().getParent().getParent().getParent();
                } else {
                    managedObject2 = managedObjectArray[n2].getParent().getParent().getParent().getParent();
                }
            } else if (managedObjectArray[n2] instanceof T1TtpMo) {
                if (n2 == 0) {
                    managedObject = managedObjectArray[n2].getParent().getParent().getParent().getParent();
                } else {
                    managedObject2 = managedObjectArray[n2].getParent().getParent().getParent().getParent();
                }
            }
            if (n2 == 0 || managedObject2 == managedObject) continue;
            throw new ValueOutOfRangeException("physicalPortList", "ImaGroup");
        }
        for (n2 = 0; n2 < managedObjectArray.length; ++n2) {
            for (int i = n2 + 1; i < managedObjectArray.length; ++i) {
                if (managedObjectArray[n2] != managedObjectArray[i]) continue;
                throw new IllegalAttributeValueException("Duplicate phyports in phyPortList", "physicalPortList", "ImaGroup");
            }
        }
        ManagedObject managedObject3 = null;
        for (n2 = 0; n2 < managedObjectArray.length; ++n2) {
            ManagedObject managedObject4 = ((TrafficReservable)managedObjectArray[n2]).getReservedByTraffic(coordinator);
            if (managedObject3 == null) {
                managedObject3 = managedObject4;
                continue;
            }
            if (managedObject4 == null || managedObject3 == managedObject4) continue;
            throw new IllegalAttributeValueException("Different AtmPorts reserved in phyPortList", "physicalPortList", "ImaGroup");
        }
    }

    private static boolean ifAIncludeB(ManagedObject[] managedObjectArray, ManagedObject[] managedObjectArray2) {
        for (int i = 0; i < managedObjectArray2.length; ++i) {
            boolean bl = false;
            String string = managedObjectArray2[i].getLocalDistinguishedName();
            for (int j = 0; j < managedObjectArray.length; ++j) {
                String string2 = managedObjectArray[j].getLocalDistinguishedName();
                if (!string.equals(string2)) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void checkPureAddOrRemove(ManagedObject[] managedObjectArray) throws MoAccessException {
        boolean bl = false;
        ManagedObject[] managedObjectArray2 = this.getPhysicalPortList(null);
        bl = managedObjectArray.length <= managedObjectArray2.length ? ImaGroupMoImpl.ifAIncludeB(managedObjectArray2, managedObjectArray) : ImaGroupMoImpl.ifAIncludeB(managedObjectArray, managedObjectArray2);
        if (!bl) {
            throw new ValueOutOfRangeException("physicalPortList", "ImaGroup");
        }
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBy = ReservableImpl.trafficReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"ImaGroup", (MoData)this.data, (ReferenceAttribute)this.reservedBy);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBy = ReservableImpl.trafficRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"ImaGroup", (MoData)this.data, (ReferenceAttribute)this.reservedBy);
    }

    private void updateImaLinks(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        boolean[] blArray = new boolean[managedObjectArray.length];
        IntArrayList intArrayList = new IntArrayList(managedObjectArray.length);
        ArrayList arrayList = new ArrayList(28);
        int n = this.detectOldImaLinks(managedObjectArray, blArray, intArrayList, arrayList, coordinator);
        this.createNewImaLinks(managedObjectArray, blArray, intArrayList, n, coordinator);
        this.setImaGroupAttributes(coordinator, 0, intArrayList.size(), intArrayList.toIntArray(), 2);
        this.deleteImaLinkMos(arrayList, coordinator);
    }

    private int detectOldImaLinks(ManagedObject[] managedObjectArray, boolean[] blArray, IntArrayList intArrayList, ArrayList arrayList, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        MoIterator moIterator = this.getChildren();
        ImaLinkMoImpl imaLinkMoImpl = null;
        while (moIterator.hasMoreElements()) {
            imaLinkMoImpl = (ImaLinkMoImpl)moIterator.nextElement();
            String string = imaLinkMoImpl.getNamingAttributeValue();
            int n2 = Integer.parseInt(string);
            n = Math.max(n, n2);
            ManagedObject managedObject = imaLinkMoImpl.getUses(coordinator);
            if (this.markOccuranceInList(managedObject, managedObjectArray, blArray)) {
                int n3 = imaLinkMoImpl.getImaLinkFroId(coordinator);
                intArrayList.add(n3);
                continue;
            }
            arrayList.add(imaLinkMoImpl);
        }
        return n;
    }

    private boolean markOccuranceInList(ManagedObject managedObject, ManagedObject[] managedObjectArray, boolean[] blArray) {
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObject != managedObjectArray[i]) continue;
            blArray[i] = true;
            return true;
        }
        return false;
    }

    private void deleteImaLinkMos(ArrayList arrayList, Coordinator coordinator) throws MoAccessException {
        while (!arrayList.isEmpty()) {
            ImaLinkMoImpl imaLinkMoImpl = (ImaLinkMoImpl)arrayList.remove(0);
            imaLinkMoImpl.deleteMo(coordinator);
        }
    }

    private void createNewImaLinks(ManagedObject[] managedObjectArray, boolean[] blArray, IntArrayList intArrayList, int n, Coordinator coordinator) throws MoAccessException {
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (blArray[i]) continue;
            int n2 = this.createImaLink(managedObjectArray[i], ++n, coordinator);
            intArrayList.add(n2);
        }
    }

    private int createImaLink(ManagedObject managedObject, int n, Coordinator coordinator) throws MoAccessException {
        String string = new String(USER_LABEL_DEFAULT + n);
        AttrListImpl attrListImpl = new AttrListImpl(1);
        attrListImpl.addElement("uses", (Object)managedObject);
        ManagedObject managedObject2 = ImaLinkMoImpl.create(this, (AttrList)attrListImpl, string, coordinator);
        return ((ImaLinkMoImpl)managedObject2).getImaLinkFroId(coordinator);
    }

    public static ImaGroupMoImpl lookupInstance(int n, Coordinator coordinator) throws TransactionRequiredException {
        return (ImaGroupMoImpl)froIdTable.get(n, coordinator);
    }
}

